/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.nodes.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.payara.common.nodes.actions.EnableModulesCookie;
import org.netbeans.modules.payara.common.nodes.actions.RefreshModulesCookie;
import org.netbeans.modules.payara.spi.ServerUtilities;
import org.netbeans.modules.payara.tooling.admin.ResultString;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class EnableModulesAction
extends NodeAction {
    private List<String> targets = new ArrayList<String>();

    protected void performAction(Node[] nodes) {
        if (nodes == null || nodes.length < 1) {
            return;
        }
        this.targets.clear();
        for (Node n : nodes) {
            this.targets.add(n.getDisplayName());
        }
        String aDup = EnableModulesAction.getDup(this.targets);
        if (null != aDup) {
            NotifyDescriptor.Message m = new NotifyDescriptor.Message((Object)NbBundle.getMessage(EnableModulesAction.class, (String)"ERR_HAS_DUPS", (Object)aDup), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)m);
            return;
        }
        RequestProcessor enabler = new RequestProcessor("pf-enable-module");
        for (Node node : nodes) {
            EnableModulesCookie uCookie = (EnableModulesCookie)node.getCookie(EnableModulesCookie.class);
            if (uCookie == null) continue;
            final Future<ResultString> result = uCookie.enableModule();
            final Node pNode = node.getParentNode().getParentNode();
            final Node fnode = node;
            enabler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        result.get(15000L, ServerUtilities.ACTION_TIMEOUT_UNIT);
                    }
                    catch (TimeoutException ex) {
                        Logger.getLogger("payara").log(Level.WARNING, "Enable action timed out for " + fnode.getDisplayName());
                    }
                    catch (InterruptedException ex) {
                    }
                    catch (Exception ex) {
                        Logger.getLogger("payara").log(Level.INFO, ex.getLocalizedMessage(), ex);
                    }
                    if (pNode != null) {
                        Node[] nodes;
                        for (Node node : nodes = pNode.getChildren().getNodes()) {
                            RefreshModulesCookie cookie = (RefreshModulesCookie)node.getCookie(RefreshModulesCookie.class);
                            if (cookie == null) continue;
                            cookie.refresh(null, fnode.getDisplayName());
                        }
                    }
                }
            });
        }
    }

    protected boolean enable(Node[] nodes) {
        for (Node node : nodes) {
            EnableModulesCookie cookie = (EnableModulesCookie)node.getCookie(EnableModulesCookie.class);
            if (cookie != null && !cookie.isRunning()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(EnableModulesAction.class, (String)"LBL_EnableAction");
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    static String getDup(List<String> targets) {
        HashMap<String, String> uniqTargets = new HashMap<String, String>();
        if (null == targets) {
            return null;
        }
        for (String target : targets) {
            String shortName;
            int colon = target.indexOf(":");
            if (-1 == colon) {
                colon = target.length();
            }
            if (uniqTargets.containsKey(shortName = target.substring(0, colon))) {
                return shortName;
            }
            uniqTargets.put(shortName, shortName);
        }
        return null;
    }
}

