/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.GdbInferior;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbManagerImpl.Interpreter;

/**
 * Implementation of {@link GdbInferior#starti()}
 */
public class GdbStartInstructionCommand extends AbstractLaunchGdbCommand {

	public GdbStartInstructionCommand(GdbManagerImpl manager) {
		super(manager);
	}

	/*@Override
	public Interpreter getInterpreter() {
		return Interpreter.MI2;
	}*/

	@Override
	public String encode() {
		if (getInterpreter() == Interpreter.CLI) {
			return "starti";
		}
		return "-interpreter-exec console starti";
	}
}
