/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugin.importer;

import docking.widgets.table.AbstractSortedTableModel;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.Processor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LanguageSortedTableModel
extends AbstractSortedTableModel<LanguageCompilerSpecPair> {
    static final int PROCESSOR_COL = 0;
    static final int VARIANT_COL = 1;
    static final int SIZE_COL = 2;
    static final int ENDIAN_COL = 3;
    static final int COMPILER_SPEC_COL = 4;
    static final String[] COL_NAMES = new String[]{"Processor", "Variant", "Size", "Endian", "Compiler"};
    private List<LanguageCompilerSpecPair> languageList = new ArrayList<LanguageCompilerSpecPair>();

    void setLanguages(List<LanguageCompilerSpecPair> languageList) {
        this.languageList = languageList;
        if (languageList == null) {
            this.languageList = Collections.emptyList();
        }
        this.fireTableDataChanged();
    }

    public String getName() {
        return "Languages";
    }

    public int getColumnCount() {
        return COL_NAMES.length;
    }

    public String getColumnName(int column) {
        try {
            return COL_NAMES[column];
        }
        catch (Exception e) {
            return "<<unknown>>";
        }
    }

    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Processor.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return Endian.class;
            }
            case 4: {
                return CompilerSpecDescription.class;
            }
        }
        return Object.class;
    }

    public boolean isSortable(int columnIndex) {
        return true;
    }

    public List<LanguageCompilerSpecPair> getModelData() {
        return this.languageList;
    }

    public Object getColumnValueForRow(LanguageCompilerSpecPair pair, int column) {
        try {
            switch (column) {
                case 0: {
                    return pair.getLanguageDescription().getProcessor();
                }
                case 1: {
                    return pair.getLanguageDescription().getVariant();
                }
                case 2: {
                    return pair.getLanguageDescription().getSize();
                }
                case 3: {
                    return pair.getLanguageDescription().getEndian();
                }
                case 4: {
                    return pair.getCompilerSpecDescription();
                }
            }
        }
        catch (LanguageNotFoundException e) {
            return "<LanguageNotFound>";
        }
        catch (CompilerSpecNotFoundException e) {
            return "<CompilerSpecNotFound>";
        }
        return "<unknown value>";
    }

    public LanguageCompilerSpecPair getLcsPairAtRow(int selectedRow) {
        if (this.languageList == null || selectedRow < 0 || selectedRow >= this.languageList.size()) {
            return null;
        }
        return this.languageList.get(selectedRow);
    }

    public int getFirstLcsPairIndex(LanguageCompilerSpecPair toFind) {
        if (this.languageList != null) {
            int index = 0;
            for (LanguageCompilerSpecPair pair : this.languageList) {
                if (pair.equals((Object)toFind)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }
}

