/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pef;

import ghidra.app.util.bin.format.pef.ContainerHeader;
import ghidra.app.util.bin.format.pef.ImportStateCache;
import ghidra.app.util.bin.format.pef.LoaderRelocationHeader;
import ghidra.app.util.bin.format.pef.SectionHeader;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;

public class RelocationState {
    private ContainerHeader header;
    private LoaderRelocationHeader relocationHeader;
    private ImportStateCache importState;
    private int importIndex = 0;
    private Address relocationAddress;
    private Address sectionC;
    private Address sectionD;
    private Program program;
    private Memory memory;
    private MemoryBlock[] blocks;

    public RelocationState(ContainerHeader header, LoaderRelocationHeader relocationHeader, Program program, ImportStateCache importState) {
        this.header = header;
        this.relocationHeader = relocationHeader;
        this.program = program;
        this.memory = program.getMemory();
        this.importState = importState;
        this.relocationAddress = this.getSectionToBeRelocated();
        this.sectionC = this.initializeSectionC();
        this.sectionD = this.initializeSectionD();
    }

    public void dispose() {
    }

    public void incrementImportIndex() {
        ++this.importIndex;
    }

    public void incrementRelocationAddress(int addend) {
        this.relocationAddress = this.relocationAddress.add((long)addend);
    }

    public void setRelocationAddress(Address relocationAddress) {
        this.relocationAddress = relocationAddress;
    }

    public void setSectionC(Address sectionC) {
        this.sectionC = sectionC;
    }

    public void setSectionD(Address sectionD) {
        this.sectionD = sectionD;
    }

    public int getImportIndex() {
        return this.importIndex;
    }

    public void setImportIndex(int importIndex) {
        this.importIndex = importIndex;
    }

    public Address getRelocationAddress() {
        return this.relocationAddress;
    }

    public Address getSectionC() {
        return this.sectionC;
    }

    public Address getSectionD() {
        return this.sectionD;
    }

    private Address initializeSectionC() {
        SectionHeader section = this.header.getSections().get(0);
        if (section.getSectionKind().isInstantiated()) {
            MemoryBlock sectionBlock = this.importState.getMemoryBlockForSection(section);
            return sectionBlock.getStart();
        }
        return this.program.getAddressFactory().getDefaultAddressSpace().getAddress(0L);
    }

    public void fixupMemory(Address address, Address fixupAddress, MessageLog log) {
        this.relocateMemoryAt(address, (int)fixupAddress.getOffset(), log);
        try {
            this.program.getListing().createData(address, (DataType)new PointerDataType(), 4);
        }
        catch (Exception e) {
            log.appendException((Throwable)e);
        }
    }

    public void relocateMemoryAt(Address address, int addend, MessageLog log) {
        MemoryBlock block = this.getBlockContaining(address);
        if (block == null || !block.isInitialized()) {
            return;
        }
        try {
            int value = this.memory.getInt(address);
            byte[] bytes = new byte[4];
            this.memory.getBytes(address, bytes);
            long[] values = new long[]{addend};
            String symbolName = null;
            this.program.getRelocationTable().add(address, -1, values, bytes, symbolName);
            this.memory.setInt(address, value += addend);
        }
        catch (MemoryAccessException e) {
            log.appendMsg("Unable to perform change memory at " + address);
        }
    }

    private MemoryBlock getBlockContaining(Address address) {
        if (this.blocks == null) {
            this.blocks = this.program.getMemory().getBlocks();
        }
        for (MemoryBlock block : this.blocks) {
            if (!block.contains(address)) continue;
            return block;
        }
        return null;
    }

    private Address initializeSectionD() {
        SectionHeader section = this.header.getSections().get(1);
        if (section.getSectionKind().isInstantiated()) {
            MemoryBlock sectionBlock = this.importState.getMemoryBlockForSection(section);
            return sectionBlock.getStart();
        }
        return this.program.getAddressFactory().getDefaultAddressSpace().getAddress(0L);
    }

    public Address getSectionToBeRelocated() {
        short sectionIndex = this.relocationHeader.getSectionIndex();
        SectionHeader section = this.header.getSections().get(sectionIndex);
        MemoryBlock sectionBlock = this.importState.getMemoryBlockForSection(section);
        return sectionBlock.getStart();
    }
}

