/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeMarkupable;
import ghidra.app.util.bin.format.pe.cli.CliMetadataRoot;
import ghidra.app.util.bin.format.pe.cli.streams.CliAbstractStream;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class CliStreamHeader
implements StructConverter,
PeMarkupable {
    private static String NAME = "CLI_Stream_Header";
    private static String PATH = "/PE/CLI/Streams/Headers";
    private CliMetadataRoot metadataRoot;
    private CliAbstractStream stream;
    private int offset;
    private int size;
    private String name;
    private int nameLen;

    public CliStreamHeader(CliMetadataRoot metadataRoot, BinaryReader reader) throws IOException {
        this.metadataRoot = metadataRoot;
        long headerStartIndex = reader.getPointerIndex();
        this.offset = reader.readNextInt();
        this.size = reader.readNextInt();
        long startIndex = reader.getPointerIndex();
        this.name = reader.readNextAsciiString();
        long endIndex = reader.getPointerIndex();
        long stringBytes = endIndex - startIndex;
        long bytesToRoundUp = 0L;
        if (stringBytes % 4L != 0L) {
            bytesToRoundUp += 4L - stringBytes % 4L;
        }
        this.nameLen = (int)(stringBytes + bytesToRoundUp);
        int totalLen = 2 * DWordDataType.dataType.getLength() + this.nameLen;
        reader.setPointerIndex(headerStartIndex + (long)totalLen);
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws DuplicateNameException, IOException, MemoryAccessException {
        if (this.stream != null) {
            this.stream.markup(program, isBinary, monitor, log, ntHeader);
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(NAME + "_" + this.name, 0);
        struct.setCategoryPath(new CategoryPath(PATH));
        struct.add(DWORD, "offset", null);
        struct.add(DWORD, "size", null);
        struct.add((DataType)new ArrayDataType((DataType)CharDataType.dataType, this.nameLen, 1), "name", null);
        return struct;
    }

    public CliMetadataRoot getMetadataRoot() {
        return this.metadataRoot;
    }

    public CliAbstractStream getStream() {
        return this.stream;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public int getNameLength() {
        return this.nameLen;
    }

    public String toString() {
        return this.getName();
    }

    protected void setStream(CliAbstractStream stream) {
        this.stream = stream;
    }
}

