/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.rich.PERichTableDataType;
import ghidra.app.util.bin.format.pe.rich.RichHeaderRecord;
import ghidra.program.model.data.DataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import java.io.IOException;

public class RichTable {
    private static int MAX_TABLE_SEARCH_COUNT = 100;
    private int mask;
    private long imageOffset;
    private int size;
    private RichHeaderRecord[] records = new RichHeaderRecord[0];

    public RichTable(MemBuffer buf) {
        this.parse(buf, 0L);
    }

    public RichTable(BinaryReader reader) {
        this.parse(reader, reader.getPointerIndex());
    }

    private void parse(Object src, long base) {
        int nSignDwords;
        long endOffset;
        long startOffset;
        long offset;
        boolean valid;
        block13: {
            valid = false;
            startOffset = offset = base;
            endOffset = base;
            nSignDwords = 0;
            try {
                int i;
                int i2 = 0;
                while (i2 < MAX_TABLE_SEARCH_COUNT) {
                    int dw = RichTable.readInt(src, offset);
                    if (dw == 1751345490) {
                        endOffset = offset + 8L;
                        break;
                    }
                    if (dw == 17744) break;
                    ++i2;
                    offset += 4L;
                }
                if (endOffset == startOffset) break block13;
                this.mask = RichTable.readInt(src, offset += 4L);
                long _scanOffset = offset - 8L;
                for (i = 0; i < MAX_TABLE_SEARCH_COUNT; --i) {
                    int dw = RichTable.readInt(src, _scanOffset);
                    if ((dw ^ this.mask) == 1399742788) {
                        startOffset = (int)_scanOffset;
                        ++nSignDwords;
                        valid = true;
                        break;
                    }
                    ++nSignDwords;
                    if ((_scanOffset -= 4L) < base) break;
                }
                if (!valid) break block13;
                offset = startOffset + 4L;
                i = 0;
                while (i < 3) {
                    int v = RichTable.readInt(src, offset);
                    if ((v ^ this.mask) != 0) {
                        valid = false;
                        break;
                    }
                    ++i;
                    offset += 4L;
                }
            }
            catch (IOException ioe) {
                valid = false;
            }
        }
        if (!valid) {
            this.mask = -1;
            this.imageOffset = -1L;
            this.size = 0;
            return;
        }
        int numRecords = nSignDwords / 2 - 2;
        this.imageOffset = startOffset;
        this.size = (int)(endOffset - this.imageOffset);
        this.records = new RichHeaderRecord[numRecords];
        offset = this.imageOffset + 16L;
        try {
            for (int i = 0; i < numRecords; ++i) {
                RichHeaderRecord rec;
                int data1 = RichTable.readInt(src, offset);
                int data2 = RichTable.readInt(src, offset + 4L);
                offset += 8L;
                this.records[i] = rec = new RichHeaderRecord(i, data1 ^= this.mask, data2 ^= this.mask);
            }
        }
        catch (IOException ioe) {
            valid = false;
        }
        if (!valid) {
            this.records = new RichHeaderRecord[0];
            this.mask = -1;
            this.imageOffset = -1L;
            this.size = 0;
            return;
        }
    }

    private static int readInt(Object src, long offset) throws IOException {
        if (src instanceof MemBuffer) {
            return RichTable.readInt((MemBuffer)src, offset);
        }
        if (src instanceof BinaryReader) {
            return RichTable.readInt((BinaryReader)src, offset);
        }
        throw new IOException("Source must be a MemBuffer or BinaryReader");
    }

    private static int readInt(MemBuffer buf, long offset) throws IOException {
        try {
            return buf.getInt((int)offset) & 0xFFFFFFFF;
        }
        catch (MemoryAccessException mae) {
            throw new IOException(mae);
        }
    }

    private static int readInt(BinaryReader reader, long offset) throws IOException {
        return reader.readInt(offset) & 0xFFFFFFFF;
    }

    public RichHeaderRecord[] getRecords() {
        return this.records;
    }

    public long getOffset() {
        return this.imageOffset;
    }

    public int getMask() {
        return this.mask;
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        return "IMAGE_RICH_HEADER[mask=" + Integer.toHexString(this.mask) + "h, numRecords=" + this.records.length + "]";
    }

    public DataType toDataType() {
        return new PERichTableDataType();
    }
}

