/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.encoding;

import java.util.HashMap;
import java.util.Map;

public enum DWARFForm {
    NULL(0),
    DW_FORM_addr(1),
    DW_FORM_block2(3),
    DW_FORM_block4(4),
    DW_FORM_data2(5),
    DW_FORM_data4(6),
    DW_FORM_data8(7),
    DW_FORM_string(8),
    DW_FORM_block(9),
    DW_FORM_block1(10),
    DW_FORM_data1(11),
    DW_FORM_flag(12),
    DW_FORM_sdata(13),
    DW_FORM_strp(14),
    DW_FORM_udata(15),
    DW_FORM_ref_addr(16),
    DW_FORM_ref1(17),
    DW_FORM_ref2(18),
    DW_FORM_ref4(19),
    DW_FORM_ref8(20),
    DW_FORM_ref_udata(21),
    DW_FORM_indirect(22),
    DW_FORM_sec_offset(23),
    DW_FORM_exprloc(24),
    DW_FORM_flag_present(25),
    DW_FORM_ref_sig8(32);

    private final int value;
    private static final Map<Integer, DWARFForm> valueMap;

    private DWARFForm(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static DWARFForm find(int key) {
        DWARFForm access = valueMap.get(key);
        if (access != null) {
            return access;
        }
        throw new IllegalArgumentException("Invalid Integer value: " + key);
    }

    static {
        valueMap = new HashMap<Integer, DWARFForm>();
        for (DWARFForm access : DWARFForm.values()) {
            valueMap.put(access.getValue(), access);
        }
    }
}

