/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.editor;

import docking.DialogComponentProvider;
import docking.widgets.DropDownSelectionTextField;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import docking.widgets.table.GTable;
import ghidra.app.plugin.core.function.editor.FunctionVariableData;
import ghidra.app.plugin.core.function.editor.ModelChangeListener;
import ghidra.app.plugin.core.function.editor.ParameterDataTypeCellEditor;
import ghidra.app.plugin.core.function.editor.StorageAddressModel;
import ghidra.app.plugin.core.function.editor.VarnodeInfo;
import ghidra.app.plugin.core.function.editor.VarnodeLocationCellEditor;
import ghidra.app.plugin.core.function.editor.VarnodeLocationTableCellRenderer;
import ghidra.app.plugin.core.function.editor.VarnodeSizeCellEditor;
import ghidra.app.plugin.core.function.editor.VarnodeTableModel;
import ghidra.app.plugin.core.function.editor.VarnodeType;
import ghidra.app.plugin.core.function.editor.VarnodeTypeCellEditor;
import ghidra.app.services.DataTypeManagerService;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class StorageAddressEditorDialog
extends DialogComponentProvider
implements ModelChangeListener {
    private ParameterDataTypeCellEditor dataTypeEditor;
    private GTable varnodeTable;
    private ListSelectionListener selectionListener;
    private JLabel sizeLabel;
    private JButton addButton;
    private JButton removeButton;
    private JButton upButton;
    private JButton downButton;
    private JLabel currentSizeLabel;
    private FunctionVariableData variableData;
    private StorageAddressModel model;
    private VarnodeTableModel varnodeTableModel;
    private int size;
    private boolean cancelled = true;
    private boolean adjustingDataType = false;
    private DataType previousDataType;
    private DataType currentDataType;

    public StorageAddressEditorDialog(Program program, DataTypeManagerService service, VariableStorage storage, FunctionVariableData variableData) {
        super("Storage Address Editor");
        this.variableData = variableData;
        this.model = new StorageAddressModel(program, storage, this);
        this.previousDataType = this.currentDataType = variableData.getFormalDataType();
        this.setDataType(this.currentDataType);
        this.setHelpLocation(new HelpLocation("FunctionPlugin", "Edit_Parameter_Storage"));
        this.addWorkPanel(this.buildMainPanel(service));
        this.addOKButton();
        this.addCancelButton();
        this.dataChanged();
    }

    public StorageAddressEditorDialog(Program program, DataTypeManagerService service, Variable var, int ordinal) {
        this(program, service, var.getVariableStorage(), new ReadOnlyVariableData(ordinal, var));
    }

    protected void okCallback() {
        boolean isValid;
        if (this.varnodeTable.isEditing() && !this.varnodeTable.getCellEditor().stopCellEditing()) {
            return;
        }
        if (!Objects.equals(this.previousDataType, this.currentDataType) && !(isValid = this.variableData.setFormalDataType(this.currentDataType))) {
            this.setStatusText("Invalid data type");
            return;
        }
        this.cancelled = false;
        this.close();
    }

    public VariableStorage getStorage() {
        return this.model.getStorage();
    }

    private JComponent buildMainPanel(DataTypeManagerService service) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.buildInfoPanel(service), "North");
        panel.add(this.buildTablePanel(), "Center");
        return panel;
    }

    private void setDataType(DataType dt) {
        this.currentDataType = dt;
        this.size = dt.getLength();
        boolean unconstrained = dt instanceof AbstractFloatDataType || Undefined.isUndefined((DataType)dt);
        this.model.setRequiredSize(this.size, unconstrained);
        if (this.sizeLabel != null) {
            this.sizeLabel.setText(Integer.toString(this.size));
            this.dataChanged();
        }
    }

    private Component buildInfoPanel(DataTypeManagerService service) {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(10, 4));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        panel.add((Component)new GLabel("Datatype: "));
        this.dataTypeEditor = new ParameterDataTypeCellEditor(this, service);
        this.dataTypeEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                DataType dt = (DataType)StorageAddressEditorDialog.this.dataTypeEditor.getCellEditorValue();
                StorageAddressEditorDialog.this.setDataType(dt);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        final Component dataTypeEditComponent = this.dataTypeEditor.getTableCellEditorComponent(null, this.variableData.getFormalDataType(), false, 0, 0);
        final DropDownSelectionTextField<DataType> textField = this.dataTypeEditor.getTextField();
        textField.setBorder(new JTextField().getBorder());
        JButton chooserButton = this.dataTypeEditor.getChooserButton();
        JButton defaultButton = new JButton();
        chooserButton.setBorder(defaultButton.getBorder());
        chooserButton.setBackground(defaultButton.getBackground());
        textField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!StorageAddressEditorDialog.this.dataTypeEditor.stopCellEditing()) {
                    Msg.showError((Object)this, (Component)dataTypeEditComponent, (String)"Invalid Datatype", (Object)("Previous datatype restored, invalid data type specified: " + textField.getText()));
                    StorageAddressEditorDialog.this.dataTypeEditor.getEditor().setCellEditorValue(StorageAddressEditorDialog.this.variableData.getFormalDataType());
                    textField.requestFocus();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        panel.add(dataTypeEditComponent);
        panel.add((Component)new GLabel("Datatype Size: "));
        this.sizeLabel = new GDLabel(Integer.toString(this.size));
        panel.add(this.sizeLabel);
        panel.add((Component)new GLabel("Allocated Size:"));
        this.currentSizeLabel = new GDLabel("");
        panel.add(this.currentSizeLabel);
        this.setFocusComponent((Component)textField);
        return panel;
    }

    private Component buildTablePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Storage Locations"));
        this.varnodeTableModel = new VarnodeTableModel(this.model);
        this.varnodeTable = new GTable((TableModel)((Object)this.varnodeTableModel));
        this.selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                StorageAddressEditorDialog.this.model.setSelectedVarnodeRows(StorageAddressEditorDialog.this.varnodeTable.getSelectedRows());
            }
        };
        this.varnodeTable.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.varnodeTable.setPreferredScrollableViewportSize(new Dimension(400, 150));
        this.varnodeTable.setDefaultEditor(VarnodeType.class, (TableCellEditor)new VarnodeTypeCellEditor());
        this.varnodeTable.setDefaultEditor(Address.class, (TableCellEditor)new VarnodeLocationCellEditor(this.model));
        this.varnodeTable.setDefaultEditor(Register.class, (TableCellEditor)new VarnodeLocationCellEditor(this.model));
        this.varnodeTable.setDefaultEditor(Integer.class, (TableCellEditor)new VarnodeSizeCellEditor());
        this.varnodeTable.setDefaultRenderer(Address.class, (TableCellRenderer)((Object)new VarnodeLocationTableCellRenderer()));
        this.varnodeTable.setDefaultRenderer(Register.class, (TableCellRenderer)((Object)new VarnodeLocationTableCellRenderer()));
        this.varnodeTable.getTableHeader().setReorderingAllowed(false);
        this.varnodeTable.setSurrendersFocusOnKeystroke(true);
        JScrollPane scroll = new JScrollPane((Component)this.varnodeTable);
        panel.add((Component)scroll, "Center");
        panel.add(this.buildButtonPanel(), "East");
        return panel;
    }

    private Component buildButtonPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(5));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.addButton = new JButton("Add");
        this.removeButton = new JButton("Remove");
        this.upButton = new JButton("Up");
        this.downButton = new JButton("Down");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StorageAddressEditorDialog.this.model.addVarnode();
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StorageAddressEditorDialog.this.model.removeVarnodes();
            }
        });
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StorageAddressEditorDialog.this.model.moveSelectedVarnodeUp();
            }
        });
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StorageAddressEditorDialog.this.model.moveSelectedVarnodeDown();
            }
        });
        panel.add(this.addButton);
        panel.add(this.removeButton);
        panel.add(new JSeparator());
        panel.add(this.upButton);
        panel.add(this.downButton);
        return panel;
    }

    @Override
    public void dataChanged() {
        this.updateDataType();
        this.updateCurrentSize();
        this.updateStatusText();
        this.updateOkButton();
        this.updateVarnodeTable();
        this.updateTableSelection();
        this.updateTableButtonEnablement();
    }

    private void updateTableButtonEnablement() {
        this.removeButton.setEnabled(this.model.canRemoveVarnodes());
        this.upButton.setEnabled(this.model.canMoveVarnodeUp());
        this.downButton.setEnabled(this.model.canMoveVarnodeDown());
    }

    private void updateTableSelection() {
        int[] selectedRows = this.model.getSelectedVarnodeRows();
        if (!Arrays.equals(selectedRows, this.varnodeTable.getSelectedRows())) {
            this.varnodeTable.clearSelection();
            for (int i : selectedRows) {
                this.varnodeTable.addRowSelectionInterval(i, i);
            }
        }
    }

    private void updateVarnodeTable() {
        List<VarnodeInfo> tableVarnodeList;
        List<VarnodeInfo> varnodeList = this.model.getVarnodes();
        if (!varnodeList.equals(tableVarnodeList = this.varnodeTableModel.getVarnodes())) {
            ListSelectionModel selectionModel = this.varnodeTable.getSelectionModel();
            selectionModel.removeListSelectionListener(this.selectionListener);
            this.varnodeTableModel.setVarnodes(varnodeList);
            selectionModel.addListSelectionListener(this.selectionListener);
        }
    }

    private void updateOkButton() {
        this.setOkEnabled(this.model.isValid());
    }

    private void updateStatusText() {
        this.setStatusText(this.model.getStatusText());
    }

    private void updateCurrentSize() {
        this.currentSizeLabel.setText(Integer.toString(this.model.getCurrentSize()));
    }

    private void updateDataType() {
        if (this.adjustingDataType) {
            return;
        }
        this.adjustingDataType = true;
        try {
            int currentSize = this.model.getCurrentSize();
            if (currentSize > 0 && Undefined.isUndefined((DataType)this.variableData.getFormalDataType())) {
                DataType adjustedUndefinedtype;
                this.currentDataType = adjustedUndefinedtype = Undefined.getUndefinedDataType((int)currentSize);
                this.dataTypeEditor.getEditor().setCellEditorValue(adjustedUndefinedtype);
                this.setDataType(adjustedUndefinedtype);
            }
        }
        finally {
            this.adjustingDataType = false;
        }
    }

    @Override
    public void tableRowsChanged() {
        TableCellEditor cellEditor = this.varnodeTable.getCellEditor();
        if (cellEditor != null && !cellEditor.stopCellEditing()) {
            cellEditor.cancelCellEditing();
        }
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    private static class ReadOnlyVariableData
    implements FunctionVariableData {
        private int ordinal;
        private Variable variable;

        private ReadOnlyVariableData(int ordinal, Variable variable) {
            this.ordinal = ordinal;
            this.variable = variable;
        }

        @Override
        public void setStorage(VariableStorage storage) {
        }

        @Override
        public boolean setFormalDataType(DataType dataType) {
            return false;
        }

        @Override
        public void setName(String name) {
        }

        @Override
        public VariableStorage getStorage() {
            return this.variable.getVariableStorage();
        }

        @Override
        public String getName() {
            return this.variable.getName();
        }

        @Override
        public Integer getIndex() {
            return this.ordinal;
        }

        @Override
        public DataType getFormalDataType() {
            return this.variable.getDataType();
        }
    }
}

