/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.help.Help;
import docking.help.HelpService;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.net.URL;
import javax.swing.Icon;
import resources.ResourceManager;

public class HelpAction
extends DockingAction {
    private static Icon ICON = ResourceManager.loadImage((String)"images/help-browser.png");

    public HelpAction() {
        super("Version Tracking Help Action", VTPlugin.OWNER);
        String[] menuPath = new String[]{"&Help", "Workflow"};
        this.setMenuBarData(new MenuData(menuPath, ICON, "AAAHelpContents"));
        this.setToolBarData(new ToolBarData(ICON, "ZZZ"));
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Version_Tracking_Tool"));
    }

    public void actionPerformed(ActionContext context) {
        HelpService help = Help.getHelpService();
        if (help == null) {
            Msg.showError((Object)((Object)this), null, (String)"Help Not Found", (Object)"HelpManager failed to initialize properly");
            return;
        }
        URL url = ResourceManager.getResource((String)"help/topics/VersionTrackingPlugin/VT_Workflow.html");
        if (url == null) {
            Msg.showError((Object)((Object)this), null, (String)"Help Not Found", (Object)"Unable to find the Version Tracking workflow help");
            return;
        }
        help.showHelp(url);
    }
}

