/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.DBRecord;
import ghidra.feature.vt.api.db.AssociationDatabaseManager;
import ghidra.feature.vt.api.db.VTMatchMarkupItemTableDBAdapter;
import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.api.impl.MarkupItemStorage;
import ghidra.feature.vt.api.impl.MarkupItemStorageImpl;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMarkupItemStatus;
import ghidra.feature.vt.api.markuptype.VTMarkupType;
import ghidra.feature.vt.api.markuptype.VTMarkupTypeFactory;
import ghidra.feature.vt.api.util.Stringable;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;

public class MarkupItemStorageDB
extends DatabaseObject
implements MarkupItemStorage {
    private final AssociationDatabaseManager associationManager;
    private final VTAssociation association;
    private final VTSessionDB session;
    private DBRecord record;

    MarkupItemStorageDB(DBRecord record, DBObjectCache<MarkupItemStorageDB> cache, AssociationDatabaseManager associationManager) {
        super(cache, record.getKey());
        this.record = record;
        this.associationManager = associationManager;
        this.session = associationManager.getSession();
        long associationKey = record.getLongValue(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.ASSOCIATION_KEY_COL.column());
        this.association = associationManager.getAssociation(associationKey);
    }

    @Override
    public VTMarkupType getMarkupType() {
        return VTMarkupTypeFactory.getMarkupType(this.record.getShortValue(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.MARKUP_TYPE_COL.column()));
    }

    @Override
    public VTAssociation getAssociation() {
        return this.association;
    }

    @Override
    public Address getSourceAddress() {
        long addressLong = this.record.getLongValue(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.SOURCE_ADDRESS_COL.column());
        Program program = this.session.getSourceProgram();
        AddressMap addressMap = program.getAddressMap();
        return addressMap.decodeAddress(addressLong);
    }

    @Override
    public Address getDestinationAddress() {
        long addressLong = this.record.getLongValue(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.DESTINATION_ADDRESS_COL.column());
        Program program = this.session.getDestinationProgram();
        AddressMap addressMap = program.getAddressMap();
        return addressMap.decodeAddress(addressLong);
    }

    @Override
    public String getDestinationAddressSource() {
        return this.record.getString(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.ADDRESS_SOURCE_COL.column());
    }

    @Override
    public VTMarkupItemStatus getStatus() {
        this.checkIsValid();
        byte ordinal = this.record.getByteValue(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.STATUS_COL.column());
        return VTMarkupItemStatus.values()[ordinal];
    }

    @Override
    public String getStatusDescription() {
        return this.record.getString(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.STATUS_DESCRIPTION_COL.column());
    }

    @Override
    public Stringable getSourceValue() {
        String string = this.record.getString(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.SOURCE_VALUE_COL.column());
        return Stringable.getStringable(string, this.session.getSourceProgram());
    }

    @Override
    public Stringable getDestinationValue() {
        String string = this.record.getString(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.ORIGINAL_DESTINATION_VALUE_COL.column());
        return Stringable.getStringable(string, this.session.getDestinationProgram());
    }

    @Override
    public void setSourceDestinationValues(Stringable sourceValue, Stringable destinationValue) {
        Program sourceProgram = this.session.getSourceProgram();
        String string = Stringable.getString(sourceValue, sourceProgram);
        this.record.setString(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.SOURCE_VALUE_COL.column(), string);
        Program destinationProgram = this.session.getDestinationProgram();
        string = Stringable.getString(destinationValue, destinationProgram);
        this.record.setString(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.ORIGINAL_DESTINATION_VALUE_COL.column(), string);
    }

    @Override
    public MarkupItemStorage setStatus(VTMarkupItemStatus status) {
        this.record.setByteValue(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.STATUS_COL.column(), (byte)status.ordinal());
        this.associationManager.updateMarkupRecord(this.record);
        return this;
    }

    @Override
    public MarkupItemStorage setApplyFailed(String message) {
        this.record.setString(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.STATUS_DESCRIPTION_COL.column(), message);
        return this.setStatus(VTMarkupItemStatus.FAILED_APPLY);
    }

    @Override
    public MarkupItemStorage reset() {
        this.associationManager.lock.acquire();
        try {
            MarkupItemStorageImpl storage = new MarkupItemStorageImpl(this.getAssociation(), this.getMarkupType(), this.getSourceAddress(), this.getDestinationAddress(), this.getDestinationAddressSource());
            this.associationManager.removeMarkupRecord(this.record);
            MarkupItemStorageImpl markupItemStorageImpl = storage;
            return markupItemStorageImpl;
        }
        finally {
            this.associationManager.lock.release();
        }
    }

    @Override
    public MarkupItemStorage setDestinationAddress(Address destinationAddress, String addressSource) {
        if (destinationAddress == null) {
            destinationAddress = Address.NO_ADDRESS;
        }
        Program destinationProgram = this.session.getDestinationProgram();
        AddressMap addressMap = destinationProgram.getAddressMap();
        long addressID = addressMap.getKey(destinationAddress, false);
        this.record.setLongValue(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.DESTINATION_ADDRESS_COL.column(), addressID);
        this.record.setString(VTMatchMarkupItemTableDBAdapter.MarkupTableDescriptor.ADDRESS_SOURCE_COL.column(), addressSource);
        this.associationManager.updateMarkupRecord(this.record);
        return this;
    }

    protected boolean refresh() {
        return this.refresh(null);
    }

    protected boolean refresh(DBRecord matchRecord) {
        if (matchRecord == null) {
            matchRecord = this.associationManager.getMarkupItemRecord(this.key);
        }
        if (matchRecord == null) {
            return false;
        }
        this.record = matchRecord;
        return true;
    }

    public String toString() {
        StringBuffer buffy = new StringBuffer();
        buffy.append('\n').append(this.getClass().getSimpleName()).append('\n');
        buffy.append('\t').append("Source Address          = ").append(this.getSourceAddress()).append('\n');
        buffy.append('\t').append("Dest Address            = ").append(this.getDestinationAddress()).append('\n');
        buffy.append('\t').append("Markup Class            = ").append(this.getMarkupType()).append('\n');
        buffy.append('\t').append("Status                  = ").append((Object)this.getStatus()).append('\n');
        buffy.append('\t').append("Source Value            = ").append(this.getSourceValue()).append('\n');
        buffy.append('\t').append("Dest Value              = ").append(this.getDestinationValue()).append('\n');
        buffy.append('\t').append("Association             = ").append(this.getAssociation()).append('\n');
        buffy.append('\t').append("Algorithm               = ").append(this.getDestinationAddressSource()).append('\n');
        return buffy.toString();
    }
}

