/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.SBStream;
import SWIG.SBSymbol;
import SWIG.SBTarget;
import agent.lldb.model.iface2.LldbModelTargetSession;
import agent.lldb.model.iface2.LldbModelTargetSymbol;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import agent.lldb.model.impl.LldbModelTargetSymbolContainerImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="Symbol", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="_namespace", type=LldbModelTargetSymbolContainerImpl.class), @TargetAttributeType(name="_value", type=Address.class), @TargetAttributeType(name="_size", type=long.class), @TargetAttributeType(name="Name", type=String.class), @TargetAttributeType(name="Size", type=long.class), @TargetAttributeType(name="TypeId", type=int.class), @TargetAttributeType(name="Tag", type=int.class), @TargetAttributeType(type=Void.class)})
public class LldbModelTargetSymbolImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetSymbol {
    protected final boolean constant;
    protected Address value;
    protected long size;

    protected static String indexSymbol(SBSymbol symbol) {
        return symbol.GetName();
    }

    protected static String keySymbol(SBSymbol symbol) {
        return PathUtils.makeKey((String)LldbModelTargetSymbolImpl.indexSymbol(symbol));
    }

    public LldbModelTargetSymbolImpl(LldbModelTargetSymbolContainerImpl symbols, SBSymbol symbol) {
        super(symbols.getModel(), (TargetObject)symbols, LldbModelTargetSymbolImpl.keySymbol(symbol), symbol, "Symbol");
        this.constant = false;
        LldbModelTargetSession session = this.getParentSession();
        SBTarget target = (SBTarget)session.getModelObject();
        this.value = symbols.getModel().getAddressSpace("ram").getAddress(symbol.GetStartAddress().GetLoadAddress(target).longValue());
        this.size = symbol.GetEndAddress().GetOffset().subtract(symbol.GetStartAddress().GetOffset()).longValue();
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDescription(0), "_namespace", symbols, "_value", this.value, "_size", this.size), "Initialized");
    }

    @Override
    public String getDescription(int level) {
        SBStream stream = new SBStream();
        SBSymbol symbol = (SBSymbol)this.getModelObject();
        symbol.GetDescription(stream);
        return stream.GetData();
    }

    @Override
    public boolean isConstant() {
        return this.constant;
    }

    @Override
    public Address getValue() {
        return this.value;
    }

    @Override
    public long getSize() {
        return this.size;
    }
}

