/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import SWIG.SBThread;
import agent.lldb.lldb.DebugClient;
import agent.lldb.manager.LldbEvent;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.cmd.LldbPendingCommand;
import agent.lldb.manager.evt.AbstractLldbCompletedCommandEvent;
import agent.lldb.manager.evt.LldbProcessCreatedEvent;
import agent.lldb.manager.impl.LldbManagerImpl;
import java.util.ArrayList;
import java.util.List;

public class LldbLaunchProcessCommand
extends AbstractLldbCommand<SBThread> {
    private LldbProcessCreatedEvent created = null;
    private boolean completed = false;
    private String fileName;
    private List<String> args;
    private List<String> envp;
    private List<String> pathsIO;
    private String wdir;
    private long flags;
    private boolean stopAtEntry;

    public LldbLaunchProcessCommand(LldbManagerImpl manager, String fileName, List<String> args) {
        this(manager, fileName, args, null, null, "", 0L, true);
    }

    public LldbLaunchProcessCommand(LldbManagerImpl manager, String fileName, List<String> args, List<String> envp, List<String> pathsIO, String workingDirectory, long flags, boolean stopAtEntry) {
        super(manager);
        this.fileName = fileName;
        this.args = args == null ? new ArrayList() : args;
        this.envp = envp == null ? new ArrayList() : envp;
        this.pathsIO = pathsIO;
        if (pathsIO == null) {
            this.pathsIO = new ArrayList<String>();
            this.pathsIO.add("");
            this.pathsIO.add("");
            this.pathsIO.add("");
        }
        this.wdir = workingDirectory;
        this.flags = flags;
        this.stopAtEntry = stopAtEntry;
    }

    @Override
    public boolean handle(LldbEvent<?> evt, LldbPendingCommand<?> pending) {
        if (evt instanceof AbstractLldbCompletedCommandEvent && pending.getCommand().equals(this)) {
            this.completed = true;
        } else if (evt instanceof LldbProcessCreatedEvent) {
            this.created = (LldbProcessCreatedEvent)evt;
        }
        return this.completed && this.created != null;
    }

    @Override
    public SBThread complete(LldbPendingCommand<?> pending) {
        return this.manager.getEventThread();
    }

    @Override
    public void invoke() {
        DebugClient client = this.manager.getClient();
        client.createProcess(client.getLocalServer(), this.fileName, this.args, this.envp, this.pathsIO, this.wdir, this.flags, this.stopAtEntry);
    }
}

