/*
 * Decompiled with CFR 0.152.
 */
package ghidra.service.graph;

import com.google.common.base.Splitter;
import docking.Tool;
import docking.options.editor.ScrollableOptionsEditor;
import docking.options.editor.StringWithChoicesEditor;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.OptionsEditor;
import ghidra.framework.options.ToolOptions;
import ghidra.service.graph.AttributedEdge;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.EmptyGraphType;
import ghidra.service.graph.GraphLabelPosition;
import ghidra.service.graph.GraphType;
import ghidra.service.graph.LayoutAlgorithmNames;
import ghidra.service.graph.VertexShape;
import ghidra.util.HelpLocation;
import ghidra.util.WebColors;
import ghidra.util.bean.opteditor.OptionsVetoException;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.text.StringEscapeUtils;

public class GraphDisplayOptions
implements OptionsChangeListener {
    public static final GraphDisplayOptions DEFAULT = new GraphDisplayOptions(new EmptyGraphType());
    private static final String FONT = "Font";
    private static final String LABEL_POSITION = "Label Position";
    private static final String USE_ICONS = "Use Icons";
    private static final String DEFAULT_LAYOUT_ALGORITHM = "Default Layout Algorithm";
    private static final String EDGE_COLORS = "Edge Colors";
    private static final String VERTEX_COLORS = "Vertex Colors";
    private static final String VERTEX_SHAPES = "Vertex Shapes";
    private static final String MISCELLANEOUS_OPTIONS = "Miscellaneous";
    private static final String DEFAULT_VERTEX_COLOR = "Default Vertex Color";
    private static final String DEFAULT_EDGE_COLOR = "Default Edge Color";
    private static final String DEFAULT_VERTEX_SHAPE = "Default Vertex Shape";
    private static final String FAVORED_EDGE_TYPE = "Favored Edge Type";
    private static final String VERTEX_SELECTION_COLOR = "Selected Vertex Color";
    private static final String EDGE_SELECTION_COLOR = "Selected Edge Color";
    private static final String MAX_NODES_SIZE = "Max Graph Size";
    private GraphType graphType;
    private Map<String, Color> vertexColorMap = new HashMap<String, Color>();
    private Map<String, Color> edgeColorMap = new HashMap<String, Color>();
    private Map<String, VertexShape> vertexShapeMap = new HashMap<String, VertexShape>();
    private Map<String, Integer> edgePriorityMap = new HashMap<String, Integer>();
    private List<ChangeListener> changeListeners = new CopyOnWriteArrayList<ChangeListener>();
    private Color vertexSelectionColor = Color.green;
    private Color edgeSelectionColor = Color.green;
    private Color defaultVertexColor = Color.blue;
    private Color defaultEdgeColor = Color.blue;
    private String favoredEdgeType;
    private VertexShape defaultVertexShape = VertexShape.RECTANGLE;
    private String vertexLabelOverride = null;
    private String vertexColorOverride = null;
    private String vertexShapeOverride = null;
    private String edgeColorOverride = null;
    private final String rootOptionsName;
    private boolean registeredWithTool = false;
    private String defaultLayoutAlgorithmName = "Hierarchical MinCross Coffman Graham";
    private boolean useIcons = true;
    private GraphLabelPosition labelPosition = GraphLabelPosition.SOUTH;
    private Font font = new Font("Dialog", 1, 18);
    private int arrowLength = 15;
    private int maxNodeCount = 500;

    public GraphDisplayOptions(GraphType graphType) {
        this(graphType, null);
    }

    public GraphDisplayOptions(GraphType graphType, Tool tool) {
        this.graphType = graphType;
        this.rootOptionsName = graphType.getOptionsName();
        List<String> edgeTypes = graphType.getEdgeTypes();
        if (!edgeTypes.isEmpty()) {
            this.favoredEdgeType = edgeTypes.iterator().next();
        }
        this.initializeEdgePriorities();
        this.initializeDefaults();
        this.initializeFromOptions(tool);
    }

    private void initializeEdgePriorities() {
        for (String edgeType : this.graphType.getEdgeTypes()) {
            this.edgePriorityMap.put(edgeType, this.edgePriorityMap.size());
        }
    }

    protected void initializeDefaults() {
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void setDefaultVertexShape(VertexShape shape) {
        this.defaultVertexShape = Objects.requireNonNull(shape);
    }

    public void setDefaultVertexColor(Color color) {
        this.defaultVertexColor = Objects.requireNonNull(color);
    }

    public void setDefaultEdgeColor(Color color) {
        this.defaultEdgeColor = Objects.requireNonNull(color);
    }

    public Color getDefaultEdgeColor() {
        return this.defaultEdgeColor;
    }

    public Color getDefaultVertexColor() {
        return this.defaultVertexColor;
    }

    public void setVertexLabelOverrideAttributeKey(String attributeKey) {
        this.vertexLabelOverride = attributeKey;
    }

    public String getVertexLabelOverride() {
        return this.vertexLabelOverride;
    }

    public void setVertexColorOverrideAttributeKey(String attributeKey) {
        this.vertexColorOverride = attributeKey;
    }

    public void setEdgeColorOverrideAttributeKey(String attributeKey) {
        this.edgeColorOverride = attributeKey;
    }

    public String getEdgeColorOverrideAttributeKey() {
        return this.edgeColorOverride;
    }

    public void setVertexShapeOverrideAttributeKey(String attributeKey) {
        this.vertexShapeOverride = attributeKey;
    }

    public String getVertexLabel(AttributedVertex vertex) {
        String vertexLabel = null;
        if (this.vertexLabelOverride != null) {
            vertexLabel = vertex.getAttribute(this.vertexLabelOverride);
        }
        if (vertexLabel == null) {
            vertexLabel = vertex.getName();
        }
        if (vertexLabel.contains("\n")) {
            vertexLabel = StringEscapeUtils.escapeHtml4((String)vertexLabel);
            return "<html>" + String.join((CharSequence)"<p>", Splitter.on((char)'\n').split((CharSequence)vertexLabel));
        }
        return vertexLabel;
    }

    public VertexShape getVertexShape(AttributedVertex vertex) {
        VertexShape shape;
        String shapeName;
        if (this.vertexShapeOverride != null && (shapeName = vertex.getAttribute(this.vertexShapeOverride)) != null && (shape = VertexShape.getShape(shapeName)) != null) {
            return shape;
        }
        String vertexType = vertex.getVertexType();
        return this.vertexShapeMap.getOrDefault(vertexType, this.defaultVertexShape);
    }

    public Color getVertexColor(AttributedVertex vertex) {
        Color color;
        String colorValue;
        if (this.vertexColorOverride != null && (colorValue = vertex.getAttribute(this.vertexColorOverride)) != null && (color = WebColors.getColor((String)colorValue)) != null) {
            return color;
        }
        String vertexType = vertex.getVertexType();
        return this.vertexColorMap.getOrDefault(vertexType, this.defaultVertexColor);
    }

    public Color getEdgeColor(AttributedEdge edge) {
        Color color;
        String colorValue;
        if (this.edgeColorOverride != null && (colorValue = edge.getAttribute(this.edgeColorOverride)) != null && (color = WebColors.getColor((String)colorValue)) != null) {
            return color;
        }
        String edgeType = edge.getEdgeType();
        return this.edgeColorMap.getOrDefault(edgeType, this.defaultEdgeColor);
    }

    public Integer getEdgePriority(String edgeType) {
        return this.edgePriorityMap.getOrDefault(edgeType, Integer.MAX_VALUE);
    }

    public String getFavoredEdgeType() {
        return this.favoredEdgeType;
    }

    public void setFavoredEdgeType(String favoredEdgeType) {
        this.checkEdgeType(favoredEdgeType);
        this.favoredEdgeType = favoredEdgeType;
    }

    public GraphType getGraphType() {
        return this.graphType;
    }

    public Color getVertexColor(String vertexType) {
        return this.vertexColorMap.getOrDefault(vertexType, this.defaultVertexColor);
    }

    public void setVertexColor(String vertexType, Color color) {
        this.checkVertexType(vertexType);
        this.vertexColorMap.put(vertexType, Objects.requireNonNull(color));
    }

    private String getVertexShapeName(String vertexType) {
        VertexShape vertexShape = this.vertexShapeMap.getOrDefault(vertexType, this.defaultVertexShape);
        return vertexShape.getName();
    }

    public void setVertexShape(String vertexType, VertexShape vertexShape) {
        this.checkVertexType(vertexType);
        this.vertexShapeMap.put(vertexType, Objects.requireNonNull(vertexShape));
    }

    public Color getEdgeColor(String edgeType) {
        return this.edgeColorMap.getOrDefault(edgeType, this.defaultEdgeColor);
    }

    public void setEdgeColor(String edgeType, Color color) {
        this.checkEdgeType(edgeType);
        this.edgeColorMap.put(edgeType, Objects.requireNonNull(color));
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) throws OptionsVetoException {
        if (optionName.startsWith(this.rootOptionsName)) {
            this.updateOptions(options.getOptions(this.rootOptionsName));
        }
        this.notifyListeners();
    }

    public String getRootOptionsName() {
        return this.rootOptionsName;
    }

    public String getVertexColorOverrideAttributeKey() {
        return this.vertexColorOverride;
    }

    public String getVertexShapeOverrideAttributeKey() {
        return this.vertexShapeOverride;
    }

    public VertexShape getDefaultVertexShape() {
        return this.defaultVertexShape;
    }

    public VertexShape getVertexShape(String vertexType) {
        return this.vertexShapeMap.getOrDefault(vertexType, this.defaultVertexShape);
    }

    public Color getVertexSelectionColor() {
        return this.vertexSelectionColor;
    }

    public void setVertexSelectionColor(Color vertexSelectionColor) {
        this.vertexSelectionColor = vertexSelectionColor;
    }

    public Color getEdgeSelectionColor() {
        return this.edgeSelectionColor;
    }

    public void setEdgeSelectionColor(Color edgeSelectionColor) {
        this.edgeSelectionColor = edgeSelectionColor;
    }

    public String getDefaultLayoutAlgorithmNameLayout() {
        return this.defaultLayoutAlgorithmName;
    }

    public void setDefaultLayoutAlgorithmName(String defaultLayout) {
        this.defaultLayoutAlgorithmName = defaultLayout;
    }

    public boolean usesIcons() {
        return this.useIcons;
    }

    public void setUsesIcons(boolean b) {
        this.useIcons = b;
    }

    public GraphLabelPosition getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(GraphLabelPosition labelPosition) {
        this.labelPosition = labelPosition;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public int getArrowLength() {
        return this.arrowLength;
    }

    public void setArrowLength(int length) {
        this.arrowLength = length;
    }

    public int getMaxNodeCount() {
        return this.maxNodeCount;
    }

    public void setMaxNodeCount(int maxNodeCount) {
        this.maxNodeCount = maxNodeCount;
    }

    public boolean isRegisteredWithTool() {
        return this.registeredWithTool;
    }

    public void registerOptions(ToolOptions toolOptions, HelpLocation help) {
        Options rootOptions = toolOptions.getOptions(this.graphType.getOptionsName());
        this.registerVertexColorOptions(rootOptions, help);
        this.registerVertexShapeOptions(rootOptions, help);
        this.registerEdgeColorOptions(rootOptions, help);
        this.registerMiscellaneousOptions(rootOptions, help);
    }

    protected void configureVertexType(String vertexType, VertexShape vertexShape, Color color) {
        this.checkVertexType(vertexType);
        this.vertexShapeMap.put(vertexType, vertexShape);
        this.vertexColorMap.put(vertexType, color);
    }

    protected void configureEdgeType(String edgeType, Color color) {
        this.checkEdgeType(edgeType);
        this.edgeColorMap.put(edgeType, color);
    }

    public void initializeFromOptions(Tool tool) {
        if (tool == null) {
            return;
        }
        ToolOptions toolOptions = tool.getOptions("Graph");
        toolOptions.addOptionsChangeListener((OptionsChangeListener)this);
        this.updateOptions(toolOptions.getOptions(this.rootOptionsName));
        this.registeredWithTool = true;
    }

    private void updateOptions(Options rootOptions) {
        this.updateVertexColorsFromOptions(rootOptions);
        this.updateEdgeColorsFromOptions(rootOptions);
        this.updateVertexShapesFromOptions(rootOptions);
        this.updateMiscellaniousOptions(rootOptions);
    }

    private void updateMiscellaniousOptions(Options rootOptions) {
        Options options = rootOptions.getOptions(MISCELLANEOUS_OPTIONS);
        String shapeName = options.getString(DEFAULT_VERTEX_SHAPE, this.defaultVertexShape.getName());
        this.defaultVertexShape = VertexShape.getShape(shapeName);
        this.defaultVertexColor = options.getColor(DEFAULT_VERTEX_COLOR, this.defaultVertexColor);
        this.defaultEdgeColor = options.getColor(DEFAULT_EDGE_COLOR, this.defaultEdgeColor);
        this.favoredEdgeType = options.getString(FAVORED_EDGE_TYPE, this.favoredEdgeType);
        this.vertexSelectionColor = options.getColor(VERTEX_SELECTION_COLOR, this.vertexSelectionColor);
        this.edgeSelectionColor = options.getColor(EDGE_SELECTION_COLOR, this.edgeSelectionColor);
        this.defaultLayoutAlgorithmName = options.getString(DEFAULT_LAYOUT_ALGORITHM, this.defaultLayoutAlgorithmName);
        this.useIcons = options.getBoolean(USE_ICONS, this.useIcons);
        this.labelPosition = (GraphLabelPosition)options.getEnum(LABEL_POSITION, (Enum)this.labelPosition);
        this.font = options.getFont(FONT, this.font);
        this.maxNodeCount = options.getInt(MAX_NODES_SIZE, this.maxNodeCount);
    }

    private void updateVertexShapesFromOptions(Options rootOptions) {
        Options options = rootOptions.getOptions(VERTEX_SHAPES);
        for (String vertexType : this.graphType.getVertexTypes()) {
            VertexShape shape;
            String current;
            String shapeName = options.getString(vertexType, current = this.getVertexShapeName(vertexType));
            if (shapeName == null || shapeName.equals(current) || (shape = VertexShape.getShape(shapeName)) == null) continue;
            this.setVertexShape(vertexType, VertexShape.getShape(shapeName));
        }
    }

    private void updateEdgeColorsFromOptions(Options rootOptions) {
        Options options = rootOptions.getOptions(EDGE_COLORS);
        for (String edgeType : this.graphType.getEdgeTypes()) {
            Color current;
            Color color = options.getColor(edgeType, current = this.getEdgeColor(edgeType));
            if (color == null || color.equals(current)) continue;
            this.setEdgeColor(edgeType, color);
        }
    }

    private void notifyListeners() {
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    private void updateVertexColorsFromOptions(Options rootOptions) {
        Options options = rootOptions.getOptions(VERTEX_COLORS);
        for (String vertexType : this.graphType.getVertexTypes()) {
            Color current;
            Color color = options.getColor(vertexType, current = this.getVertexColor(vertexType));
            if (color == null || color.equals(current)) continue;
            this.setVertexColor(vertexType, color);
        }
    }

    private void registerVertexColorOptions(Options rootOptions, HelpLocation help) {
        Options options = rootOptions.getOptions(VERTEX_COLORS);
        for (String vertexType : this.graphType.getVertexTypes()) {
            options.registerOption(vertexType, OptionType.COLOR_TYPE, (Object)this.getVertexColor(vertexType), help, "Choose the color for this vertex type");
        }
        ArrayList<String> list = new ArrayList<String>(this.graphType.getVertexTypes());
        ScrollableOptionsEditor editor = new ScrollableOptionsEditor(VERTEX_COLORS, list);
        options.registerOptionsEditor((OptionsEditor)editor);
    }

    private void registerVertexShapeOptions(Options rootOptions, HelpLocation help) {
        Options options = rootOptions.getOptions(VERTEX_SHAPES);
        List<String> shapeNames = VertexShape.getShapeNames();
        for (String vertexType : this.graphType.getVertexTypes()) {
            StringWithChoicesEditor editor = new StringWithChoicesEditor(shapeNames);
            options.registerOption(vertexType, OptionType.STRING_TYPE, (Object)this.getVertexShapeName(vertexType), help, "Choose the shape for this vertex type", (PropertyEditor)editor);
        }
        ArrayList<String> list = new ArrayList<String>(this.graphType.getVertexTypes());
        ScrollableOptionsEditor editor = new ScrollableOptionsEditor(VERTEX_SHAPES, list);
        options.registerOptionsEditor((OptionsEditor)editor);
    }

    private void registerEdgeColorOptions(Options rootOptions, HelpLocation help) {
        Options options = rootOptions.getOptions(EDGE_COLORS);
        for (String edgeType : this.graphType.getEdgeTypes()) {
            options.registerOption(edgeType, OptionType.COLOR_TYPE, (Object)this.getEdgeColor(edgeType), help, "Choose the color for this edge type");
        }
        ArrayList<String> list = new ArrayList<String>(this.graphType.getEdgeTypes());
        ScrollableOptionsEditor editor = new ScrollableOptionsEditor(EDGE_COLORS, list);
        options.registerOptionsEditor((OptionsEditor)editor);
    }

    private void registerMiscellaneousOptions(Options rootOptions, HelpLocation help) {
        Options options = rootOptions.getOptions(MISCELLANEOUS_OPTIONS);
        options.registerOption(MAX_NODES_SIZE, OptionType.INT_TYPE, (Object)this.maxNodeCount, help, "Graphs with more than this number of nodes will not be displayed. (Large graphs can cause Ghidra to become unstable/sluggish)");
        StringWithChoicesEditor editor = new StringWithChoicesEditor(VertexShape.getShapeNames());
        options.registerOption(VERTEX_SELECTION_COLOR, OptionType.COLOR_TYPE, (Object)this.vertexSelectionColor, help, "Color for highlighting selected vertices");
        options.registerOption(EDGE_SELECTION_COLOR, OptionType.COLOR_TYPE, (Object)this.edgeSelectionColor, help, "Color for highlighting selected edge");
        options.registerOption(DEFAULT_VERTEX_SHAPE, OptionType.STRING_TYPE, (Object)this.defaultVertexShape.getName(), help, "Shape for vertices that have no vertex type defined", (PropertyEditor)editor);
        options.registerOption(DEFAULT_VERTEX_COLOR, OptionType.COLOR_TYPE, (Object)this.defaultVertexColor, help, "Color for vertices that have no vertex type defined");
        options.registerOption(DEFAULT_EDGE_COLOR, OptionType.COLOR_TYPE, (Object)this.defaultEdgeColor, help, "Color for edge that have no edge type defined");
        List<String> edgeTypes = this.graphType.getEdgeTypes();
        if (!edgeTypes.isEmpty()) {
            editor = new StringWithChoicesEditor(edgeTypes);
            options.registerOption(FAVORED_EDGE_TYPE, OptionType.STRING_TYPE, (Object)this.favoredEdgeType, help, "Favored edge is used to influence layout algorithms", (PropertyEditor)editor);
        }
        editor = new StringWithChoicesEditor(LayoutAlgorithmNames.getLayoutAlgorithmNames());
        options.registerOption(DEFAULT_LAYOUT_ALGORITHM, OptionType.STRING_TYPE, (Object)this.defaultLayoutAlgorithmName, help, "Initial layout algorithm", (PropertyEditor)editor);
        options.registerOption(USE_ICONS, OptionType.BOOLEAN_TYPE, (Object)this.useIcons, help, "If true, vertices are drawn using pre-rendered images versus compact shapes");
        options.registerOption(LABEL_POSITION, OptionType.ENUM_TYPE, (Object)this.labelPosition, help, "Relative postion of labels to vertex shape (Only applicable if \"Use Icons\" is true");
        options.registerOption(FONT, OptionType.FONT_TYPE, (Object)this.font, help, "Font to use for vertex labels");
        ArrayList<String> optionNamesInDisplayOrder = new ArrayList<String>();
        optionNamesInDisplayOrder.add(MAX_NODES_SIZE);
        optionNamesInDisplayOrder.add(VERTEX_SELECTION_COLOR);
        optionNamesInDisplayOrder.add(EDGE_SELECTION_COLOR);
        optionNamesInDisplayOrder.add(DEFAULT_VERTEX_COLOR);
        optionNamesInDisplayOrder.add(DEFAULT_EDGE_COLOR);
        optionNamesInDisplayOrder.add(DEFAULT_VERTEX_SHAPE);
        optionNamesInDisplayOrder.add(FAVORED_EDGE_TYPE);
        optionNamesInDisplayOrder.add(DEFAULT_LAYOUT_ALGORITHM);
        optionNamesInDisplayOrder.add(LABEL_POSITION);
        optionNamesInDisplayOrder.add(FONT);
        optionNamesInDisplayOrder.add(USE_ICONS);
        ScrollableOptionsEditor optionsEditor = new ScrollableOptionsEditor(MISCELLANEOUS_OPTIONS, optionNamesInDisplayOrder);
        options.registerOptionsEditor((OptionsEditor)optionsEditor);
    }

    private void checkVertexType(String vertexType) {
        if (!this.getGraphType().containsVertexType(vertexType)) {
            throw new IllegalArgumentException("VertexType \"" + vertexType + "\" not defined in GraphType \"" + this.getGraphType().getName() + "\".");
        }
    }

    private void checkEdgeType(String edgeType) {
        if (!this.getGraphType().containsEdgeType(edgeType)) {
            throw new IllegalArgumentException("EdgeType \"" + edgeType + "\" not defined in GraphType \"" + this.getGraphType().getName() + "\".");
        }
    }
}

