/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.service;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemanglerUtil;
import ghidra.program.model.listing.Program;

public class NameVersions {
    public String rawName;
    public String similarName;
    public String demangledNoTemplate;
    public String demangledBaseName;
    public String demangledFull;

    public NameVersions(String raw) {
        this.rawName = raw;
        this.similarName = null;
        this.demangledNoTemplate = null;
        this.demangledBaseName = null;
    }

    public static DemangledObject demangle(Program program, String mangledName) {
        DemangledObject demangledObj = null;
        try {
            demangledObj = DemanglerUtil.demangle((Program)program, (String)mangledName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (demangledObj != null) {
            return demangledObj;
        }
        return null;
    }

    private static String getBaseClass(Demangled namespace) {
        char firstChar;
        String name = namespace.getNamespaceName();
        if (name.length() > 1 && name.charAt(0) == '`' && (firstChar = name.charAt(1)) >= '0' && firstChar <= '9') {
            return namespace.getNamespaceString();
        }
        return name;
    }

    private static String removeTemplateParams(DemangledObject demangledObj) {
        int pos2;
        String name = demangledObj.getDemangledName();
        int pos1 = name.indexOf(60);
        if (pos1 < 0) {
            return null;
        }
        int nesting = 1;
        for (pos2 = pos1 + 1; pos2 < name.length(); ++pos2) {
            char c = name.charAt(pos2);
            if (c == '<') {
                ++nesting;
                continue;
            }
            if (c == '>' && --nesting == 0) break;
        }
        if (nesting != 0) {
            return null;
        }
        return name.substring(0, pos1 + 1) + name.substring(pos2);
    }

    private static String constructBaseName(DemangledObject demangledObj) {
        String origName = demangledObj.getName();
        String name = origName.replaceFirst("_*", "");
        Demangled namespace = demangledObj.getNamespace();
        if (namespace != null) {
            if (name.endsWith("destructor'") || name.startsWith("operator") || name.startsWith("dtor$")) {
                String baseClassName = NameVersions.getBaseClass(namespace);
                if (baseClassName == null) {
                    return null;
                }
                return baseClassName + "::" + origName;
            }
            String fullString = namespace.getNamespaceString();
            if (fullString != null && fullString.startsWith("std::") && (fullString.startsWith("std::vector") || fullString.startsWith("std::list") || fullString.startsWith("std::map") || fullString.startsWith("std::set") || fullString.startsWith("std::basic_string"))) {
                return fullString + "::" + origName;
            }
        }
        return name;
    }

    public static NameVersions generate(String rawName, Program program) {
        NameVersions result = new NameVersions(rawName);
        if (rawName != null) {
            DemangledObject demangledObj = NameVersions.demangle(program, rawName);
            if (demangledObj != null) {
                result.demangledFull = demangledObj.getOriginalDemangled();
                result.demangledNoTemplate = NameVersions.removeTemplateParams(demangledObj);
                result.demangledBaseName = NameVersions.constructBaseName(demangledObj);
            }
            result.similarName = rawName.replaceFirst("_*", "");
        }
        return result;
    }
}

