/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ExceptionHandlerJava
implements StructConverter {
    private short startPC;
    private short endPC;
    private short handlerPC;
    private short catchType;

    public ExceptionHandlerJava(BinaryReader reader) throws IOException {
        this.startPC = reader.readNextShort();
        this.endPC = reader.readNextShort();
        this.handlerPC = reader.readNextShort();
        this.catchType = reader.readNextShort();
    }

    public int getStartPC() {
        return this.startPC & 0xFFFF;
    }

    public int getEndPC() {
        return this.endPC & 0xFFFF;
    }

    public int getHandlerPC() {
        return this.handlerPC & 0xFFFF;
    }

    public int getCatchType() {
        return this.catchType & 0xFFFF;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("exception_handler", 0);
        structure.add(WORD, "start_pc", null);
        structure.add(WORD, "end_pc", null);
        structure.add(WORD, "handler_pc", null);
        structure.add(WORD, "catch_type", null);
        return structure;
    }
}

