/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfsplus;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.ArrayBuilder;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusExtentDescriptor;

public class HFSPlusExtentRecord
implements StructElements {
    private final HFSPlusExtentDescriptor[] array = new HFSPlusExtentDescriptor[8];

    public HFSPlusExtentRecord(byte[] data, int offset) {
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = new HFSPlusExtentDescriptor(data, offset + i * HFSPlusExtentDescriptor.getSize());
        }
    }

    public HFSPlusExtentDescriptor getExtentDescriptor(int index) {
        return this.array[index];
    }

    public HFSPlusExtentDescriptor[] getExtentDescriptors() {
        HFSPlusExtentDescriptor[] arrayCopy = new HFSPlusExtentDescriptor[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            arrayCopy[i] = this.array[i];
        }
        return arrayCopy;
    }

    public int length() {
        int res = 0;
        for (HFSPlusExtentDescriptor desc : this.array) {
            res += desc.getSize();
        }
        return res;
    }

    public int getNumExtentsInUse() {
        for (int i = 0; i < this.array.length; ++i) {
            HFSPlusExtentDescriptor cur = this.array[i];
            if (cur.getBlockCount() != 0 || cur.getStartBlock() != 0) continue;
            return i;
        }
        return this.array.length;
    }

    public void print(PrintStream ps, int pregap) {
        String pregapString = "";
        for (int i = 0; i < pregap; ++i) {
            pregapString = pregapString + " ";
        }
        this.print(ps, pregapString);
    }

    public void print(PrintStream ps, String prefix) {
        for (int i = 0; i < this.array.length; ++i) {
            ps.println(prefix + "array[" + i + "]:");
            this.array[i].print(ps, prefix + "  ");
        }
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.length()];
        int offset = 0;
        for (HFSPlusExtentDescriptor desc : this.array) {
            byte[] tempData = desc.getBytes();
            System.arraycopy(tempData, 0, result, offset, tempData.length);
            offset += tempData.length;
        }
        return result;
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(HFSPlusExtentRecord.class.getSimpleName());
        ArrayBuilder ab = new ArrayBuilder("HFSPlusExtentDescriptor[8]");
        for (HFSPlusExtentDescriptor descriptor : this.array) {
            ab.add(descriptor.getStructElements());
        }
        db.add("array", ab.getResult());
        return db.getResult();
    }
}

