/*
 * Decompiled with CFR 0.152.
 */
package pdb.symbolserver;

import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import pdb.symbolserver.AbstractSymbolServer;
import pdb.symbolserver.FindOption;
import pdb.symbolserver.SymbolFileInfo;
import pdb.symbolserver.SymbolFileLocation;
import pdb.symbolserver.SymbolServerInputStream;
import pdb.symbolserver.SymbolStore;
import utilities.util.FileUtilities;

public class LocalSymbolStore
extends AbstractSymbolServer
implements SymbolStore {
    private static final String ADMIN_DIRNAME = "000admin";
    private static final Set<File> ALREADY_WARNED_ABOUT = Collections.synchronizedSet(new HashSet());
    private final File rootDir;

    public static boolean isLocalSymbolStoreLocation(String locationString) {
        if (locationString == null || locationString.isBlank()) {
            return false;
        }
        File dir = new File(locationString);
        return dir.isAbsolute() && dir.isDirectory();
    }

    public static void create(File rootDir, int indexLevel) throws IOException {
        FileUtilities.checkedMkdirs((File)rootDir);
        switch (indexLevel) {
            case 0: {
                break;
            }
            case 2: {
                File index2File = new File(rootDir, "index2.txt");
                if (!index2File.exists()) {
                    FileUtilities.writeStringToFile((File)index2File, (String)("created by Ghidra LocalSymbolStore " + new Date()));
                }
            }
            case 1: {
                File adminDir;
                File pingmeFile = new File(rootDir, "pingme.txt");
                if (!pingmeFile.exists()) {
                    FileUtilities.writeStringToFile((File)pingmeFile, (String)("created by Ghidra LocalSymbolStore " + new Date()));
                }
                if ((adminDir = new File(rootDir, ADMIN_DIRNAME)).isDirectory()) break;
                FileUtilities.checkedMkdir((File)adminDir);
                break;
            }
            default: {
                throw new IOException("Unsupported storage index level: " + indexLevel);
            }
        }
    }

    public LocalSymbolStore(File rootDir) {
        this.rootDir = rootDir;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    @Override
    public String getName() {
        return this.rootDir.getPath();
    }

    @Override
    public File getAdminDir() {
        return this.storageLevel == 0 ? this.rootDir : new File(this.rootDir, ADMIN_DIRNAME);
    }

    @Override
    public boolean isValid(TaskMonitor monitor) {
        return this.isValid();
    }

    public boolean isValid() {
        return this.rootDir.isDirectory();
    }

    @Override
    public boolean exists(String filename, TaskMonitor monitor) {
        File f = new File(this.rootDir, filename);
        return f.isFile();
    }

    @Override
    protected int detectStorageLevel(TaskMonitor monitor) {
        File pingMeFile = new File(this.rootDir, "pingme.txt");
        File adminDir = new File(this.rootDir, ADMIN_DIRNAME);
        if (pingMeFile.isFile() && adminDir.isDirectory()) {
            return super.detectStorageLevel(monitor);
        }
        return this.doHackyStorageLevelDetection(monitor);
    }

    private int doHackyStorageLevelDetection(TaskMonitor monitor) {
        File[] possibleLevel2SymbolDirs;
        if (this.containsPdbSymbolDirsWithFiles(this.rootDir)) {
            if (ALREADY_WARNED_ABOUT.add(this.rootDir)) {
                Msg.warn((Object)this, (Object)("Symbol directory missing control files, guessing storage scheme as level 1: " + this.rootDir));
            }
            return 1;
        }
        for (File dir : possibleLevel2SymbolDirs = LocalSymbolStore.list(this.rootDir, f -> f.isDirectory() && f.getName().length() == 2)) {
            if (!this.containsPdbSymbolDirsWithFiles(dir)) continue;
            if (ALREADY_WARNED_ABOUT.add(this.rootDir)) {
                Msg.warn((Object)this, (Object)("Symbol directory missing control files, guessing storage scheme as level 2: " + this.rootDir));
            }
            return 2;
        }
        return 0;
    }

    private boolean containsPdbSymbolDirsWithFiles(File testDir) {
        File[] possibleLevel1SymbolDirs;
        for (File dir : possibleLevel1SymbolDirs = LocalSymbolStore.list(testDir, f -> f.isDirectory() && f.getName().toLowerCase().endsWith(".pdb"))) {
            if (LocalSymbolStore.list(dir, f -> f.isDirectory() && SymbolFileInfo.fromSubdirectoryPath("doesntmatter", f.getName()) != null && new File(f, dir.getName()).isFile()).length <= 0) continue;
            Msg.debug((Object)this, (Object)("Detected symbol file directory: " + dir));
            return true;
        }
        return false;
    }

    @Override
    public List<SymbolFileLocation> find(SymbolFileInfo symbolFileInfo, Set<FindOption> options, TaskMonitor monitor) {
        this.initStorageLevelIfNeeded(monitor);
        ArrayList<SymbolFileLocation> matches = new ArrayList<SymbolFileLocation>();
        if (this.storageLevel != 0) {
            matches.addAll(super.find(symbolFileInfo, options, monitor));
            if (options.contains((Object)FindOption.ANY_AGE) || options.contains((Object)FindOption.ANY_ID)) {
                try {
                    this.searchLevelN(symbolFileInfo, options, matches, monitor);
                }
                catch (IOException ioe) {
                    Msg.warn((Object)this, (Object)("Error searching for " + symbolFileInfo.getName() + " in " + this.rootDir), (Throwable)ioe);
                }
            }
        } else {
            LocalSymbolStore.searchLevel0(this.rootDir, this, symbolFileInfo, options, matches, monitor);
        }
        return matches;
    }

    static void searchLevel0(File rootDir, SymbolStore symbolStore, SymbolFileInfo symbolFileInfo, Set<FindOption> options, List<SymbolFileLocation> matches, TaskMonitor monitor) {
        File f = new File(rootDir, symbolFileInfo.getName());
        if (!f.isFile()) {
            return;
        }
        SymbolFileInfo fileInfo = SymbolFileInfo.fromFile(f, monitor);
        if (fileInfo != null && LocalSymbolStore.hasSymbolFileInfoMatch(symbolFileInfo, fileInfo, options)) {
            matches.add(new SymbolFileLocation(f.getName(), symbolStore, fileInfo));
        }
    }

    private void searchLevelN(SymbolFileInfo symbolFileInfo, Set<FindOption> options, List<SymbolFileLocation> matches, TaskMonitor monitor) throws IOException {
        String fileDir = this.getFileDir(symbolFileInfo.getName());
        for (File subDir : LocalSymbolStore.list(new File(this.rootDir, fileDir), File::isDirectory)) {
            if (monitor.isCancelled()) break;
            this.searchSubDir(subDir, symbolFileInfo, fileDir, options, matches);
        }
    }

    private void searchSubDir(File subDir, SymbolFileInfo symbolFileInfo, String relativeFileDir, Set<FindOption> options, List<SymbolFileLocation> results) {
        String symbolFileName = symbolFileInfo.getName();
        SymbolFileInfo subDirSymbolFileInfo = SymbolFileInfo.fromSubdirectoryPath(symbolFileName, subDir.getName());
        if (subDirSymbolFileInfo != null && !symbolFileInfo.isExactMatch(subDirSymbolFileInfo)) {
            String matchingFile;
            String uniqueDir = relativeFileDir + subDir.getName() + "/";
            if (LocalSymbolStore.hasSymbolFileInfoMatch(symbolFileInfo, subDirSymbolFileInfo, options) && (matchingFile = this.getFirstExists(uniqueDir, null, symbolFileName, LocalSymbolStore.getCompressedFilename(symbolFileName))) != null) {
                results.add(new SymbolFileLocation(matchingFile, this, subDirSymbolFileInfo));
            }
        }
    }

    @Override
    public String getFileLocation(String filename) {
        return this.getFile(filename).getPath();
    }

    @Override
    public File getFile(String path) {
        return new File(this.rootDir, path);
    }

    @Override
    public String giveFile(SymbolFileInfo symbolFileInfo, File file, String filename, TaskMonitor monitor) throws IOException {
        this.initStorageLevelIfNeeded(monitor);
        filename = FilenameUtils.getName((String)filename);
        String relativeDestinationFilename = this.getUniqueFileDir(symbolFileInfo) + filename;
        File destinationFile = new File(this.rootDir, relativeDestinationFilename);
        FileUtilities.checkedMkdirs((File)destinationFile.getParentFile());
        if (destinationFile.isFile()) {
            Msg.info((Object)this, (Object)(this.logPrefix() + ": File already exists: " + destinationFile));
            if (!file.delete()) {
                Msg.warn((Object)this, (Object)(this.logPrefix() + ": Unable to delete source file: " + file));
            }
            return relativeDestinationFilename;
        }
        monitor.setMessage("Storing " + filename + " in local symbol store ");
        if (!file.renameTo(destinationFile)) {
            throw new IOException("Could not move " + file + " to " + destinationFile);
        }
        return relativeDestinationFilename;
    }

    @Override
    public String putStream(SymbolFileInfo symbolFileInfo, SymbolServerInputStream symbolServerInputStream, String filename, TaskMonitor monitor) throws IOException {
        this.initStorageLevelIfNeeded(monitor);
        filename = FilenameUtils.getName((String)filename);
        String relativeDestinationFilename = this.getUniqueFileDir(symbolFileInfo) + filename;
        File destinationFile = new File(this.rootDir, relativeDestinationFilename);
        FileUtilities.checkedMkdirs((File)destinationFile.getParentFile());
        if (destinationFile.isFile()) {
            Msg.info((Object)this, (Object)(this.logPrefix() + ": File already exists: " + destinationFile));
            return relativeDestinationFilename;
        }
        if (destinationFile.isDirectory()) {
            Msg.error((Object)this, (Object)(this.logPrefix() + ": File's location already exists and is a directory: " + destinationFile));
            Msg.error((Object)this, (Object)(this.logPrefix() + ": Possible symbol storage directory misconfiguration!"));
            return relativeDestinationFilename;
        }
        File destinationFileTmp = new File(this.rootDir, relativeDestinationFilename + ".tmp");
        destinationFileTmp.delete();
        long expectedLength = symbolServerInputStream.getExpectedLength();
        String expectedLenMsg = expectedLength >= 0L ? " (" + FileUtilities.formatLength((long)expectedLength) + ")" : "";
        monitor.setIndeterminate(expectedLength < 0L);
        monitor.initialize(expectedLength);
        monitor.setMessage("Storing " + filename + " in local symbol store" + expectedLenMsg);
        try {
            String string;
            block13: {
                InputStream is = symbolServerInputStream.getInputStream();
                try {
                    long bytesCopied = FileUtilities.copyStreamToFile((InputStream)is, (File)destinationFileTmp, (boolean)false, (TaskMonitor)monitor);
                    if (symbolServerInputStream.getExpectedLength() >= 0L && bytesCopied != symbolServerInputStream.getExpectedLength()) {
                        throw new IOException("Copy length mismatch, expected " + symbolServerInputStream.getExpectedLength() + " bytes, got " + bytesCopied);
                    }
                    if (!destinationFileTmp.renameTo(destinationFile)) {
                        throw new IOException("Error renaming temp file " + destinationFileTmp + " to " + destinationFile);
                    }
                    string = relativeDestinationFilename;
                    if (is == null) break block13;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return string;
        }
        finally {
            destinationFileTmp.delete();
        }
    }

    @Override
    public SymbolServerInputStream getFileStream(String filename, TaskMonitor monitor) throws IOException {
        File file = new File(this.rootDir, filename);
        return new SymbolServerInputStream(new FileInputStream(file), file.length());
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    public String toString() {
        return String.format("LocalSymbolStore: [ rootDir: %s, storageLevel: %d]", this.rootDir.getPath(), this.storageLevel);
    }

    private String logPrefix() {
        return this.getClass().getSimpleName() + "[" + this.rootDir + "]";
    }

    static File[] list(File dir, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        return files != null ? files : new File[]{};
    }

    static boolean hasSymbolFileInfoMatch(SymbolFileInfo symbolFileInfo, SymbolFileInfo otherSymbolFileInfo, Set<FindOption> options) {
        boolean ageMatches;
        boolean idMatches = symbolFileInfo.getUniqueName().equalsIgnoreCase(otherSymbolFileInfo.getUniqueName());
        boolean bl = ageMatches = symbolFileInfo.getIdentifiers().getAge() == otherSymbolFileInfo.getIdentifiers().getAge();
        if (!options.contains((Object)FindOption.ANY_ID)) {
            return idMatches && (ageMatches || options.contains((Object)FindOption.ANY_AGE));
        }
        return true;
    }
}

