/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.UserDefinedTypeModuleSourceAndLineMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.UserDefinedTypeSourceAndLineMsType;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.util.exception.CancelledException;
import java.math.BigInteger;

public class UdtSourceLineTypeApplier
extends MsTypeApplier {
    public UdtSourceLineTypeApplier(PdbApplicator applicator, AbstractMsType msType) throws IllegalArgumentException {
        super(applicator, UdtSourceLineTypeApplier.validateType(msType));
    }

    @Override
    BigInteger getSize() {
        return BigInteger.ZERO;
    }

    int getLineNumber() {
        if (this.msType instanceof UserDefinedTypeSourceAndLineMsType) {
            return ((UserDefinedTypeSourceAndLineMsType)this.msType).getLineNumber();
        }
        return ((UserDefinedTypeModuleSourceAndLineMsType)this.msType).getLineNumber();
    }

    String getSourceFileName() {
        if (this.msType instanceof UserDefinedTypeSourceAndLineMsType) {
            return ((UserDefinedTypeSourceAndLineMsType)this.msType).getSourceFileName();
        }
        return ((UserDefinedTypeModuleSourceAndLineMsType)this.msType).getSourceFileName();
    }

    RecordNumber getUdtRecordNumber() {
        if (this.msType instanceof UserDefinedTypeSourceAndLineMsType) {
            return ((UserDefinedTypeSourceAndLineMsType)this.msType).getUdtRecordNumber();
        }
        return ((UserDefinedTypeModuleSourceAndLineMsType)this.msType).getUdtRecordNumber();
    }

    @Override
    void apply() throws PdbException, CancelledException {
        String filename = this.getSourceFileName();
        int lineNumber = this.getLineNumber();
        RecordNumber udtRecordNumber = this.getUdtRecordNumber();
        MsTypeApplier typeApplier = this.applicator.getTypeApplier(udtRecordNumber);
        this.applicator.putRecordNumberByFileName(udtRecordNumber, filename);
        if (this.msType instanceof UserDefinedTypeModuleSourceAndLineMsType) {
            int moduleNumber = ((UserDefinedTypeModuleSourceAndLineMsType)this.msType).getModuleNumber();
            this.applicator.putRecordNumberByModuleNumber(udtRecordNumber, moduleNumber);
        }
    }

    private static AbstractMsType validateType(AbstractMsType type) throws IllegalArgumentException {
        if (!(type instanceof UserDefinedTypeSourceAndLineMsType) && !(type instanceof UserDefinedTypeModuleSourceAndLineMsType)) {
            throw new IllegalArgumentException("PDB Incorrectly applying " + type.getClass().getSimpleName() + " to " + UdtSourceLineTypeApplier.class.getSimpleName());
        }
        return type;
    }
}

