/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.type.PrimitiveMsType;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.PdbPrimitiveTypeApplicator;
import ghidra.program.model.data.DataType;
import java.math.BigInteger;

public class PrimitiveTypeApplier
extends MsTypeApplier {
    public PrimitiveTypeApplier(PdbApplicator applicator, PrimitiveMsType msType) {
        super(applicator, msType);
        this.apply();
    }

    @Override
    BigInteger getSize() {
        return BigInteger.valueOf(((PrimitiveMsType)this.msType).getTypeSize());
    }

    @Override
    void apply() {
        this.dataType = this.applyPrimitiveMsType((PrimitiveMsType)this.msType);
    }

    boolean isNoType() {
        return ((PrimitiveMsType)this.msType).getNumber() == 0;
    }

    private DataType applyPrimitiveMsType(PrimitiveMsType type) {
        DataType primitiveDataType = null;
        PdbPrimitiveTypeApplicator primitiveApplicator = this.applicator.getPdbPrimitiveTypeApplicator();
        switch (type.getNumber()) {
            case 0: {
                primitiveDataType = primitiveApplicator.getNoType(type);
                break;
            }
            case 1: {
                primitiveDataType = primitiveApplicator.getNoType(type);
                break;
            }
            case 2: {
                primitiveDataType = primitiveApplicator.getNoType(type);
                break;
            }
            case 3: {
                primitiveDataType = primitiveApplicator.getVoidType();
                break;
            }
            case 259: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.getVoidType());
                break;
            }
            case 515: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.getVoidType());
                break;
            }
            case 771: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.getVoidType());
                break;
            }
            case 1027: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.getVoidType());
                break;
            }
            case 1283: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.getVoidType());
                break;
            }
            case 1539: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.getVoidType());
                break;
            }
            case 1795: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.getVoidType());
                break;
            }
            case 4: {
                primitiveDataType = primitiveApplicator.createTypedefNamedSizedType(type);
                break;
            }
            case 5: {
                primitiveDataType = primitiveApplicator.createUnmappedPdbType(type);
                break;
            }
            case 6: {
                primitiveDataType = primitiveApplicator.createUnmappedPdbType(type);
                break;
            }
            case 7: {
                primitiveDataType = primitiveApplicator.createUnmappedPdbType(type);
                break;
            }
            case 8: {
                primitiveDataType = primitiveApplicator.createTypedefNamedSizedType(type);
                break;
            }
            case 1032: {
                primitiveDataType = primitiveApplicator.createTypedefNamedSizedType(type);
                break;
            }
            case 1544: {
                primitiveDataType = primitiveApplicator.createTypedefNamedSizedType(type);
                break;
            }
            case 1800: {
                primitiveDataType = primitiveApplicator.createTypedefNamedSizedType(type);
                break;
            }
            case 96: {
                primitiveDataType = primitiveApplicator.createUnmappedPdbType(type);
                break;
            }
            case 97: {
                primitiveDataType = primitiveApplicator.createUnmappedPdbType(type);
                break;
            }
            case 98: {
                primitiveDataType = primitiveApplicator.createTypedefNamedSizedType("T_BOOL32FF", 4);
                break;
            }
            case 16: {
                primitiveDataType = primitiveApplicator.getSignedCharType();
                break;
            }
            case 272: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.getSignedCharType());
                break;
            }
            case 528: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.getSignedCharType());
                break;
            }
            case 784: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.getSignedCharType());
                break;
            }
            case 1040: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.getSignedCharType());
                break;
            }
            case 1296: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.getSignedCharType());
                break;
            }
            case 1552: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.getSignedCharType());
                break;
            }
            case 1808: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.getSignedCharType());
                break;
            }
            case 32: {
                primitiveDataType = primitiveApplicator.getUnsignedCharType();
                break;
            }
            case 288: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.getUnsignedCharType());
                break;
            }
            case 544: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.getUnsignedCharType());
                break;
            }
            case 800: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.getUnsignedCharType());
                break;
            }
            case 1056: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.getUnsignedCharType());
                break;
            }
            case 1312: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.getUnsignedCharType());
                break;
            }
            case 1568: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.getUnsignedCharType());
                break;
            }
            case 1824: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.getUnsignedCharType());
                break;
            }
            case 112: {
                primitiveDataType = primitiveApplicator.getCharType();
                break;
            }
            case 368: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.getCharType());
                break;
            }
            case 624: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.getCharType());
                break;
            }
            case 880: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.getCharType());
                break;
            }
            case 1136: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.getCharType());
                break;
            }
            case 1392: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.getCharType());
                break;
            }
            case 1648: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.getCharType());
                break;
            }
            case 1904: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.getCharType());
                break;
            }
            case 113: {
                primitiveDataType = primitiveApplicator.getWideCharType();
                break;
            }
            case 369: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, (DataType)primitiveApplicator.getWideCharType());
                break;
            }
            case 625: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, (DataType)primitiveApplicator.getWideCharType());
                break;
            }
            case 881: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, (DataType)primitiveApplicator.getWideCharType());
                break;
            }
            case 1137: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, (DataType)primitiveApplicator.getWideCharType());
                break;
            }
            case 1393: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, (DataType)primitiveApplicator.getWideCharType());
                break;
            }
            case 1649: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, (DataType)primitiveApplicator.getWideCharType());
                break;
            }
            case 1905: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, (DataType)primitiveApplicator.getWideCharType());
                break;
            }
            case 122: {
                primitiveDataType = primitiveApplicator.getUnicode16Type();
                break;
            }
            case 378: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.getUnicode16Type());
                break;
            }
            case 634: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.getUnicode16Type());
                break;
            }
            case 890: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.getUnicode16Type());
                break;
            }
            case 1146: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.getUnicode16Type());
                break;
            }
            case 1402: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.getUnicode16Type());
                break;
            }
            case 1658: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.getUnicode16Type());
                break;
            }
            case 1914: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.getUnicode16Type());
                break;
            }
            case 123: {
                primitiveDataType = primitiveApplicator.getUnicode32Type();
                break;
            }
            case 379: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.getUnicode32Type());
                break;
            }
            case 635: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.getUnicode32Type());
                break;
            }
            case 891: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.getUnicode32Type());
                break;
            }
            case 1147: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.getUnicode32Type());
                break;
            }
            case 1403: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.getUnicode32Type());
                break;
            }
            case 1659: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.getUnicode32Type());
                break;
            }
            case 1915: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.getUnicode32Type());
                break;
            }
            case 104: {
                primitiveDataType = primitiveApplicator.get8BitIntegerType();
                break;
            }
            case 360: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get8BitIntegerType());
                break;
            }
            case 616: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get8BitIntegerType());
                break;
            }
            case 872: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get8BitIntegerType());
                break;
            }
            case 1128: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get8BitIntegerType());
                break;
            }
            case 1384: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get8BitIntegerType());
                break;
            }
            case 1640: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get8BitIntegerType());
                break;
            }
            case 1896: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get8BitIntegerType());
                break;
            }
            case 105: {
                primitiveDataType = primitiveApplicator.get8BitUnsignedIntegerType();
                break;
            }
            case 361: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get8BitUnsignedIntegerType());
                break;
            }
            case 617: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get8BitUnsignedIntegerType());
                break;
            }
            case 873: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get8BitUnsignedIntegerType());
                break;
            }
            case 1129: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get8BitUnsignedIntegerType());
                break;
            }
            case 1385: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get8BitUnsignedIntegerType());
                break;
            }
            case 1641: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get8BitUnsignedIntegerType());
                break;
            }
            case 1897: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get8BitUnsignedIntegerType());
                break;
            }
            case 17: {
                primitiveDataType = primitiveApplicator.get16BitShortType();
                break;
            }
            case 273: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get16BitShortType());
                break;
            }
            case 529: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get16BitShortType());
                break;
            }
            case 785: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get16BitShortType());
                break;
            }
            case 1041: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get16BitShortType());
                break;
            }
            case 1297: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get16BitShortType());
                break;
            }
            case 1553: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get16BitShortType());
                break;
            }
            case 1809: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get16BitShortType());
                break;
            }
            case 33: {
                primitiveDataType = primitiveApplicator.get16BitUnsignedShortType();
                break;
            }
            case 289: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get16BitUnsignedShortType());
                break;
            }
            case 545: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get16BitUnsignedShortType());
                break;
            }
            case 801: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get16BitUnsignedShortType());
                break;
            }
            case 1057: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get16BitUnsignedShortType());
                break;
            }
            case 1313: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get16BitUnsignedShortType());
                break;
            }
            case 1569: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get16BitUnsignedShortType());
                break;
            }
            case 1825: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get16BitUnsignedShortType());
                break;
            }
            case 114: {
                primitiveDataType = primitiveApplicator.get16BitIntegerType();
                break;
            }
            case 370: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get16BitIntegerType());
                break;
            }
            case 626: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get16BitIntegerType());
                break;
            }
            case 882: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get16BitIntegerType());
                break;
            }
            case 1138: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get16BitIntegerType());
                break;
            }
            case 1394: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get16BitIntegerType());
                break;
            }
            case 1650: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get16BitIntegerType());
                break;
            }
            case 1906: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get16BitIntegerType());
                break;
            }
            case 115: {
                primitiveDataType = primitiveApplicator.get16BitUnsignedIntegerType();
                break;
            }
            case 371: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get16BitUnsignedIntegerType());
                break;
            }
            case 627: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get16BitUnsignedIntegerType());
                break;
            }
            case 883: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get16BitUnsignedIntegerType());
                break;
            }
            case 1139: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get16BitUnsignedIntegerType());
                break;
            }
            case 1395: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get16BitUnsignedIntegerType());
                break;
            }
            case 1651: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get16BitUnsignedIntegerType());
                break;
            }
            case 1907: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get16BitUnsignedIntegerType());
                break;
            }
            case 18: {
                primitiveDataType = primitiveApplicator.get32BitLongType();
                break;
            }
            case 274: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get32BitLongType());
                break;
            }
            case 530: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get32BitLongType());
                break;
            }
            case 786: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get32BitLongType());
                break;
            }
            case 1042: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get32BitLongType());
                break;
            }
            case 1298: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get32BitLongType());
                break;
            }
            case 1554: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get32BitLongType());
                break;
            }
            case 1810: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get32BitLongType());
                break;
            }
            case 34: {
                primitiveDataType = primitiveApplicator.get32BitUnsignedLongType();
                break;
            }
            case 290: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get32BitUnsignedLongType());
                break;
            }
            case 546: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get32BitUnsignedLongType());
                break;
            }
            case 802: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get32BitUnsignedLongType());
                break;
            }
            case 1058: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get32BitUnsignedLongType());
                break;
            }
            case 1314: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get32BitUnsignedLongType());
                break;
            }
            case 1570: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get32BitUnsignedLongType());
                break;
            }
            case 1826: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get32BitUnsignedLongType());
                break;
            }
            case 116: {
                primitiveDataType = primitiveApplicator.get32BitIntegerType();
                break;
            }
            case 372: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get32BitIntegerType());
                break;
            }
            case 628: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get32BitIntegerType());
                break;
            }
            case 884: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get32BitIntegerType());
                break;
            }
            case 1140: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get32BitIntegerType());
                break;
            }
            case 1396: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get32BitIntegerType());
                break;
            }
            case 1652: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get32BitIntegerType());
                break;
            }
            case 1908: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get32BitIntegerType());
                break;
            }
            case 117: {
                primitiveDataType = primitiveApplicator.get32BitUnsignedIntegerType();
                break;
            }
            case 373: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get32BitUnsignedIntegerType());
                break;
            }
            case 629: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get32BitUnsignedIntegerType());
                break;
            }
            case 885: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get32BitUnsignedIntegerType());
                break;
            }
            case 1141: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get32BitUnsignedIntegerType());
                break;
            }
            case 1397: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get32BitUnsignedIntegerType());
                break;
            }
            case 1653: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get32BitUnsignedIntegerType());
                break;
            }
            case 1909: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get32BitUnsignedIntegerType());
                break;
            }
            case 19: {
                primitiveDataType = primitiveApplicator.get64BitLongType();
                break;
            }
            case 275: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get64BitLongType());
                break;
            }
            case 531: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get64BitLongType());
                break;
            }
            case 787: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get64BitLongType());
                break;
            }
            case 1043: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get64BitLongType());
                break;
            }
            case 1299: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get64BitLongType());
                break;
            }
            case 1555: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get64BitLongType());
                break;
            }
            case 1811: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get64BitLongType());
                break;
            }
            case 35: {
                primitiveDataType = primitiveApplicator.get64BitUnsignedLongType();
                break;
            }
            case 291: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get64BitUnsignedLongType());
                break;
            }
            case 547: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get64BitUnsignedLongType());
                break;
            }
            case 803: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get64BitUnsignedLongType());
                break;
            }
            case 1059: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get64BitUnsignedLongType());
                break;
            }
            case 1315: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get64BitUnsignedLongType());
                break;
            }
            case 1571: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get64BitUnsignedLongType());
                break;
            }
            case 1827: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get64BitUnsignedLongType());
                break;
            }
            case 118: {
                primitiveDataType = primitiveApplicator.get64BitIntegerType();
                break;
            }
            case 374: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get64BitIntegerType());
                break;
            }
            case 630: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get64BitIntegerType());
                break;
            }
            case 886: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get64BitIntegerType());
                break;
            }
            case 1142: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get64BitIntegerType());
                break;
            }
            case 1398: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get64BitIntegerType());
                break;
            }
            case 1654: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get64BitIntegerType());
                break;
            }
            case 1910: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get64BitIntegerType());
                break;
            }
            case 119: {
                primitiveDataType = primitiveApplicator.get64BitUnsignedIntegerType();
                break;
            }
            case 375: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get64BitUnsignedIntegerType());
                break;
            }
            case 631: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get64BitUnsignedIntegerType());
                break;
            }
            case 887: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get64BitUnsignedIntegerType());
                break;
            }
            case 1143: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get64BitUnsignedIntegerType());
                break;
            }
            case 1399: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get64BitUnsignedIntegerType());
                break;
            }
            case 1655: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get64BitUnsignedIntegerType());
                break;
            }
            case 1911: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get64BitUnsignedIntegerType());
                break;
            }
            case 20: {
                primitiveDataType = primitiveApplicator.get128BitLongType();
                break;
            }
            case 276: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get128BitLongType());
                break;
            }
            case 532: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get128BitLongType());
                break;
            }
            case 788: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get128BitLongType());
                break;
            }
            case 1044: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get128BitLongType());
                break;
            }
            case 1300: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get128BitLongType());
                break;
            }
            case 1556: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get128BitLongType());
                break;
            }
            case 1812: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get128BitLongType());
                break;
            }
            case 36: {
                primitiveDataType = primitiveApplicator.get128BitUnsignedLongType();
                break;
            }
            case 292: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get128BitUnsignedLongType());
                break;
            }
            case 548: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get128BitUnsignedLongType());
                break;
            }
            case 804: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get128BitUnsignedLongType());
                break;
            }
            case 1060: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get128BitUnsignedLongType());
                break;
            }
            case 1316: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get128BitUnsignedLongType());
                break;
            }
            case 1572: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get128BitUnsignedLongType());
                break;
            }
            case 1828: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get128BitUnsignedLongType());
                break;
            }
            case 120: {
                primitiveDataType = primitiveApplicator.get128BitIntegerType();
                break;
            }
            case 376: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get128BitIntegerType());
                break;
            }
            case 632: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get128BitIntegerType());
                break;
            }
            case 888: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get128BitIntegerType());
                break;
            }
            case 1144: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get128BitIntegerType());
                break;
            }
            case 1400: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get128BitIntegerType());
                break;
            }
            case 1656: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get128BitIntegerType());
                break;
            }
            case 1912: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get128BitIntegerType());
                break;
            }
            case 121: {
                primitiveDataType = primitiveApplicator.get128BitUnsignedIntegerType();
                break;
            }
            case 377: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get128BitUnsignedIntegerType());
                break;
            }
            case 633: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get128BitUnsignedIntegerType());
                break;
            }
            case 889: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get128BitUnsignedIntegerType());
                break;
            }
            case 1145: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get128BitUnsignedIntegerType());
                break;
            }
            case 1401: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get128BitUnsignedIntegerType());
                break;
            }
            case 1657: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get128BitUnsignedIntegerType());
                break;
            }
            case 1913: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get128BitUnsignedIntegerType());
                break;
            }
            case 70: {
                primitiveDataType = primitiveApplicator.get16BitRealType();
                break;
            }
            case 326: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get16BitRealType());
                break;
            }
            case 582: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get16BitRealType());
                break;
            }
            case 838: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get16BitRealType());
                break;
            }
            case 1094: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get16BitRealType());
                break;
            }
            case 1350: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get16BitRealType());
                break;
            }
            case 1606: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get16BitRealType());
                break;
            }
            case 1862: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get16BitRealType());
                break;
            }
            case 64: {
                primitiveDataType = primitiveApplicator.get32BitRealType();
                break;
            }
            case 320: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get32BitRealType());
                break;
            }
            case 576: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get32BitRealType());
                break;
            }
            case 832: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get32BitRealType());
                break;
            }
            case 1088: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get32BitRealType());
                break;
            }
            case 1344: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get32BitRealType());
                break;
            }
            case 1600: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get32BitRealType());
                break;
            }
            case 1856: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get32BitRealType());
                break;
            }
            case 69: {
                primitiveDataType = primitiveApplicator.get32BitPartialPrecisionRealType();
                break;
            }
            case 325: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get32BitPartialPrecisionRealType());
                break;
            }
            case 581: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get32BitPartialPrecisionRealType());
                break;
            }
            case 837: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get32BitPartialPrecisionRealType());
                break;
            }
            case 1093: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get32BitPartialPrecisionRealType());
                break;
            }
            case 1349: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get32BitPartialPrecisionRealType());
                break;
            }
            case 1605: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get32BitPartialPrecisionRealType());
                break;
            }
            case 1861: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get32BitPartialPrecisionRealType());
                break;
            }
            case 68: {
                primitiveDataType = primitiveApplicator.get48BitRealType();
                break;
            }
            case 324: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get48BitRealType());
                break;
            }
            case 580: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get48BitRealType());
                break;
            }
            case 836: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get48BitRealType());
                break;
            }
            case 1092: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get48BitRealType());
                break;
            }
            case 1348: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get48BitRealType());
                break;
            }
            case 1604: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get48BitRealType());
                break;
            }
            case 1860: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get48BitRealType());
                break;
            }
            case 65: {
                primitiveDataType = primitiveApplicator.get64BitRealType();
                break;
            }
            case 321: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get64BitRealType());
                break;
            }
            case 577: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get64BitRealType());
                break;
            }
            case 833: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get64BitRealType());
                break;
            }
            case 1089: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get64BitRealType());
                break;
            }
            case 1345: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get64BitRealType());
                break;
            }
            case 1601: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get64BitRealType());
                break;
            }
            case 1857: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get64BitRealType());
                break;
            }
            case 66: {
                primitiveDataType = primitiveApplicator.get80BitRealType();
                break;
            }
            case 322: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get80BitRealType());
                break;
            }
            case 578: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get80BitRealType());
                break;
            }
            case 834: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get80BitRealType());
                break;
            }
            case 1090: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get80BitRealType());
                break;
            }
            case 1346: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get80BitRealType());
                break;
            }
            case 1602: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get80BitRealType());
                break;
            }
            case 1858: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get80BitRealType());
                break;
            }
            case 67: {
                primitiveDataType = primitiveApplicator.get128BitRealType();
                break;
            }
            case 323: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get128BitRealType());
                break;
            }
            case 579: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get128BitRealType());
                break;
            }
            case 835: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get128BitRealType());
                break;
            }
            case 1091: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get128BitRealType());
                break;
            }
            case 1347: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get128BitRealType());
                break;
            }
            case 1603: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get128BitRealType());
                break;
            }
            case 1859: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get128BitRealType());
                break;
            }
            case 80: {
                primitiveDataType = primitiveApplicator.get32BitComplexType();
                break;
            }
            case 336: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get32BitComplexType());
                break;
            }
            case 592: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get32BitComplexType());
                break;
            }
            case 848: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get32BitComplexType());
                break;
            }
            case 1104: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get32BitComplexType());
                break;
            }
            case 1360: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get32BitComplexType());
                break;
            }
            case 1616: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get32BitComplexType());
                break;
            }
            case 1872: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get32BitComplexType());
                break;
            }
            case 81: {
                primitiveDataType = primitiveApplicator.get64BitComplexType();
                break;
            }
            case 337: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get64BitComplexType());
                break;
            }
            case 593: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get64BitComplexType());
                break;
            }
            case 849: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get64BitComplexType());
                break;
            }
            case 1105: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get64BitComplexType());
                break;
            }
            case 1361: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get64BitComplexType());
                break;
            }
            case 1617: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get64BitComplexType());
                break;
            }
            case 1873: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get64BitComplexType());
                break;
            }
            case 82: {
                primitiveDataType = primitiveApplicator.get80BitComplexType();
                break;
            }
            case 338: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get80BitComplexType());
                break;
            }
            case 594: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get80BitComplexType());
                break;
            }
            case 850: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get80BitComplexType());
                break;
            }
            case 1106: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get80BitComplexType());
                break;
            }
            case 1362: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get80BitComplexType());
                break;
            }
            case 1618: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get80BitComplexType());
                break;
            }
            case 1874: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get80BitComplexType());
                break;
            }
            case 83: {
                primitiveDataType = primitiveApplicator.get128BitComplexType();
                break;
            }
            case 339: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get128BitComplexType());
                break;
            }
            case 595: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get128BitComplexType());
                break;
            }
            case 851: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get128BitComplexType());
                break;
            }
            case 1107: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get128BitComplexType());
                break;
            }
            case 1363: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get128BitComplexType());
                break;
            }
            case 1619: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get128BitComplexType());
                break;
            }
            case 1875: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get128BitComplexType());
                break;
            }
            case 84: {
                primitiveDataType = primitiveApplicator.get48BitComplexType();
                break;
            }
            case 340: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get48BitComplexType());
                break;
            }
            case 596: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get48BitComplexType());
                break;
            }
            case 852: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get48BitComplexType());
                break;
            }
            case 1108: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get48BitComplexType());
                break;
            }
            case 1364: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get48BitComplexType());
                break;
            }
            case 1620: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get48BitComplexType());
                break;
            }
            case 1876: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get48BitComplexType());
                break;
            }
            case 85: {
                primitiveDataType = primitiveApplicator.get32BitPartialPrecisionComplexType();
                break;
            }
            case 341: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get32BitPartialPrecisionComplexType());
                break;
            }
            case 597: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get32BitPartialPrecisionComplexType());
                break;
            }
            case 853: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get32BitPartialPrecisionComplexType());
                break;
            }
            case 1109: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get32BitPartialPrecisionComplexType());
                break;
            }
            case 1365: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get32BitPartialPrecisionComplexType());
                break;
            }
            case 1621: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get32BitPartialPrecisionComplexType());
                break;
            }
            case 1877: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get32BitPartialPrecisionComplexType());
                break;
            }
            case 86: {
                primitiveDataType = primitiveApplicator.get16BitComplexType();
                break;
            }
            case 342: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get16BitComplexType());
                break;
            }
            case 598: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get16BitComplexType());
                break;
            }
            case 854: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get16BitComplexType());
                break;
            }
            case 1110: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get16BitComplexType());
                break;
            }
            case 1366: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get16BitComplexType());
                break;
            }
            case 1622: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get16BitComplexType());
                break;
            }
            case 1878: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get16BitComplexType());
                break;
            }
            case 48: {
                primitiveDataType = primitiveApplicator.get8BitBooleanType();
                break;
            }
            case 304: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get8BitBooleanType());
                break;
            }
            case 560: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get8BitBooleanType());
                break;
            }
            case 816: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get8BitBooleanType());
                break;
            }
            case 1072: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get8BitBooleanType());
                break;
            }
            case 1328: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get8BitBooleanType());
                break;
            }
            case 1584: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get8BitBooleanType());
                break;
            }
            case 1840: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get8BitBooleanType());
                break;
            }
            case 49: {
                primitiveDataType = primitiveApplicator.get16BitBooleanType();
                break;
            }
            case 305: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get16BitBooleanType());
                break;
            }
            case 561: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get16BitBooleanType());
                break;
            }
            case 817: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get16BitBooleanType());
                break;
            }
            case 1073: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get16BitBooleanType());
                break;
            }
            case 1329: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get16BitBooleanType());
                break;
            }
            case 1585: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get16BitBooleanType());
                break;
            }
            case 1841: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get16BitBooleanType());
                break;
            }
            case 50: {
                primitiveDataType = primitiveApplicator.get32BitBooleanType();
                break;
            }
            case 306: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get32BitBooleanType());
                break;
            }
            case 562: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get32BitBooleanType());
                break;
            }
            case 818: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get32BitBooleanType());
                break;
            }
            case 1074: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get32BitBooleanType());
                break;
            }
            case 1330: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get32BitBooleanType());
                break;
            }
            case 1586: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get32BitBooleanType());
                break;
            }
            case 1842: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get32BitBooleanType());
                break;
            }
            case 51: {
                primitiveDataType = primitiveApplicator.get64BitBooleanType();
                break;
            }
            case 307: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get64BitBooleanType());
                break;
            }
            case 563: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get64BitBooleanType());
                break;
            }
            case 819: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get64BitBooleanType());
                break;
            }
            case 1075: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get64BitBooleanType());
                break;
            }
            case 1331: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get64BitBooleanType());
                break;
            }
            case 1587: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get64BitBooleanType());
                break;
            }
            case 1843: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get64BitBooleanType());
                break;
            }
            case 52: {
                primitiveDataType = primitiveApplicator.get128BitBooleanType();
                break;
            }
            case 308: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.get128BitBooleanType());
                break;
            }
            case 564: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.get128BitBooleanType());
                break;
            }
            case 820: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.get128BitBooleanType());
                break;
            }
            case 1076: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.get128BitBooleanType());
                break;
            }
            case 1332: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.get128BitBooleanType());
                break;
            }
            case 1588: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.get128BitBooleanType());
                break;
            }
            case 1844: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.get128BitBooleanType());
                break;
            }
            case 496: {
                primitiveDataType = primitiveApplicator.get16NearPointerType(type, primitiveApplicator.createTypedefNamedSizedType("CVInternal", 1));
                break;
            }
            case 752: {
                primitiveDataType = primitiveApplicator.get1616FarPointerType(type, primitiveApplicator.createTypedefNamedSizedType("CVInternal", 1));
                break;
            }
            case 1008: {
                primitiveDataType = primitiveApplicator.get1616HugePointerType(type, primitiveApplicator.createTypedefNamedSizedType("CVInternal", 1));
                break;
            }
            case 1264: {
                primitiveDataType = primitiveApplicator.get32PointerType(type, primitiveApplicator.createTypedefNamedSizedType("CVInternal", 1));
                break;
            }
            case 1520: {
                primitiveDataType = primitiveApplicator.get1632PointerType(type, primitiveApplicator.createTypedefNamedSizedType("CVInternal", 1));
                break;
            }
            case 1776: {
                primitiveDataType = primitiveApplicator.get64PointerType(type, primitiveApplicator.createTypedefNamedSizedType("CVInternal", 1));
                break;
            }
            case 2032: {
                primitiveDataType = primitiveApplicator.get128PointerType(type, primitiveApplicator.createTypedefNamedSizedType("CVInternal", 1));
                break;
            }
            default: {
                primitiveDataType = primitiveApplicator.createUnmappedPdbType(type);
            }
        }
        return primitiveDataType;
    }
}

