/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.Numeric;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractStructureMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MsProperty;

public class Structure19MsType
extends AbstractStructureMsType {
    public static final int PDB_ID = 5641;

    public Structure19MsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.property = new MsProperty(reader);
        int x = reader.parseUnsignedShortVal();
        this.fieldDescriptorListRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        this.derivedFromListRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        this.vShapeTableRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        Numeric numericUnknown = new Numeric(reader);
        Numeric numeric = new Numeric(reader);
        if (!numeric.isIntegral()) {
            throw new PdbException("Expecting integral numeric");
        }
        this.size = numeric.getIntegral();
        if (reader.hasMoreNonPad()) {
            this.name = reader.parseString(pdb, StringParseType.StringNt);
            if (reader.hasMoreNonPad()) {
                this.mangledName = reader.parseString(pdb, StringParseType.StringNt);
            }
        }
        reader.skipPadding();
    }

    @Override
    public int getPdbId() {
        return 5641;
    }
}

