/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.RegisterName;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractProcedureMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ProcedureFlags;

public abstract class AbstractProcedureStartIa64MsSymbol
extends AbstractProcedureMsSymbol {
    protected long parentPointer;
    protected long endPointer;
    protected long nextPointer;
    protected long procedureLength;
    protected long debugStartOffset;
    protected long debugEndOffset;
    protected RecordNumber typeRecordNumber;
    protected long symbolOffset;
    protected int symbolSegment;
    protected int registerIndexContainingReturnValue;
    protected RegisterName registerContainingReturnValue;
    protected ProcedureFlags procedureFlags;
    protected String name;

    public AbstractProcedureStartIa64MsSymbol(AbstractPdb pdb, PdbByteReader reader, StringParseType strType) throws PdbException {
        super(pdb, reader);
        this.parentPointer = reader.parseUnsignedIntVal();
        this.endPointer = reader.parseUnsignedIntVal();
        this.nextPointer = reader.parseUnsignedIntVal();
        this.procedureLength = reader.parseUnsignedIntVal();
        this.debugStartOffset = reader.parseUnsignedIntVal();
        this.debugEndOffset = reader.parseUnsignedIntVal();
        this.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        this.symbolOffset = reader.parseUnsignedIntVal();
        this.symbolSegment = pdb.parseSegment(reader);
        this.registerIndexContainingReturnValue = reader.parseUnsignedShortVal();
        this.registerContainingReturnValue = new RegisterName(pdb, this.registerIndexContainingReturnValue);
        this.procedureFlags = new ProcedureFlags(reader);
        this.name = reader.parseString(pdb, strType);
    }

    @Override
    public long getParentPointer() {
        return this.parentPointer;
    }

    @Override
    public long getEndPointer() {
        return this.endPointer;
    }

    @Override
    public long getNextPointer() {
        return this.nextPointer;
    }

    @Override
    public long getProcedureLength() {
        return this.procedureLength;
    }

    @Override
    public long getDebugStartOffset() {
        return this.debugStartOffset;
    }

    @Override
    public long getDebugEndOffset() {
        return this.debugEndOffset;
    }

    @Override
    public RecordNumber getTypeRecordNumber() {
        return this.typeRecordNumber;
    }

    @Override
    public long getOffset() {
        return this.symbolOffset;
    }

    @Override
    public int getSegment() {
        return this.symbolSegment;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: [%04X:%08X], Length: %08X, %s: %s, ", this.getSymbolTypeName(), this.symbolSegment, this.symbolOffset, this.procedureLength, this.getSpecialTypeString(), this.pdb.getTypeRecord(this.typeRecordNumber)));
        builder.append(this.name);
        builder.append(String.format("   Parent: %08X, End: %08X, Next: %08X\n", this.parentPointer, this.endPointer, this.nextPointer));
        builder.append(String.format("   Debug start: %08X, Debug end: %08X\n", this.debugStartOffset, this.debugEndOffset));
        builder.append(String.format("   %s\n", this.procedureFlags));
        builder.append(String.format("   Return Reg: %s\n", this.registerContainingReturnValue));
    }

    protected abstract String getSpecialTypeString();
}

