/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.msf;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderOptions;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.AbstractMsf;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.Msf200;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.Msf700;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Objects;

public class MsfParser {
    public static AbstractMsf parse(String filename, PdbReaderOptions pdbOptions, TaskMonitor monitor) throws IOException, PdbException, CancelledException {
        AbstractMsf msf;
        Objects.requireNonNull(filename, "filename cannot be null");
        Objects.requireNonNull(pdbOptions, "pdbOptions cannot be null");
        Objects.requireNonNull(monitor, "monitor cannot be null");
        RandomAccessFile file = new RandomAccessFile(filename, "r");
        if (Msf200.detected(file)) {
            msf = new Msf200(file, pdbOptions);
        } else if (Msf700.detected(file)) {
            msf = new Msf700(file, pdbOptions);
        } else {
            file.close();
            throw new PdbException("MSF format not detected");
        }
        msf.deserialize(monitor);
        return msf;
    }
}

