/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AlignMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AnnotationMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AnnotationReferenceMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ArmSwitchTableMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AttribLocOrParamReltoAMPMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AttribLocOrParamReltoVFPMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AttributedLocalOrParameterSIMRMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AttributedLocalOrParameterSIRMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.BadMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.BasePointerRelative16MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.BasePointerRelative3216MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.BasePointerRelative32MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.BasePointerRelative32StMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Block16MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Block32MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Block32StMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.BuildInformationMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.CalleesMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.CallersMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ChangeExecutionModel16MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ChangeExecutionModel32MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.CobolUserDefinedType16MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.CobolUserDefinedTypeMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.CobolUserDefinedTypeStMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Compile2MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Compile2StMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Compile3MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.CompileFlagsMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Constant16MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ConstantMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ConstantStMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.CvReservedMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.DataReferenceMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.DataReferenceStMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.DeferredProcedureCallPointerTagRegDimDARMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.DeferredProcedureCallPointerTagToSymbolRecordMapMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.DefinedMultipleAddressRanges2005MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.DefinedSingleAddressRange2005MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.DefinedSingleAddressRangeMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.DiscardedByLinkMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.EndArgumentsListMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.EndMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.EnregisteredFieldOfSymbolDARMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.EnregisteredSymbolDARMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.EnregisteredSymbolRelativeDARMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.EntryThisMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.EnvironmentBlockMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ExportMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ExtraFrameAndProcedureInformationMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.FileStaticMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.FramePointerRelativeDARMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.FramePointerRelativeFullScopeDARMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.FrameSecurityCookieMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalData16MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalData3216MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalData32MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalData32StMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalDataHLSL32ExtMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalDataHLSL32MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalDataHLSLMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalManagedDataMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalManagedDataStMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalManagedProcedureMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalManagedProcedureStMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalProcedure32IdMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalProcedureIa64IdMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalProcedureMipsIdMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalProcedureStart16MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalProcedureStart3216MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalProcedureStart32MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalProcedureStart32StMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalProcedureStartIa64MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalProcedureStartIa64StMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalProcedureStartMips16MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalProcedureStartMipsMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalProcedureStartMipsStMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalThreadStorage3216MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalThreadStorage32MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.GlobalThreadStorage32StMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.HeapAllocationSiteMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.HighLevelShaderLanguageRegDimDARMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.IndexForTypeReferencedByNameFromMetadataMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.IndirectCallSiteInfoMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.InlinedFunctionCallsiteExtendedMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.InlinedFunctionCallsiteMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.InlinedFunctionEndMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Label16MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Label32MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Label32StMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalData16MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalData3216MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalData32MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalData32StMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalDataHLSL32ExtMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalDataHLSL32MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalDataHLSLMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalDeferredProcedureCallGroupSharedMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalManagedDataMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalManagedDataStMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalManagedProcedureMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalManagedProcedureStMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalProcedure32DeferredProcedureCallIdMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalProcedure32IdMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalProcedureIa64IdMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalProcedureMipsIdMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalProcedureReferenceMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalProcedureReferenceStMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalProcedureStart16MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalProcedureStart3216MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalProcedureStart32DeferredProcedureCallMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalProcedureStart32MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalProcedureStart32StMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalProcedureStartIa64MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalProcedureStartIa64StMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalProcedureStartMips16MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalProcedureStartMipsMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalProcedureStartMipsStMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalSlotIndexFieldedLILMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalSlotIndexFieldedLILStMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalSymbolInOptimizedCode2005MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalSymbolInOptimizedCodeMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalThreadStorage3216MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalThreadStorage32MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalThreadStorage32StMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ManLocOrParamReltoAMPMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ManLocOrParamReltoAMPStMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ManLocOrParamReltoVFPMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ManLocOrParamReltoVFPStMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ManagedConstantMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ManagedLocalOrParameterSIMR2MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ManagedLocalOrParameterSIMR2StMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ManagedLocalOrParameterSIMRMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ManagedLocalOrParameterSIMRStMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ManagedLocalOrParameterSIRMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ManagedLocalOrParameterSIRStMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ManagedSymbolWithSlotIndexFieldMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ManagedSymbolWithSlotIndexFieldStMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ManyRegisterVariable16MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ManyRegisterVariable2MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ManyRegisterVariable2StMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ManyRegisterVariableMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ManyRegisterVariableStMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.MapToMiniPdbMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.MiniPdbReferenceMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ModuleTypeReferenceMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ObjectNameMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ObjectNameStMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.OemDefinedMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ParameterSlotIndexFieldedLILMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ParameterSlotIndexFieldedLILStMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.PeCoffGroupMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.PeCoffSectionMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ProcedureIdEndMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ProcedureReferenceMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ProcedureReferenceStMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ProfileGuidedOptimizationDataMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Public16MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Public3216MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Public32MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Public32StMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Register16MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.RegisterMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.RegisterRelativeAddress16MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.RegisterRelativeAddress3216MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.RegisterRelativeAddress32MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.RegisterRelativeAddress32StMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.RegisterStMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Reserved1MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Reserved2MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Reserved3MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Reserved4MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ReturnDescriptionMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.SeparatedCodeFromCompilerSupportMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.SkipMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.StartSearchMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.StaticLinkForMipsExceptionHandlingMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.SubfieldDARMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Thunk16MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Thunk32MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Thunk32StMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.TokenReferenceToManagedProcedureMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.TrampolineMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.UnknownMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.UnknownX1166MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.UnknownX1167MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.UnknownX1168MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.UserDefinedType16MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.UserDefinedTypeMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.UserDefinedTypeStMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.UsingNamespaceMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.UsingNamespaceStMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.VirtualFunctionTable16MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.VirtualFunctionTable3216MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.VirtualFunctionTable32MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.With16MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.With32MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.With32StMsSymbol;
import ghidra.util.exception.CancelledException;
import java.util.Objects;

public class SymbolParser {
    private AbstractPdb pdb;

    public SymbolParser(AbstractPdb pdb) {
        Objects.requireNonNull(pdb, "pdb cannot be null");
        this.pdb = pdb;
    }

    public AbstractMsSymbol parse(PdbByteReader reader) throws PdbException, CancelledException {
        AbstractMsSymbol symbol;
        int symbolTypeId = reader.parseUnsignedShortVal();
        try {
            symbol = this.parseRecord(symbolTypeId, reader);
        }
        catch (PdbException e) {
            symbol = new BadMsSymbol(this.pdb, symbolTypeId);
        }
        return symbol;
    }

    private AbstractMsSymbol parseRecord(int symbolTypeId, PdbByteReader reader) throws PdbException, CancelledException {
        this.pdb.getPdbReaderMetrics().witnessSymbolTypeId(symbolTypeId);
        AbstractMsSymbol symbol = null;
        switch (symbolTypeId) {
            case 1: {
                symbol = new CompileFlagsMsSymbol(this.pdb, reader);
                break;
            }
            case 2: {
                symbol = new Register16MsSymbol(this.pdb, reader);
                break;
            }
            case 3: {
                symbol = new Constant16MsSymbol(this.pdb, reader);
                break;
            }
            case 4: {
                symbol = new UserDefinedType16MsSymbol(this.pdb, reader);
                break;
            }
            case 5: {
                symbol = new StartSearchMsSymbol(this.pdb, reader);
                break;
            }
            case 6: {
                symbol = new EndMsSymbol(this.pdb, reader);
                break;
            }
            case 7: {
                symbol = new SkipMsSymbol(this.pdb, reader);
                break;
            }
            case 8: {
                symbol = new CvReservedMsSymbol(this.pdb, reader);
                break;
            }
            case 9: {
                symbol = new ObjectNameStMsSymbol(this.pdb, reader);
                break;
            }
            case 10: {
                symbol = new EndArgumentsListMsSymbol(this.pdb, reader);
                break;
            }
            case 11: {
                symbol = new CobolUserDefinedType16MsSymbol(this.pdb, reader);
                break;
            }
            case 12: {
                symbol = new ManyRegisterVariable16MsSymbol(this.pdb, reader);
                break;
            }
            case 13: {
                symbol = new ReturnDescriptionMsSymbol(this.pdb, reader);
                break;
            }
            case 14: {
                symbol = new EntryThisMsSymbol(this.pdb, reader);
                break;
            }
            case 256: {
                symbol = new BasePointerRelative16MsSymbol(this.pdb, reader);
                break;
            }
            case 257: {
                symbol = new LocalData16MsSymbol(this.pdb, reader);
                break;
            }
            case 258: {
                symbol = new GlobalData16MsSymbol(this.pdb, reader);
                break;
            }
            case 259: {
                symbol = new Public16MsSymbol(this.pdb, reader);
                break;
            }
            case 260: {
                symbol = new LocalProcedureStart16MsSymbol(this.pdb, reader);
                break;
            }
            case 261: {
                symbol = new GlobalProcedureStart16MsSymbol(this.pdb, reader);
                break;
            }
            case 262: {
                symbol = new Thunk16MsSymbol(this.pdb, reader);
                break;
            }
            case 263: {
                symbol = new Block16MsSymbol(this.pdb, reader);
                break;
            }
            case 264: {
                symbol = new With16MsSymbol(this.pdb, reader);
                break;
            }
            case 265: {
                symbol = new Label16MsSymbol(this.pdb, reader);
                break;
            }
            case 266: {
                symbol = new ChangeExecutionModel16MsSymbol(this.pdb, reader);
                break;
            }
            case 267: {
                symbol = new VirtualFunctionTable16MsSymbol(this.pdb, reader);
                break;
            }
            case 268: {
                symbol = new RegisterRelativeAddress16MsSymbol(this.pdb, reader);
                break;
            }
            case 512: {
                symbol = new BasePointerRelative3216MsSymbol(this.pdb, reader);
                break;
            }
            case 513: {
                symbol = new LocalData3216MsSymbol(this.pdb, reader);
                break;
            }
            case 514: {
                symbol = new GlobalData3216MsSymbol(this.pdb, reader);
                break;
            }
            case 515: {
                symbol = new Public3216MsSymbol(this.pdb, reader);
                break;
            }
            case 516: {
                symbol = new LocalProcedureStart3216MsSymbol(this.pdb, reader);
                break;
            }
            case 517: {
                symbol = new GlobalProcedureStart3216MsSymbol(this.pdb, reader);
                break;
            }
            case 518: {
                symbol = new Thunk32StMsSymbol(this.pdb, reader);
                break;
            }
            case 519: {
                symbol = new Block32StMsSymbol(this.pdb, reader);
                break;
            }
            case 520: {
                symbol = new With32StMsSymbol(this.pdb, reader);
                break;
            }
            case 521: {
                symbol = new Label32StMsSymbol(this.pdb, reader);
                break;
            }
            case 522: {
                symbol = new ChangeExecutionModel32MsSymbol(this.pdb, reader);
                break;
            }
            case 523: {
                symbol = new VirtualFunctionTable3216MsSymbol(this.pdb, reader);
                break;
            }
            case 524: {
                symbol = new RegisterRelativeAddress3216MsSymbol(this.pdb, reader);
                break;
            }
            case 525: {
                symbol = new LocalThreadStorage3216MsSymbol(this.pdb, reader);
                break;
            }
            case 526: {
                symbol = new GlobalThreadStorage3216MsSymbol(this.pdb, reader);
                break;
            }
            case 527: {
                symbol = new StaticLinkForMipsExceptionHandlingMsSymbol(this.pdb, reader);
                break;
            }
            case 768: {
                symbol = new LocalProcedureStartMips16MsSymbol(this.pdb, reader);
                break;
            }
            case 769: {
                symbol = new GlobalProcedureStartMips16MsSymbol(this.pdb, reader);
                break;
            }
            case 1024: {
                symbol = new ProcedureReferenceStMsSymbol(this.pdb, reader);
                break;
            }
            case 1025: {
                symbol = new DataReferenceStMsSymbol(this.pdb, reader);
                break;
            }
            case 1026: {
                symbol = new AlignMsSymbol(this.pdb, reader);
                break;
            }
            case 1027: {
                symbol = new LocalProcedureReferenceStMsSymbol(this.pdb, reader);
                break;
            }
            case 1028: {
                symbol = new OemDefinedMsSymbol(this.pdb, reader);
                break;
            }
            case 4097: {
                symbol = new RegisterStMsSymbol(this.pdb, reader);
                break;
            }
            case 4098: {
                symbol = new ConstantStMsSymbol(this.pdb, reader);
                break;
            }
            case 4099: {
                symbol = new UserDefinedTypeStMsSymbol(this.pdb, reader);
                break;
            }
            case 4100: {
                symbol = new CobolUserDefinedTypeStMsSymbol(this.pdb, reader);
                break;
            }
            case 4101: {
                symbol = new ManyRegisterVariableStMsSymbol(this.pdb, reader);
                break;
            }
            case 4102: {
                symbol = new BasePointerRelative32StMsSymbol(this.pdb, reader);
                break;
            }
            case 4103: {
                symbol = new LocalData32StMsSymbol(this.pdb, reader);
                break;
            }
            case 4104: {
                symbol = new GlobalData32StMsSymbol(this.pdb, reader);
                break;
            }
            case 4105: {
                symbol = new Public32StMsSymbol(this.pdb, reader);
                break;
            }
            case 4106: {
                symbol = new LocalProcedureStart32StMsSymbol(this.pdb, reader);
                break;
            }
            case 4107: {
                symbol = new GlobalProcedureStart32StMsSymbol(this.pdb, reader);
                break;
            }
            case 4108: {
                symbol = new VirtualFunctionTable32MsSymbol(this.pdb, reader);
                break;
            }
            case 4109: {
                symbol = new RegisterRelativeAddress32StMsSymbol(this.pdb, reader);
                break;
            }
            case 4110: {
                symbol = new LocalThreadStorage32StMsSymbol(this.pdb, reader);
                break;
            }
            case 4111: {
                symbol = new GlobalThreadStorage32StMsSymbol(this.pdb, reader);
                break;
            }
            case 4112: {
                symbol = new LocalProcedureStartMipsStMsSymbol(this.pdb, reader);
                break;
            }
            case 4113: {
                symbol = new GlobalProcedureStartMipsStMsSymbol(this.pdb, reader);
                break;
            }
            case 4114: {
                symbol = new ExtraFrameAndProcedureInformationMsSymbol(this.pdb, reader);
                break;
            }
            case 4115: {
                symbol = new Compile2StMsSymbol(this.pdb, reader);
                break;
            }
            case 4116: {
                symbol = new ManyRegisterVariable2StMsSymbol(this.pdb, reader);
                break;
            }
            case 4117: {
                symbol = new LocalProcedureStartIa64StMsSymbol(this.pdb, reader);
                break;
            }
            case 4118: {
                symbol = new GlobalProcedureStartIa64StMsSymbol(this.pdb, reader);
                break;
            }
            case 4119: {
                symbol = new LocalSlotIndexFieldedLILStMsSymbol(this.pdb, reader);
                break;
            }
            case 4120: {
                symbol = new ParameterSlotIndexFieldedLILStMsSymbol(this.pdb, reader);
                break;
            }
            case 4121: {
                symbol = new AnnotationMsSymbol(this.pdb, reader);
                break;
            }
            case 4122: {
                symbol = new GlobalManagedProcedureStMsSymbol(this.pdb, reader);
                break;
            }
            case 4123: {
                symbol = new LocalManagedProcedureStMsSymbol(this.pdb, reader);
                break;
            }
            case 4124: {
                symbol = new Reserved1MsSymbol(this.pdb, reader);
                break;
            }
            case 4125: {
                symbol = new Reserved2MsSymbol(this.pdb, reader);
                break;
            }
            case 4126: {
                symbol = new Reserved3MsSymbol(this.pdb, reader);
                break;
            }
            case 4127: {
                symbol = new Reserved4MsSymbol(this.pdb, reader);
                break;
            }
            case 4128: {
                symbol = new LocalManagedDataStMsSymbol(this.pdb, reader);
                break;
            }
            case 4129: {
                symbol = new GlobalManagedDataStMsSymbol(this.pdb, reader);
                break;
            }
            case 4130: {
                symbol = new ManLocOrParamReltoVFPStMsSymbol(this.pdb, reader);
                break;
            }
            case 4131: {
                symbol = new ManagedLocalOrParameterSIRStMsSymbol(this.pdb, reader);
                break;
            }
            case 4132: {
                symbol = new ManagedSymbolWithSlotIndexFieldStMsSymbol(this.pdb, reader);
                break;
            }
            case 4133: {
                symbol = new ManagedLocalOrParameterSIMRStMsSymbol(this.pdb, reader);
                break;
            }
            case 4134: {
                symbol = new ManLocOrParamReltoAMPStMsSymbol(this.pdb, reader);
                break;
            }
            case 4135: {
                symbol = new ManagedLocalOrParameterSIMR2StMsSymbol(this.pdb, reader);
                break;
            }
            case 4136: {
                symbol = new IndexForTypeReferencedByNameFromMetadataMsSymbol(this.pdb, reader);
                break;
            }
            case 4137: {
                symbol = new UsingNamespaceStMsSymbol(this.pdb, reader);
                break;
            }
            case 4353: {
                symbol = new ObjectNameMsSymbol(this.pdb, reader);
                break;
            }
            case 4354: {
                symbol = new Thunk32MsSymbol(this.pdb, reader);
                break;
            }
            case 4355: {
                symbol = new Block32MsSymbol(this.pdb, reader);
                break;
            }
            case 4356: {
                symbol = new With32MsSymbol(this.pdb, reader);
                break;
            }
            case 4357: {
                symbol = new Label32MsSymbol(this.pdb, reader);
                break;
            }
            case 4358: {
                symbol = new RegisterMsSymbol(this.pdb, reader);
                break;
            }
            case 4359: {
                symbol = new ConstantMsSymbol(this.pdb, reader);
                break;
            }
            case 4360: {
                symbol = new UserDefinedTypeMsSymbol(this.pdb, reader);
                break;
            }
            case 4361: {
                symbol = new CobolUserDefinedTypeMsSymbol(this.pdb, reader);
                break;
            }
            case 4362: {
                symbol = new ManyRegisterVariableMsSymbol(this.pdb, reader);
                break;
            }
            case 4363: {
                symbol = new BasePointerRelative32MsSymbol(this.pdb, reader);
                break;
            }
            case 4364: {
                symbol = new LocalData32MsSymbol(this.pdb, reader);
                break;
            }
            case 4365: {
                symbol = new GlobalData32MsSymbol(this.pdb, reader);
                break;
            }
            case 4366: {
                symbol = new Public32MsSymbol(this.pdb, reader);
                break;
            }
            case 4367: {
                symbol = new LocalProcedureStart32MsSymbol(this.pdb, reader);
                break;
            }
            case 4368: {
                symbol = new GlobalProcedureStart32MsSymbol(this.pdb, reader);
                break;
            }
            case 4369: {
                symbol = new RegisterRelativeAddress32MsSymbol(this.pdb, reader);
                break;
            }
            case 4370: {
                symbol = new LocalThreadStorage32MsSymbol(this.pdb, reader);
                break;
            }
            case 4371: {
                symbol = new GlobalThreadStorage32MsSymbol(this.pdb, reader);
                break;
            }
            case 4372: {
                symbol = new LocalProcedureStartMipsMsSymbol(this.pdb, reader);
                break;
            }
            case 4373: {
                symbol = new GlobalProcedureStartMipsMsSymbol(this.pdb, reader);
                break;
            }
            case 4374: {
                symbol = new Compile2MsSymbol(this.pdb, reader);
                break;
            }
            case 4375: {
                symbol = new ManyRegisterVariable2MsSymbol(this.pdb, reader);
                break;
            }
            case 4376: {
                symbol = new LocalProcedureStartIa64MsSymbol(this.pdb, reader);
                break;
            }
            case 4377: {
                symbol = new GlobalProcedureStartIa64MsSymbol(this.pdb, reader);
                break;
            }
            case 4378: {
                symbol = new LocalSlotIndexFieldedLILMsSymbol(this.pdb, reader);
                break;
            }
            case 4379: {
                symbol = new ParameterSlotIndexFieldedLILMsSymbol(this.pdb, reader);
                break;
            }
            case 4380: {
                symbol = new LocalManagedDataMsSymbol(this.pdb, reader);
                break;
            }
            case 4381: {
                symbol = new GlobalManagedDataMsSymbol(this.pdb, reader);
                break;
            }
            case 4382: {
                symbol = new ManLocOrParamReltoVFPMsSymbol(this.pdb, reader);
                break;
            }
            case 4383: {
                symbol = new ManagedLocalOrParameterSIRMsSymbol(this.pdb, reader);
                break;
            }
            case 4384: {
                symbol = new ManagedSymbolWithSlotIndexFieldMsSymbol(this.pdb, reader);
                break;
            }
            case 4385: {
                symbol = new ManagedLocalOrParameterSIMRMsSymbol(this.pdb, reader);
                break;
            }
            case 4386: {
                symbol = new ManLocOrParamReltoAMPMsSymbol(this.pdb, reader);
                break;
            }
            case 4387: {
                symbol = new ManagedLocalOrParameterSIMR2MsSymbol(this.pdb, reader);
                break;
            }
            case 4388: {
                symbol = new UsingNamespaceMsSymbol(this.pdb, reader);
                break;
            }
            case 4389: {
                symbol = new ProcedureReferenceMsSymbol(this.pdb, reader);
                break;
            }
            case 4390: {
                symbol = new DataReferenceMsSymbol(this.pdb, reader);
                break;
            }
            case 4391: {
                symbol = new LocalProcedureReferenceMsSymbol(this.pdb, reader);
                break;
            }
            case 4392: {
                symbol = new AnnotationReferenceMsSymbol(this.pdb, reader);
                break;
            }
            case 4393: {
                symbol = new TokenReferenceToManagedProcedureMsSymbol(this.pdb, reader);
                break;
            }
            case 4394: {
                symbol = new GlobalManagedProcedureMsSymbol(this.pdb, reader);
                break;
            }
            case 4395: {
                symbol = new LocalManagedProcedureMsSymbol(this.pdb, reader);
                break;
            }
            case 4396: {
                symbol = new TrampolineMsSymbol(this.pdb, reader);
                break;
            }
            case 4397: {
                symbol = new ManagedConstantMsSymbol(this.pdb, reader);
                break;
            }
            case 4398: {
                symbol = new AttribLocOrParamReltoVFPMsSymbol(this.pdb, reader);
                break;
            }
            case 4399: {
                symbol = new AttributedLocalOrParameterSIRMsSymbol(this.pdb, reader);
                break;
            }
            case 4400: {
                symbol = new AttribLocOrParamReltoAMPMsSymbol(this.pdb, reader);
                break;
            }
            case 4401: {
                symbol = new AttributedLocalOrParameterSIMRMsSymbol(this.pdb, reader);
                break;
            }
            case 4402: {
                symbol = new SeparatedCodeFromCompilerSupportMsSymbol(this.pdb, reader);
                break;
            }
            case 4403: {
                symbol = new LocalSymbolInOptimizedCode2005MsSymbol(this.pdb, reader);
                break;
            }
            case 4404: {
                symbol = new DefinedSingleAddressRange2005MsSymbol(this.pdb, reader);
                break;
            }
            case 4405: {
                symbol = new DefinedMultipleAddressRanges2005MsSymbol(this.pdb, reader);
                break;
            }
            case 4406: {
                symbol = new PeCoffSectionMsSymbol(this.pdb, reader);
                break;
            }
            case 4407: {
                symbol = new PeCoffGroupMsSymbol(this.pdb, reader);
                break;
            }
            case 4408: {
                symbol = new ExportMsSymbol(this.pdb, reader);
                break;
            }
            case 4409: {
                symbol = new IndirectCallSiteInfoMsSymbol(this.pdb, reader);
                break;
            }
            case 4410: {
                symbol = new FrameSecurityCookieMsSymbol(this.pdb, reader);
                break;
            }
            case 4411: {
                symbol = new DiscardedByLinkMsSymbol(this.pdb, reader);
                break;
            }
            case 4412: {
                symbol = new Compile3MsSymbol(this.pdb, reader);
                break;
            }
            case 4413: {
                symbol = new EnvironmentBlockMsSymbol(this.pdb, reader);
                break;
            }
            case 4414: {
                symbol = new LocalSymbolInOptimizedCodeMsSymbol(this.pdb, reader);
                break;
            }
            case 4415: {
                symbol = new DefinedSingleAddressRangeMsSymbol(this.pdb, reader);
                break;
            }
            case 4416: {
                symbol = new SubfieldDARMsSymbol(this.pdb, reader);
                break;
            }
            case 4417: {
                symbol = new EnregisteredSymbolDARMsSymbol(this.pdb, reader);
                break;
            }
            case 4418: {
                symbol = new FramePointerRelativeDARMsSymbol(this.pdb, reader);
                break;
            }
            case 4419: {
                symbol = new EnregisteredFieldOfSymbolDARMsSymbol(this.pdb, reader);
                break;
            }
            case 4420: {
                symbol = new FramePointerRelativeFullScopeDARMsSymbol(this.pdb, reader);
                break;
            }
            case 4421: {
                symbol = new EnregisteredSymbolRelativeDARMsSymbol(this.pdb, reader);
                break;
            }
            case 4422: {
                symbol = new LocalProcedure32IdMsSymbol(this.pdb, reader);
                break;
            }
            case 4423: {
                symbol = new GlobalProcedure32IdMsSymbol(this.pdb, reader);
                break;
            }
            case 4424: {
                symbol = new LocalProcedureMipsIdMsSymbol(this.pdb, reader);
                break;
            }
            case 4425: {
                symbol = new GlobalProcedureMipsIdMsSymbol(this.pdb, reader);
                break;
            }
            case 4426: {
                symbol = new LocalProcedureIa64IdMsSymbol(this.pdb, reader);
                break;
            }
            case 4427: {
                symbol = new GlobalProcedureIa64IdMsSymbol(this.pdb, reader);
                break;
            }
            case 4428: {
                symbol = new BuildInformationMsSymbol(this.pdb, reader);
                break;
            }
            case 4429: {
                symbol = new InlinedFunctionCallsiteMsSymbol(this.pdb, reader);
                break;
            }
            case 4430: {
                symbol = new InlinedFunctionEndMsSymbol(this.pdb, reader);
                break;
            }
            case 4431: {
                symbol = new ProcedureIdEndMsSymbol(this.pdb, reader);
                break;
            }
            case 4432: {
                symbol = new HighLevelShaderLanguageRegDimDARMsSymbol(this.pdb, reader);
                break;
            }
            case 4433: {
                symbol = new GlobalDataHLSLMsSymbol(this.pdb, reader);
                break;
            }
            case 4434: {
                symbol = new LocalDataHLSLMsSymbol(this.pdb, reader);
                break;
            }
            case 4435: {
                symbol = new FileStaticMsSymbol(this.pdb, reader);
                break;
            }
            case 4436: {
                symbol = new LocalDeferredProcedureCallGroupSharedMsSymbol(this.pdb, reader);
                break;
            }
            case 4437: {
                symbol = new LocalProcedureStart32DeferredProcedureCallMsSymbol(this.pdb, reader);
                break;
            }
            case 4438: {
                symbol = new LocalProcedure32DeferredProcedureCallIdMsSymbol(this.pdb, reader);
                break;
            }
            case 4439: {
                symbol = new DeferredProcedureCallPointerTagRegDimDARMsSymbol(this.pdb, reader);
                break;
            }
            case 4440: {
                symbol = new DeferredProcedureCallPointerTagToSymbolRecordMapMsSymbol(this.pdb, reader);
                break;
            }
            case 4441: {
                symbol = new ArmSwitchTableMsSymbol(this.pdb, reader);
                break;
            }
            case 4442: {
                symbol = new CalleesMsSymbol(this.pdb, reader);
                break;
            }
            case 4443: {
                symbol = new CallersMsSymbol(this.pdb, reader);
                break;
            }
            case 4444: {
                symbol = new ProfileGuidedOptimizationDataMsSymbol(this.pdb, reader);
                break;
            }
            case 4445: {
                symbol = new InlinedFunctionCallsiteExtendedMsSymbol(this.pdb, reader);
                break;
            }
            case 4446: {
                symbol = new HeapAllocationSiteMsSymbol(this.pdb, reader);
                break;
            }
            case 4447: {
                symbol = new ModuleTypeReferenceMsSymbol(this.pdb, reader);
                break;
            }
            case 4448: {
                symbol = new MiniPdbReferenceMsSymbol(this.pdb, reader);
                break;
            }
            case 4449: {
                symbol = new MapToMiniPdbMsSymbol(this.pdb, reader);
                break;
            }
            case 4450: {
                symbol = new GlobalDataHLSL32MsSymbol(this.pdb, reader);
                break;
            }
            case 4451: {
                symbol = new LocalDataHLSL32MsSymbol(this.pdb, reader);
                break;
            }
            case 4452: {
                symbol = new GlobalDataHLSL32ExtMsSymbol(this.pdb, reader);
                break;
            }
            case 4453: {
                symbol = new LocalDataHLSL32ExtMsSymbol(this.pdb, reader);
                break;
            }
            case 4454: {
                symbol = new UnknownX1166MsSymbol(this.pdb, reader);
                break;
            }
            case 4455: {
                symbol = new UnknownX1167MsSymbol(this.pdb, reader);
                break;
            }
            case 4456: {
                symbol = new UnknownX1168MsSymbol(this.pdb, reader);
                break;
            }
            default: {
                symbol = new UnknownMsSymbol(this.pdb, reader, symbolTypeId);
            }
        }
        return symbol;
    }
}

