/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.workflow;

import ghidra.app.plugin.core.debug.service.workflow.AbstractMultiToolTraceListener;
import ghidra.app.plugin.core.debug.service.workflow.DebuggerWorkflowServicePlugin;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.trace.model.Trace;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;

public class MultiToolTraceListenerManager<L extends AbstractMultiToolTraceListener> {
    private final Function<Trace, L> listenerFactory;
    private final Map<Trace, L> listenersByTrace = new HashMap<Trace, L>();

    public MultiToolTraceListenerManager(Function<Trace, L> listenerFactory) {
        this.listenerFactory = listenerFactory;
    }

    public synchronized void enable(DebuggerWorkflowServicePlugin wp) {
        for (PluginTool tool : wp.getProxyingPluginTools()) {
            DebuggerTraceManagerService traceManager = (DebuggerTraceManagerService)tool.getService(DebuggerTraceManagerService.class);
            if (traceManager == null) continue;
            for (Trace trace : traceManager.getOpenTraces()) {
                AbstractMultiToolTraceListener listener = this.listenersByTrace.computeIfAbsent(trace, t -> {
                    AbstractMultiToolTraceListener l = (AbstractMultiToolTraceListener)((Object)((Object)this.listenerFactory.apply((Trace)t)));
                    l.init();
                    return l;
                });
                listener.openedBy(tool);
            }
        }
    }

    public synchronized void disable() {
        Iterator<L> it = this.listenersByTrace.values().iterator();
        while (it.hasNext()) {
            AbstractMultiToolTraceListener listener = (AbstractMultiToolTraceListener)((Object)it.next());
            listener.dispose();
            it.remove();
        }
    }

    public synchronized void traceOpened(PluginTool tool, Trace trace) {
        AbstractMultiToolTraceListener listener = this.listenersByTrace.computeIfAbsent(trace, t -> {
            AbstractMultiToolTraceListener l = (AbstractMultiToolTraceListener)((Object)((Object)this.listenerFactory.apply((Trace)t)));
            l.init();
            return l;
        });
        listener.openedBy(tool);
    }

    public synchronized void traceClosed(PluginTool tool, Trace trace) {
        if (((AbstractMultiToolTraceListener)((Object)this.listenersByTrace.get(trace))).closedBy(tool)) {
            ((AbstractMultiToolTraceListener)((Object)this.listenersByTrace.remove(trace))).dispose();
        }
    }
}

