/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.lldb;

import ghidra.app.plugin.core.debug.service.model.launch.AbstractDebuggerProgramLaunchOffer;
import ghidra.app.plugin.core.debug.service.model.launch.DebuggerProgramLaunchOffer;
import ghidra.app.plugin.core.debug.service.model.launch.DebuggerProgramLaunchOpinion;
import ghidra.app.services.DebuggerModelService;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.util.PathUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class LldbDebuggerProgramLaunchOpinion
implements DebuggerProgramLaunchOpinion {
    @Override
    public Collection<DebuggerProgramLaunchOffer> getOffers(Program program, PluginTool tool, DebuggerModelService service) {
        String exe = program.getExecutablePath();
        if (exe == null || "".equals(exe.trim())) {
            return List.of();
        }
        ArrayList<DebuggerProgramLaunchOffer> offers = new ArrayList<DebuggerProgramLaunchOffer>();
        for (DebuggerModelFactory factory : service.getModelFactories()) {
            if (!factory.isCompatible()) continue;
            String clsName = factory.getClass().getName();
            if (clsName.equals("agent.lldb.LldbInJvmDebuggerModelFactory")) {
                offers.add(new InVmLldbDebuggerProgramLaunchOffer(program, tool, factory));
                continue;
            }
            if (!clsName.equals("agent.lldb.gadp.LldbLocalDebuggerModelFactory")) continue;
            offers.add(new GadpLldbDebuggerProgramLaunchOffer(program, tool, factory));
        }
        return offers;
    }

    protected class GadpLldbDebuggerProgramLaunchOffer
    extends AbstractLldbDebuggerProgramLaunchOffer {
        private static final String FACTORY_CLS_NAME = "agent.lldb.gadp.LldbLocalDebuggerModelFactory";

        public GadpLldbDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
            super(program, tool, factory);
        }

        @Override
        public String getConfigName() {
            return "GADP LLDB";
        }

        @Override
        public String getMenuTitle() {
            return "in LLDB locally via GADP";
        }
    }

    protected class InVmLldbDebuggerProgramLaunchOffer
    extends AbstractLldbDebuggerProgramLaunchOffer {
        private static final String FACTORY_CLS_NAME = "agent.lldb.LldbInJvmDebuggerModelFactory";

        public InVmLldbDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
            super(program, tool, factory);
        }

        @Override
        public String getConfigName() {
            return "IN-VM LLDB";
        }

        @Override
        public String getMenuTitle() {
            return "in LLDB locally IN-VM";
        }
    }

    protected static abstract class AbstractLldbDebuggerProgramLaunchOffer
    extends AbstractDebuggerProgramLaunchOffer {
        public AbstractLldbDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
            super(program, tool, factory);
        }

        @Override
        protected List<String> getLauncherPath() {
            return PathUtils.parse((String)"");
        }

        @Override
        protected Map<String, ?> generateDefaultLauncherArgs(Map<String, TargetMethod.ParameterDescription<?>> params) {
            return Map.of("args", this.program.getExecutablePath());
        }
    }
}

