/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.interpreters;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import ghidra.app.plugin.core.console.CodeCompletion;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.interpreters.DebuggerInterpreterConnection;
import ghidra.app.plugin.core.debug.gui.interpreters.DebuggerInterpreterPlugin;
import ghidra.app.plugin.core.interpreter.InterpreterComponentProvider;
import ghidra.app.plugin.core.interpreter.InterpreterConsole;
import ghidra.dbg.AnnotatedDebuggerAttributeListener;
import ghidra.dbg.DebugModelConventions;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.target.TargetConsole;
import ghidra.dbg.target.TargetInterruptible;
import ghidra.dbg.target.TargetObject;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ImageIcon;

public abstract class AbstractDebuggerWrappedConsoleConnection<T extends TargetObject>
implements DebuggerInterpreterConnection {
    protected final DebuggerInterpreterPlugin plugin;
    protected final T targetConsole;
    protected final AtomicBoolean running = new AtomicBoolean(false);
    protected final ForInterpreterListener listener = new ForInterpreterListener();
    protected Thread thread;
    protected InterpreterConsole guiConsole;
    protected BufferedReader inReader;
    protected OutputStream stdOut;
    protected OutputStream stdErr;
    protected ToggleDockingAction actionPin;
    protected boolean pinned = false;

    public AbstractDebuggerWrappedConsoleConnection(DebuggerInterpreterPlugin plugin, T targetConsole) {
        this.plugin = plugin;
        this.targetConsole = targetConsole;
        targetConsole.addListener((DebuggerModelListener)this.listener);
    }

    protected abstract CompletableFuture<Void> sendLine(String var1);

    public String getTitle() {
        return "Interpreter";
    }

    public ImageIcon getIcon() {
        return DebuggerResources.ICON_CONSOLE;
    }

    public List<CodeCompletion> getCompletions(String cmd) {
        return Collections.emptyList();
    }

    public void setConsole(InterpreterConsole guiConsole) {
        assert (this.guiConsole == null);
        this.guiConsole = guiConsole;
        InterpreterComponentProvider provider = (InterpreterComponentProvider)guiConsole;
        provider.setSubTitle(this.targetConsole.getDisplay());
        this.setStdErr(guiConsole.getStdErr());
        this.setStdOut(guiConsole.getStdOut());
        this.setStdIn(guiConsole.getStdin());
        this.createActions();
        if (!this.targetConsole.isValid()) {
            this.consoleInvalidated();
        }
    }

    protected void consoleInvalidated() {
        if (this.pinned) {
            this.running.set(false);
            this.plugin.disableConsole((TargetObject)this.targetConsole, this.guiConsole);
        } else {
            this.plugin.destroyConsole((TargetObject)this.targetConsole, this.guiConsole);
        }
    }

    protected void createActions() {
        this.actionPin = ((ToggleActionBuilder)DebuggerResources.PinInterpreterAction.builder(this.plugin).onAction(this::activatedPin)).selected(this.pinned).build();
        this.guiConsole.addAction((DockingAction)this.actionPin);
        DockingAction interruptAction = ((ActionBuilder)DebuggerResources.InterpreterInterruptAction.builder(this.plugin).onAction(this::sendInterrupt)).build();
        this.guiConsole.addAction(interruptAction);
    }

    public void setStdOut(OutputStream stdOut) {
        this.stdOut = stdOut;
    }

    public void setStdErr(OutputStream stdErr) {
        this.stdErr = stdErr;
    }

    public void setStdIn(InputStream stdIn) {
        this.inReader = new BufferedReader(new InputStreamReader(stdIn));
    }

    public void runInBackground() {
        this.running.set(true);
        this.thread = new Thread(this::run);
        this.thread.start();
    }

    private void activatedPin(ActionContext ignore) {
        this.pinned = this.actionPin.isSelected();
    }

    private void sendInterrupt(ActionContext ignore) {
        CompletableFuture futureInterruptible = DebugModelConventions.suitable(TargetInterruptible.class, this.targetConsole);
        if (futureInterruptible != null) {
            ((CompletableFuture)((CompletableFuture)futureInterruptible.thenCompose(i -> i.interrupt())).thenRun(() -> this.guiConsole.getOutWriter().println("Interrupt sent"))).exceptionally(exc -> {
                this.guiConsole.getErrWriter().println("Failed to send Interrupt");
                return null;
            });
        }
    }

    protected void run() {
        try {
            while (this.running.get()) {
                String line = this.inReader.readLine();
                if (line == null || !this.running.get()) {
                    return;
                }
                this.sendLine(line).exceptionally(e -> {
                    Msg.debug((Object)this, (Object)("Debugger console exception sending '" + line + "'"), (Throwable)e);
                    return null;
                });
            }
        }
        catch (IOException e2) {
            Msg.debug((Object)this, (Object)"Lost console?");
        }
    }

    @Override
    public InterpreterConsole getInterpreterConsole() {
        return this.guiConsole;
    }

    @Override
    public TargetObject getTargetConsole() {
        return this.targetConsole;
    }

    @Override
    public boolean isPinned() {
        return this.pinned;
    }

    @Override
    public void setPinned(boolean pinned) {
        this.pinned = pinned;
        this.actionPin.setSelected(pinned);
    }

    protected class ForInterpreterListener
    extends AnnotatedDebuggerAttributeListener {
        public ForInterpreterListener() {
            super(MethodHandles.lookup());
        }

        public void consoleOutput(TargetObject console, TargetConsole.Channel channel, byte[] out) {
            OutputStream os;
            switch (channel) {
                case STDOUT: {
                    os = AbstractDebuggerWrappedConsoleConnection.this.stdOut;
                    break;
                }
                case STDERR: {
                    os = AbstractDebuggerWrappedConsoleConnection.this.stdErr;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (os == null) {
                return;
            }
            try {
                os.write(out);
                os.write(32);
            }
            catch (IOException e) {
                Msg.error((Object)((Object)this), (Object)"Cannot write to interpreter window: ", (Throwable)e);
            }
        }

        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_display")
        public void displayChanged(TargetObject object, String display) {
            if (AbstractDebuggerWrappedConsoleConnection.this.guiConsole == null) {
                return;
            }
            InterpreterComponentProvider provider = (InterpreterComponentProvider)AbstractDebuggerWrappedConsoleConnection.this.guiConsole;
            Swing.runLater(() -> provider.setSubTitle(display));
        }

        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_prompt")
        public void promptChanged(TargetObject interpreter, String prompt) {
            if (AbstractDebuggerWrappedConsoleConnection.this.guiConsole == null) {
                return;
            }
            Swing.runLater(() -> AbstractDebuggerWrappedConsoleConnection.this.guiConsole.setPrompt(prompt));
        }

        public void invalidated(TargetObject object, TargetObject branch, String reason) {
            Swing.runLater(() -> {
                if (object == AbstractDebuggerWrappedConsoleConnection.this.targetConsole) {
                    AbstractDebuggerWrappedConsoleConnection.this.consoleInvalidated();
                }
            });
        }
    }
}

