/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.diff;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.widgets.OptionDialog;
import ghidra.app.plugin.core.codebrowser.OtherPanelContext;
import ghidra.app.plugin.core.diff.DiffApplySettingsProvider;
import ghidra.app.plugin.core.diff.DiffController;
import ghidra.app.plugin.core.diff.ProgramDiffPlugin;
import ghidra.app.services.CodeViewerService;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

class DiffActionManager {
    private static final String SELECT_GROUP = "Select";
    private static final String GET_DIFF_GROUP = "GetDiff";
    private static final String DIFF_INFO_GROUP = "DiffInfo";
    private static final String DIFF_NAVIGATE_GROUP = "DiffNavigate";
    private static final String TOGGLE_VIEW_ICON_NAME = "images/table_relationship.png";
    private static final String GROUP = "Diff";
    private ProgramDiffPlugin plugin;
    private CodeViewerService codeViewerService;
    static final String APPLY_DIFFS_ACTION = "Apply Differences";
    static final String APPLY_DIFFS_NEXT_ACTION = "Apply Differences and Goto Next Difference";
    static final String IGNORE_DIFFS_NEXT_ACTION = "Ignore Selection and Goto Next Difference";
    static final String NEXT_DIFF_ACTION = "Next Difference";
    static final String PREVIOUS_DIFF_ACTION = "Previous Difference";
    static final String DIFF_DETAILS_ACTION = "Show Diff Location Details";
    static final String SHOW_DIFF_SETTINGS_ACTION = "Show Diff Apply Settings";
    static final String GET_DIFFS_ACTION = "Get Differences";
    static final String SELECT_ALL_DIFFS_ACTION = "Select All Differences";
    static final String P1_SELECT_TO_P2_ACTION = "Set Program1 Selection On Program2";
    static final String OPEN_CLOSE_PROGRAM2_ACTION = "Open/Close Program View";
    static final String VIEW_PROGRAM_DIFF_ACTION = "View Program Differences";
    private DockingAction applyDiffsAction;
    private DockingAction applyDiffsNextAction;
    private DockingAction ignoreDiffsAction;
    private DockingAction nextDiffAction;
    private DockingAction previousDiffAction;
    private DockingAction diffDetailsAction;
    private DockingAction showDiffSettingsAction;
    private DockingAction getDiffsAction;
    private DockingAction selectAllDiffsAction;
    private DockingAction p1SelectToP2Action;
    private ToggleDockingAction openCloseProgram2Action;
    private DockingAction viewProgramDiffAction;

    public DiffActionManager(ProgramDiffPlugin plugin) {
        this.plugin = plugin;
        this.createActions();
    }

    void setCodeViewerService(CodeViewerService codeViewerService) {
        this.codeViewerService = codeViewerService;
        codeViewerService.addLocalAction((DockingAction)this.openCloseProgram2Action);
    }

    void addActions() {
        this.codeViewerService.addLocalAction(this.applyDiffsAction);
        this.codeViewerService.addLocalAction(this.applyDiffsNextAction);
        this.codeViewerService.addLocalAction(this.ignoreDiffsAction);
        this.codeViewerService.addLocalAction(this.diffDetailsAction);
        this.codeViewerService.addLocalAction(this.nextDiffAction);
        this.codeViewerService.addLocalAction(this.previousDiffAction);
        this.codeViewerService.addLocalAction(this.showDiffSettingsAction);
        this.codeViewerService.addLocalAction(this.getDiffsAction);
        this.codeViewerService.addLocalAction(this.selectAllDiffsAction);
        this.codeViewerService.addLocalAction(this.p1SelectToP2Action);
    }

    void removeActions() {
        this.codeViewerService.removeLocalAction(this.applyDiffsAction);
        this.codeViewerService.removeLocalAction(this.applyDiffsNextAction);
        this.codeViewerService.removeLocalAction(this.ignoreDiffsAction);
        this.codeViewerService.removeLocalAction(this.diffDetailsAction);
        this.codeViewerService.removeLocalAction(this.nextDiffAction);
        this.codeViewerService.removeLocalAction(this.previousDiffAction);
        this.codeViewerService.removeLocalAction(this.showDiffSettingsAction);
        this.codeViewerService.removeLocalAction(this.getDiffsAction);
        this.codeViewerService.removeLocalAction(this.selectAllDiffsAction);
        this.codeViewerService.removeLocalAction(this.p1SelectToP2Action);
    }

    void programClosed(Program program) {
        boolean hasProgram = this.plugin.getCurrentProgram() != null;
        this.openCloseProgram2Action.setEnabled(hasProgram && !this.plugin.isTaskInProgress());
    }

    void setActiveProgram(Program program) {
        this.viewProgramDiffAction.setEnabled(program != null);
        boolean enabled = program != null && !this.plugin.isTaskInProgress();
        this.openCloseProgram2Action.setEnabled(enabled);
        if (enabled) {
            if (this.openCloseProgram2Action.isSelected()) {
                Program firstProgram = this.plugin.getFirstProgram();
                if (firstProgram == program) {
                    this.openCloseProgram2Action.setDescription("Close Diff View");
                } else {
                    this.openCloseProgram2Action.setDescription("Bring Diff View to Front");
                }
            }
        } else {
            this.openCloseProgram2Action.setDescription("Open Diff View");
        }
    }

    void secondProgramOpened() {
        this.openCloseProgram2Action.setSelected(true);
        this.openCloseProgram2Action.setDescription("Close Diff View");
        Program firstProgram = this.plugin.getFirstProgram();
        Program secondProgram = this.plugin.getSecondProgram();
        String firstName = firstProgram.getName();
        String secondName = secondProgram.getName();
        this.openCloseProgram2Action.setDescription("<html><center>Close Diff View</center><br>Current diff: <b>" + HTMLUtilities.escapeHTML((String)firstName) + "</b> to <b>" + HTMLUtilities.escapeHTML((String)secondName) + "</b>");
    }

    void secondProgramClosed() {
        this.openCloseProgram2Action.setSelected(false);
        this.openCloseProgram2Action.setDescription("Open Diff View");
        this.showDiffSettingsAction.setEnabled(false);
        this.diffDetailsAction.setEnabled(false);
        this.removeActions();
    }

    void setP1SelectToP2ActionEnabled(boolean enabled) {
        this.p1SelectToP2Action.setEnabled(enabled);
    }

    void setOpenCloseActionSelected(boolean selected) {
        this.openCloseProgram2Action.setSelected(selected);
    }

    void updateActions(boolean taskInProgress, boolean inDiff, boolean hasSelectionInView, boolean applyFilterIsSet, boolean hasProgram2, boolean hasHighlights) {
        DiffController diffControl = this.plugin.getDiffController();
        this.applyDiffsAction.setEnabled(!taskInProgress && inDiff && hasSelectionInView);
        this.applyDiffsNextAction.setEnabled(!taskInProgress && inDiff && hasSelectionInView && diffControl.hasNext());
        this.ignoreDiffsAction.setEnabled(!taskInProgress && inDiff && hasSelectionInView);
        this.nextDiffAction.setEnabled(!taskInProgress && inDiff && diffControl.hasNext());
        this.previousDiffAction.setEnabled(!taskInProgress && inDiff && diffControl.hasPrevious());
        this.diffDetailsAction.setEnabled(!taskInProgress && hasProgram2);
        this.showDiffSettingsAction.setEnabled(!taskInProgress && inDiff);
        this.getDiffsAction.setEnabled(!taskInProgress && hasProgram2);
        this.selectAllDiffsAction.setEnabled(!taskInProgress && !inDiff || hasHighlights);
        this.p1SelectToP2Action.setEnabled(hasProgram2 && !this.plugin.getCurrentSelection().isEmpty());
        Program currentProgram = this.plugin.getCurrentProgram();
        boolean hasProgram = currentProgram != null;
        this.openCloseProgram2Action.setEnabled(hasProgram && !taskInProgress);
    }

    void dispose() {
        this.codeViewerService.removeLocalAction((DockingAction)this.openCloseProgram2Action);
        this.plugin.getTool().removeAction((DockingActionIf)this.viewProgramDiffAction);
        this.removeActions();
    }

    private void createActions() {
        this.viewProgramDiffAction = new DockingAction(VIEW_PROGRAM_DIFF_ACTION, this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                DiffActionManager.this.plugin.selectProgram2();
            }
        };
        String[] menuPath = new String[]{"&Tools", "Program &Differences..."};
        this.viewProgramDiffAction.setEnabled(this.plugin.getCurrentProgram() != null);
        this.viewProgramDiffAction.setMenuBarData(new MenuData(menuPath, "View"));
        this.viewProgramDiffAction.setKeyBindingData(new KeyBindingData(50, 0));
        this.viewProgramDiffAction.setHelpLocation(new HelpLocation(GROUP, "Program_Differences"));
        this.plugin.getTool().addAction((DockingActionIf)this.viewProgramDiffAction);
        this.applyDiffsAction = new DiffAction(APPLY_DIFFS_ACTION){

            public void actionPerformed(ActionContext context) {
                DiffActionManager.this.plugin.applyDiff();
            }
        };
        ImageIcon icon = ResourceManager.loadImage((String)"images/pencil16.png");
        this.applyDiffsAction.setKeyBindingData(new KeyBindingData(114, 0));
        this.applyDiffsAction.setPopupMenuData(new MenuData(new String[]{"Apply Selection"}, (Icon)icon, GROUP));
        this.applyDiffsAction.setDescription("Applies the differences from the second program's selection using the settings.");
        this.applyDiffsAction.setToolBarData(new ToolBarData((Icon)icon, GROUP));
        this.applyDiffsNextAction = new DiffAction(APPLY_DIFFS_NEXT_ACTION){

            public void actionPerformed(ActionContext context) {
                DiffActionManager.this.plugin.applyDiffAndGoNext();
            }
        };
        icon = ResourceManager.loadImage((String)"images/pencil_arrow16.png");
        String[] applyDiffsPath = new String[]{"Apply Selection and Goto Next Difference"};
        this.applyDiffsNextAction.setPopupMenuData(new MenuData(applyDiffsPath, (Icon)icon, GROUP));
        this.applyDiffsNextAction.setKeyBindingData(new KeyBindingData(114, 64));
        this.applyDiffsNextAction.setToolBarData(new ToolBarData((Icon)icon, GROUP));
        this.applyDiffsNextAction.setDescription("Applies the differences from the second program's selection using the settings.  Then moves the cursor to the next difference.");
        this.ignoreDiffsAction = new DiffAction(IGNORE_DIFFS_NEXT_ACTION){

            public void actionPerformed(ActionContext context) {
                DiffActionManager.this.plugin.ignoreDiff();
            }
        };
        icon = ResourceManager.loadImage((String)"images/eraser_arrow16.png");
        this.ignoreDiffsAction.setPopupMenuData(new MenuData(new String[]{IGNORE_DIFFS_NEXT_ACTION}, (Icon)icon, GROUP));
        this.ignoreDiffsAction.setDescription("Ignores the selected program differences and moves the cursor to the next difference.");
        this.ignoreDiffsAction.setToolBarData(new ToolBarData((Icon)icon, GROUP));
        this.nextDiffAction = new DiffAction(NEXT_DIFF_ACTION){

            public void actionPerformed(ActionContext context) {
                DiffActionManager.this.plugin.nextDiff();
            }
        };
        icon = ResourceManager.loadImage((String)"images/down.png");
        this.nextDiffAction.setKeyBindingData(new KeyBindingData('N', 10));
        this.nextDiffAction.setPopupMenuData(new MenuData(new String[]{NEXT_DIFF_ACTION}, (Icon)icon, DIFF_NAVIGATE_GROUP));
        this.nextDiffAction.setToolBarData(new ToolBarData((Icon)icon, DIFF_NAVIGATE_GROUP));
        this.nextDiffAction.setDescription("Go to the next highlighted difference.");
        this.previousDiffAction = new DiffAction(PREVIOUS_DIFF_ACTION){

            public void actionPerformed(ActionContext context) {
                DiffActionManager.this.plugin.previousDiff();
            }
        };
        icon = ResourceManager.loadImage((String)"images/up.png");
        this.previousDiffAction.setKeyBindingData(new KeyBindingData('P', 10));
        this.previousDiffAction.setPopupMenuData(new MenuData(new String[]{PREVIOUS_DIFF_ACTION}, (Icon)icon, DIFF_NAVIGATE_GROUP));
        this.previousDiffAction.setToolBarData(new ToolBarData((Icon)icon, DIFF_NAVIGATE_GROUP));
        this.previousDiffAction.setDescription("Go to previous highlighted difference.");
        this.diffDetailsAction = new DiffAction(DIFF_DETAILS_ACTION){

            public void actionPerformed(ActionContext context) {
                DiffActionManager.this.plugin.showDiffDetails();
            }
        };
        icon = ResourceManager.loadImage((String)"images/xmag.png");
        this.diffDetailsAction.setKeyBindingData(new KeyBindingData(116, 0));
        this.diffDetailsAction.setPopupMenuData(new MenuData(new String[]{"Location Details..."}, (Icon)icon, DIFF_INFO_GROUP));
        this.diffDetailsAction.setToolBarData(new ToolBarData((Icon)icon, DIFF_INFO_GROUP));
        this.diffDetailsAction.setDescription("Show details of the program differences at the current location.");
        this.showDiffSettingsAction = new DiffAction(SHOW_DIFF_SETTINGS_ACTION){

            public void actionPerformed(ActionContext context) {
                DiffActionManager.this.plugin.showDiffApplySettings();
            }
        };
        this.showDiffSettingsAction.setPopupMenuData(new MenuData(new String[]{"Show Diff Apply Settings..."}, GET_DIFF_GROUP));
        this.showDiffSettingsAction.setDescription("Displays the current program difference apply settings.");
        this.showDiffSettingsAction.setToolBarData(new ToolBarData((Icon)DiffApplySettingsProvider.ICON, GET_DIFF_GROUP));
        this.getDiffsAction = new DiffAction(GET_DIFFS_ACTION){

            public void actionPerformed(ActionContext context) {
                DiffActionManager.this.plugin.diff();
            }
        };
        icon = ResourceManager.loadImage((String)"images/Diff16.png");
        this.getDiffsAction.setPopupMenuData(new MenuData(new String[]{"Get Differences..."}, (Icon)icon, GET_DIFF_GROUP));
        this.getDiffsAction.setToolBarData(new ToolBarData((Icon)icon, GET_DIFF_GROUP));
        this.getDiffsAction.setDescription("Determines program differences.");
        this.selectAllDiffsAction = new DiffAction(SELECT_ALL_DIFFS_ACTION){

            public void actionPerformed(ActionContext context) {
                DiffActionManager.this.plugin.selectAllDiffs();
            }
        };
        this.selectAllDiffsAction.setPopupMenuData(new MenuData(new String[]{SELECT_ALL_DIFFS_ACTION}, SELECT_GROUP));
        this.selectAllDiffsAction.setDescription("Selects all highlighted differences in the second program.");
        this.p1SelectToP2Action = new DiffAction(P1_SELECT_TO_P2_ACTION){

            public void actionPerformed(ActionContext context) {
                DiffActionManager.this.plugin.setP1SelectionOnP2();
            }
        };
        icon = ResourceManager.loadImage((String)"images/DiffSelect16.png");
        this.p1SelectToP2Action.setDescription("Select Program 2 highlights using selection in Program 1.");
        this.p1SelectToP2Action.setToolBarData(new ToolBarData((Icon)icon, SELECT_GROUP));
        this.openCloseProgram2Action = new ToggleDockingAction(OPEN_CLOSE_PROGRAM2_ACTION, this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                if (DiffActionManager.this.openCloseProgram2Action.isSelected()) {
                    DiffActionManager.this.plugin.selectProgram2();
                    return;
                }
                if (this.activateDiffProgram()) {
                    this.setSelected(true);
                    this.setDescription("Close Diff View");
                    return;
                }
                this.closeDiff();
            }

            private void closeDiff() {
                int choice = OptionDialog.showYesNoCancelDialog(null, (String)"Close Diff Session", (String)"Close the current diff session?");
                if (choice == 1) {
                    DiffActionManager.this.plugin.closeProgram2();
                    this.setDescription("Open Diff View");
                } else {
                    this.setSelected(true);
                    this.setDescription("Close Diff View");
                }
            }

            private boolean activateDiffProgram() {
                boolean isFirstProgram;
                Program currentProgram = DiffActionManager.this.plugin.getCurrentProgram();
                Program firstProgram = DiffActionManager.this.plugin.getFirstProgram();
                boolean bl = isFirstProgram = firstProgram == currentProgram;
                if (isFirstProgram) {
                    return false;
                }
                DiffActionManager.this.plugin.activeProgram(firstProgram);
                return true;
            }
        };
        icon = ResourceManager.loadImage((String)TOGGLE_VIEW_ICON_NAME);
        this.openCloseProgram2Action.setEnabled(false);
        this.openCloseProgram2Action.setKeyBindingData(new KeyBindingData('C', 10));
        this.openCloseProgram2Action.setToolBarData(new ToolBarData((Icon)icon, "zzz"));
        this.openCloseProgram2Action.setHelpLocation(new HelpLocation(GROUP, OPEN_CLOSE_PROGRAM2_ACTION));
        this.openCloseProgram2Action.setSelected(false);
        this.openCloseProgram2Action.setDescription("Open Diff View");
    }

    private abstract class DiffAction
    extends DockingAction {
        DiffAction(String name) {
            super(name, DiffActionManager.this.plugin.getName());
            this.setHelpLocation(new HelpLocation(DiffActionManager.GROUP, name));
            this.setEnabled(false);
        }

        public boolean isAddToPopup(ActionContext context) {
            return context instanceof OtherPanelContext;
        }
    }
}

