/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.DynamicVariableStorage;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.InputListType;
import ghidra.program.model.lang.ParamList;
import ghidra.program.model.lang.ParamListRegisterOut;
import ghidra.program.model.lang.ParamListStandard;
import ghidra.program.model.lang.ParamListStandardOut;
import ghidra.program.model.lang.PcodeInjectLibrary;
import ghidra.program.model.listing.AutoParameterType;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;

public class PrototypeModel {
    public static final int UNKNOWN_EXTRAPOP = 32768;
    protected String name;
    protected boolean isExtension;
    private int extrapop;
    private int stackshift;
    private ParamList inputParams;
    private ParamList outputParams;
    private Varnode[] unaffected;
    private Varnode[] killedbycall;
    private Varnode[] returnaddress;
    private Varnode[] likelytrash;
    private AddressSet localRange;
    private AddressSet paramRange;
    private InputListType inputListType = InputListType.STANDARD;
    private GenericCallingConvention genericCallingConvention;
    private boolean hasThis;
    private boolean isConstruct;
    private boolean hasUponEntry;
    private boolean hasUponReturn;

    public PrototypeModel(String name, PrototypeModel model) {
        this.name = name;
        this.isExtension = false;
        this.extrapop = model.extrapop;
        this.stackshift = model.stackshift;
        this.inputListType = model.inputListType;
        this.inputParams = model.inputParams;
        this.outputParams = model.outputParams;
        this.unaffected = model.unaffected;
        this.killedbycall = model.killedbycall;
        this.returnaddress = model.returnaddress;
        this.likelytrash = model.likelytrash;
        this.localRange = new AddressSet(model.localRange);
        this.paramRange = new AddressSet(model.paramRange);
        this.hasThis = model.hasThis || name.equals("__thiscall");
        this.isConstruct = model.isConstruct;
        this.genericCallingConvention = GenericCallingConvention.getGenericCallingConvention(name);
        this.hasUponEntry = model.hasUponEntry;
        this.hasUponReturn = model.hasUponReturn;
    }

    public PrototypeModel() {
        this.name = null;
        this.isExtension = false;
        this.extrapop = 32768;
        this.stackshift = -1;
        this.inputParams = null;
        this.outputParams = null;
        this.unaffected = null;
        this.killedbycall = null;
        this.returnaddress = null;
        this.likelytrash = null;
        this.localRange = null;
        this.paramRange = null;
        this.genericCallingConvention = GenericCallingConvention.unknown;
        this.hasThis = false;
        this.isConstruct = false;
        this.hasUponEntry = false;
        this.hasUponReturn = false;
    }

    public GenericCallingConvention getGenericCallingConvention() {
        return this.genericCallingConvention;
    }

    public Varnode[] getUnaffectedList() {
        if (this.unaffected == null) {
            this.unaffected = new Varnode[0];
        }
        return this.unaffected;
    }

    public Varnode[] getKilledByCallList() {
        if (this.killedbycall == null) {
            this.killedbycall = new Varnode[0];
        }
        return this.killedbycall;
    }

    public Varnode[] getLikelyTrash() {
        if (this.likelytrash == null) {
            this.likelytrash = new Varnode[0];
        }
        return this.likelytrash;
    }

    public Varnode[] getReturnAddress() {
        if (this.returnaddress == null) {
            this.returnaddress = new Varnode[0];
        }
        return this.returnaddress;
    }

    public boolean isMerged() {
        return false;
    }

    public boolean isProgramExtension() {
        return this.isExtension;
    }

    public String getName() {
        return this.name;
    }

    public int getExtrapop() {
        return this.extrapop;
    }

    public int getStackshift() {
        return this.stackshift;
    }

    public boolean hasThisPointer() {
        return this.hasThis;
    }

    public boolean isConstructor() {
        return this.isConstruct;
    }

    public InputListType getInputListType() {
        return this.inputListType;
    }

    public boolean hasInjection() {
        return this.hasUponEntry || this.hasUponReturn;
    }

    @Deprecated
    public VariableStorage getReturnLocation(DataType dataType, Program program) {
        DataType clone = dataType.clone(program.getDataTypeManager());
        DataType[] arr = new DataType[]{clone};
        ArrayList<VariableStorage> res = new ArrayList<VariableStorage>();
        this.outputParams.assignMap(program, arr, res, false);
        if (res.size() > 0) {
            return res.get(0);
        }
        return null;
    }

    public VariableStorage getNextArgLocation(Parameter[] params, DataType dataType, Program program) {
        return this.getArgLocation(params != null ? params.length : 0, params, dataType, program);
    }

    public VariableStorage getArgLocation(int argIndex, Parameter[] params, DataType dataType, Program program) {
        if (dataType != null) {
            dataType = dataType.clone(program.getDataTypeManager());
        }
        DataType[] arr = new DataType[argIndex + 2];
        arr[0] = VoidDataType.dataType;
        for (int i = 0; i < argIndex; ++i) {
            arr[i + 1] = params != null && i < params.length ? params[i].getDataType() : DataType.DEFAULT;
        }
        arr[argIndex + 1] = dataType;
        VariableStorage[] res = this.getStorageLocations(program, arr, false);
        return res[res.length - 1];
    }

    public VariableStorage[] getStorageLocations(Program program, DataType[] dataTypes, boolean addAutoParams) {
        boolean injectAutoThisParam = false;
        if (addAutoParams && this.hasThis) {
            injectAutoThisParam = true;
            DataType[] ammendedTypes = new DataType[dataTypes.length + 1];
            ammendedTypes[0] = dataTypes[0];
            ammendedTypes[1] = new PointerDataType(program.getDataTypeManager());
            if (dataTypes.length > 1) {
                System.arraycopy(dataTypes, 1, ammendedTypes, 2, dataTypes.length - 1);
            }
            dataTypes = ammendedTypes;
        }
        ArrayList<VariableStorage> res = new ArrayList<VariableStorage>();
        this.outputParams.assignMap(program, dataTypes, res, addAutoParams);
        this.inputParams.assignMap(program, dataTypes, res, addAutoParams);
        VariableStorage[] finalres = new VariableStorage[res.size()];
        res.toArray(finalres);
        if (injectAutoThisParam) {
            Varnode[] thisVarnodes = finalres[1].getVarnodes();
            int thisIndex = 1;
            try {
                if (finalres[1].isAutoStorage()) {
                    if (this.inputParams.isThisBeforeRetPointer()) {
                        finalres[2] = new DynamicVariableStorage(program, finalres[1].getAutoParameterType(), finalres[2].getVarnodes());
                    } else {
                        thisIndex = 2;
                        thisVarnodes = finalres[2].getVarnodes();
                    }
                }
                finalres[thisIndex] = thisVarnodes.length != 0 ? new DynamicVariableStorage(program, AutoParameterType.THIS, thisVarnodes) : DynamicVariableStorage.getUnassignedDynamicStorage(AutoParameterType.THIS);
            }
            catch (InvalidInputException e) {
                finalres[thisIndex] = DynamicVariableStorage.getUnassignedDynamicStorage(AutoParameterType.THIS);
            }
        }
        return finalres;
    }

    public boolean isErrorPlaceholder() {
        return false;
    }

    private void buildParamList(String strategy) throws XmlParseException {
        if (strategy == null || strategy.equals("standard")) {
            this.inputParams = new ParamListStandard();
            this.outputParams = new ParamListStandardOut();
            this.inputListType = InputListType.STANDARD;
        } else if (strategy.equals("register")) {
            this.inputParams = new ParamListStandard();
            this.outputParams = new ParamListRegisterOut();
            this.inputListType = InputListType.REGISTER;
        } else {
            throw new XmlParseException("Unknown assign strategy: " + strategy);
        }
    }

    public void saveXml(StringBuilder buffer, PcodeInjectLibrary injectLibrary) {
        buffer.append("<prototype");
        SpecXmlUtils.encodeStringAttribute((StringBuilder)buffer, (String)"name", (String)this.name);
        if (this.extrapop != 32768) {
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"extrapop", (long)this.extrapop);
        } else {
            SpecXmlUtils.encodeStringAttribute((StringBuilder)buffer, (String)"extrapop", (String)"unknown");
        }
        SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"stackshift", (long)this.stackshift);
        GenericCallingConvention nameType = GenericCallingConvention.guessFromName(this.name);
        if (nameType != this.genericCallingConvention) {
            SpecXmlUtils.encodeStringAttribute((StringBuilder)buffer, (String)"type", (String)this.genericCallingConvention.getDeclarationName());
        }
        if (this.hasThis) {
            SpecXmlUtils.encodeStringAttribute((StringBuilder)buffer, (String)"hasthis", (String)"yes");
        }
        if (this.isConstruct) {
            SpecXmlUtils.encodeStringAttribute((StringBuilder)buffer, (String)"constructor", (String)"yes");
        }
        if (this.inputListType != InputListType.STANDARD) {
            SpecXmlUtils.encodeStringAttribute((StringBuilder)buffer, (String)"strategy", (String)"register");
        }
        buffer.append(">\n");
        this.inputParams.saveXml(buffer, true);
        buffer.append('\n');
        this.outputParams.saveXml(buffer, false);
        buffer.append('\n');
        if (this.hasUponEntry || this.hasUponReturn) {
            InjectPayload payload = injectLibrary.getPayload(3, this.getInjectName());
            payload.saveXml(buffer);
        }
        if (this.unaffected != null) {
            buffer.append("<unaffected>\n");
            this.writeVarnodes(buffer, this.unaffected);
            buffer.append("</unaffected>\n");
        }
        if (this.killedbycall != null) {
            buffer.append("<killedbycall>\n");
            this.writeVarnodes(buffer, this.killedbycall);
            buffer.append("</killedbycall>\n");
        }
        if (this.likelytrash != null) {
            buffer.append("<likelytrash>\n");
            this.writeVarnodes(buffer, this.likelytrash);
            buffer.append("</likelytrash>\n");
        }
        if (this.returnaddress != null) {
            buffer.append("<returnaddress>\n");
            this.writeVarnodes(buffer, this.returnaddress);
            buffer.append("</returnaddress>\n");
        }
        if (this.localRange != null && !this.localRange.isEmpty()) {
            buffer.append("<localrange>\n");
            this.writeAddressSet(buffer, this.localRange);
            buffer.append("</localrange>\n");
        }
        if (this.paramRange != null && !this.paramRange.isEmpty()) {
            buffer.append("<paramrange>\n");
            this.writeAddressSet(buffer, this.paramRange);
            buffer.append("</paramrange>\n");
        }
        buffer.append("</prototype>\n");
    }

    private void writeVarnodes(StringBuilder buffer, Varnode[] varnodes) {
        for (Varnode vn : varnodes) {
            buffer.append("<varnode");
            AddressXML.appendAttributes(buffer, vn.getAddress(), vn.getSize());
            buffer.append("/>\n");
        }
    }

    private Varnode[] readVarnodes(XmlPullParser parser, CompilerSpec cspec) throws XmlParseException {
        parser.start(new String[0]);
        ArrayList<Varnode> varnodeList = new ArrayList<Varnode>();
        while (parser.peek().isStart()) {
            XmlElement el = parser.start(new String[0]);
            AddressXML ourAddress = AddressXML.restoreXml(el, cspec);
            if (ourAddress.getJoinRecord() != null) {
                throw new XmlParseException("No \"join\" in <unaffected>, <killedbycall>, or <likelytrash>");
            }
            varnodeList.add(ourAddress.getVarnode());
            parser.end(el);
        }
        parser.end();
        Varnode[] res = new Varnode[varnodeList.size()];
        varnodeList.toArray(res);
        return res;
    }

    private void writeAddressSet(StringBuilder buffer, AddressSet addressSet) {
        AddressRangeIterator iter = addressSet.getAddressRanges();
        while (iter.hasNext()) {
            AddressRange addrRange = (AddressRange)iter.next();
            AddressSpace space = addrRange.getAddressSpace();
            long first = addrRange.getMinAddress().getOffset();
            long last = addrRange.getMaxAddress().getOffset();
            if (space.hasSignedOffset()) {
                long mask;
                if (space.getSize() < 64) {
                    mask = 1L;
                    mask <<= space.getSize();
                } else {
                    mask = 0L;
                }
                --mask;
                if (first < 0L && last >= 0L) {
                    buffer.append("<range");
                    SpecXmlUtils.encodeStringAttribute((StringBuilder)buffer, (String)"space", (String)space.getName());
                    SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buffer, (String)"first", (long)(first &= mask));
                    SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buffer, (String)"last", (long)mask);
                    buffer.append("/>\n");
                    first = 0L;
                }
                first &= mask;
                last &= mask;
            }
            buffer.append("<range");
            SpecXmlUtils.encodeStringAttribute((StringBuilder)buffer, (String)"space", (String)space.getName());
            SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buffer, (String)"first", (long)first);
            SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buffer, (String)"last", (long)last);
            buffer.append("/>\n");
        }
    }

    private AddressSet readAddressSet(XmlPullParser parser, CompilerSpec cspec) throws XmlParseException {
        AddressSet addressSet = new AddressSet();
        parser.start(new String[0]);
        while (parser.peek().isStart()) {
            XmlElement el = parser.start(new String[0]);
            AddressXML range = AddressXML.restoreRangeXml(el, cspec);
            parser.end(el);
            Address firstAddr = range.getFirstAddress();
            Address lastAddr = range.getLastAddress();
            addressSet.add(firstAddr, lastAddr);
        }
        parser.end();
        return addressSet;
    }

    protected String getInjectName() {
        if (this.hasUponEntry) {
            return this.name + "@@inject_uponentry";
        }
        return this.name + "@@inject_uponreturn";
    }

    public void restoreXml(XmlPullParser parser, CompilerSpec cspec) throws XmlParseException {
        this.inputParams = null;
        this.outputParams = null;
        XmlElement protoElement = parser.start(new String[0]);
        this.name = protoElement.getAttribute("name");
        this.extrapop = 32768;
        String extpopStr = protoElement.getAttribute("extrapop");
        if (!extpopStr.equals("unknown")) {
            this.extrapop = SpecXmlUtils.decodeInt((String)extpopStr);
        }
        this.stackshift = SpecXmlUtils.decodeInt((String)protoElement.getAttribute("stackshift"));
        String type = protoElement.getAttribute("type");
        this.genericCallingConvention = type != null ? GenericCallingConvention.getGenericCallingConvention(type) : GenericCallingConvention.guessFromName(this.name);
        this.hasThis = false;
        this.isConstruct = false;
        String thisString = protoElement.getAttribute("hasthis");
        this.hasThis = thisString != null ? SpecXmlUtils.decodeBoolean((String)thisString) : this.name.equals("__thiscall");
        String constructString = protoElement.getAttribute("constructor");
        if (constructString != null) {
            this.isConstruct = SpecXmlUtils.decodeBoolean((String)constructString);
        }
        this.buildParamList(protoElement.getAttribute("strategy"));
        while (parser.peek().isStart()) {
            XmlElement subel = parser.peek();
            String elName = subel.getName();
            if (elName.equals("input")) {
                this.inputParams.restoreXml(parser, cspec);
                continue;
            }
            if (elName.equals("output")) {
                this.outputParams.restoreXml(parser, cspec);
                continue;
            }
            if (elName.equals("pcode")) {
                XmlElement el = parser.peek();
                String source = "Compiler spec=" + cspec.getCompilerSpecID().getIdAsString();
                if (el.getAttribute("inject").equals("uponentry")) {
                    this.hasUponEntry = true;
                } else {
                    this.hasUponReturn = true;
                }
                cspec.getPcodeInjectLibrary().restoreXmlInject(source, this.getInjectName(), 3, parser);
                continue;
            }
            if (elName.equals("unaffected")) {
                this.unaffected = this.readVarnodes(parser, cspec);
                continue;
            }
            if (elName.equals("killedbycall")) {
                this.killedbycall = this.readVarnodes(parser, cspec);
                continue;
            }
            if (elName.equals("returnaddress")) {
                this.returnaddress = this.readVarnodes(parser, cspec);
                continue;
            }
            if (elName.equals("likelytrash")) {
                this.likelytrash = this.readVarnodes(parser, cspec);
                continue;
            }
            if (elName.equals("localrange")) {
                this.localRange = this.readAddressSet(parser, cspec);
                continue;
            }
            if (elName.equals("paramrange")) {
                this.paramRange = this.readAddressSet(parser, cspec);
                continue;
            }
            subel = parser.start(new String[0]);
            parser.discardSubTree(subel);
        }
        parser.end(protoElement);
    }

    public boolean possibleInputParamWithSlot(Address loc, int size, ParamList.WithSlotRec res) {
        return this.inputParams.possibleParamWithSlot(loc, size, res);
    }

    public boolean possibleOutputParamWithSlot(Address loc, int size, ParamList.WithSlotRec res) {
        return this.outputParams.possibleParamWithSlot(loc, size, res);
    }

    public int getStackParameterAlignment() {
        return this.inputParams.getStackParameterAlignment();
    }

    public Long getStackParameterOffset() {
        return this.inputParams.getStackParameterOffset();
    }

    public VariableStorage[] getPotentialInputRegisterStorage(Program prog) {
        return this.inputParams.getPotentialRegisterStorage(prog);
    }

    public boolean equals(Object obj) {
        PrototypeModel op2 = (PrototypeModel)obj;
        if (!this.name.equals(op2.name)) {
            return false;
        }
        if (this.extrapop != op2.extrapop || this.stackshift != op2.stackshift) {
            return false;
        }
        if (this.genericCallingConvention != op2.genericCallingConvention) {
            return false;
        }
        if (this.hasThis != op2.hasThis || this.isConstruct != op2.isConstruct) {
            return false;
        }
        if (this.hasUponEntry != op2.hasUponEntry || this.hasUponReturn != op2.hasUponReturn) {
            return false;
        }
        if (this.inputListType != op2.inputListType) {
            return false;
        }
        if (!this.inputParams.equals(op2.inputParams)) {
            return false;
        }
        if (!this.outputParams.equals(op2.outputParams)) {
            return false;
        }
        if (!SystemUtilities.isArrayEqual((Object[])this.unaffected, (Object[])op2.unaffected)) {
            return false;
        }
        if (!SystemUtilities.isArrayEqual((Object[])this.killedbycall, (Object[])op2.killedbycall)) {
            return false;
        }
        if (!SystemUtilities.isArrayEqual((Object[])this.likelytrash, (Object[])op2.likelytrash)) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)this.localRange, (Object)op2.localRange)) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)this.paramRange, (Object)op2.paramRange)) {
            return false;
        }
        return SystemUtilities.isArrayEqual((Object[])this.returnaddress, (Object[])op2.returnaddress);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

