/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.app.plugin.processors.sleigh.VarnodeData;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.SystemUtilities;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ParamEntry {
    private static final int FORCE_LEFT_JUSTIFY = 1;
    private static final int REVERSE_STACK = 2;
    private static final int SMALLSIZE_ZEXT = 4;
    private static final int SMALLSIZE_SEXT = 8;
    private static final int IS_BIG_ENDIAN = 16;
    private static final int SMALLSIZE_INTTYPE = 32;
    private static final int SMALLSIZE_FLOAT = 64;
    private static final int IS_GROUPED = 512;
    public static final int TYPE_UNKNOWN = 8;
    public static final int TYPE_PTR = 2;
    public static final int TYPE_FLOAT = 3;
    private int flags;
    private int type;
    private int group;
    private int groupsize;
    private AddressSpace spaceid;
    private long addressbase;
    private int size;
    private int minsize;
    private int alignment;
    private int numslots;
    private Varnode[] joinrec;

    public ParamEntry(int grp) {
        this.group = grp;
    }

    public int getGroup() {
        return this.group;
    }

    public int getGroupSize() {
        return this.groupsize;
    }

    public int getSize() {
        return this.size;
    }

    public int getMinSize() {
        return this.minsize;
    }

    public int getAlign() {
        return this.alignment;
    }

    public long getAddressBase() {
        return this.addressbase;
    }

    public int getType() {
        return this.type;
    }

    public boolean isExclusion() {
        return this.alignment == 0;
    }

    public boolean isReverseStack() {
        return (this.flags & 2) != 0;
    }

    public boolean isGrouped() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isBigEndian() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isFloatExtended() {
        return (this.flags & 0x40) != 0;
    }

    private boolean isLeftJustified() {
        return (this.flags & 0x10) == 0 || (this.flags & 1) != 0;
    }

    public boolean isNonOverlappingJoin() {
        if (this.joinrec == null) {
            return false;
        }
        return this.joinrec.length != this.groupsize;
    }

    public AddressSpace getSpace() {
        return this.spaceid;
    }

    public Varnode[] getJoinRecord() {
        return this.joinrec;
    }

    public boolean contains(ParamEntry op2) {
        if (this.type != 8 && op2.type != this.type) {
            return false;
        }
        if (this.spaceid != op2.spaceid) {
            return false;
        }
        if (ParamEntry.unsignedCompare(op2.addressbase, this.addressbase)) {
            return false;
        }
        long end = this.addressbase + (long)this.size - 1L;
        long op2end = op2.addressbase + (long)op2.size - 1L;
        if (ParamEntry.unsignedCompare(end, op2end)) {
            return false;
        }
        return this.alignment == op2.alignment;
    }

    public int justifiedContain(Address addr, int sz) {
        if (this.joinrec != null) {
            int res = 0;
            for (int i = this.joinrec.length - 1; i >= 0; --i) {
                Varnode vdata = this.joinrec[i];
                int cur = ParamEntry.justifiedContainAddress(vdata.getAddress().getAddressSpace(), vdata.getOffset(), vdata.getSize(), addr.getAddressSpace(), addr.getOffset(), sz, false, (this.flags & 0x10) != 0);
                if (cur < 0) {
                    res += vdata.getSize();
                    continue;
                }
                return res + cur;
            }
            return -1;
        }
        if (this.alignment == 0) {
            return ParamEntry.justifiedContainAddress(this.spaceid, this.addressbase, this.size, addr.getAddressSpace(), addr.getOffset(), sz, (this.flags & 1) != 0, (this.flags & 0x10) != 0);
        }
        if (this.spaceid != addr.getAddressSpace()) {
            return -1;
        }
        long startaddr = addr.getOffset();
        if (ParamEntry.unsignedCompare(startaddr, this.addressbase)) {
            return -1;
        }
        long endaddr = startaddr + (long)sz - 1L;
        if (ParamEntry.unsignedCompare(endaddr, startaddr)) {
            return -1;
        }
        if (ParamEntry.unsignedCompare(this.addressbase + (long)this.size - 1L, endaddr)) {
            return -1;
        }
        startaddr -= this.addressbase;
        endaddr -= this.addressbase;
        if (!this.isLeftJustified()) {
            int res = (int)((endaddr + 1L) % (long)this.alignment);
            if (res == 0) {
                return 0;
            }
            return this.alignment - res;
        }
        return (int)(startaddr % (long)this.alignment);
    }

    public int getSlot(Address addr, int skip) {
        int res = this.group;
        if (this.alignment != 0) {
            long diff = addr.getOffset() + (long)skip - this.addressbase;
            int baseslot = (int)diff / this.alignment;
            res = this.isReverseStack() ? (res += this.numslots - 1 - baseslot) : (res += baseslot);
        } else if (skip != 0) {
            res += this.groupsize - 1;
        }
        return res;
    }

    public int getAddrBySlot(int slotnum, int sz, VarnodeData res) {
        int spaceused;
        res.space = null;
        if (sz < this.minsize) {
            return slotnum;
        }
        if (this.alignment == 0) {
            if (slotnum != 0) {
                return slotnum;
            }
            if (sz > this.size) {
                return slotnum;
            }
            res.space = this.spaceid;
            res.offset = this.addressbase;
            spaceused = this.size;
            if ((this.flags & 0x40) != 0) {
                return slotnum;
            }
        } else {
            int index;
            int slotsused = sz / this.alignment;
            if (sz % this.alignment != 0) {
                ++slotsused;
            }
            if (slotnum + slotsused > this.numslots) {
                return slotnum;
            }
            spaceused = slotsused * this.alignment;
            if (this.isReverseStack()) {
                index = this.numslots;
                index -= slotnum;
                index -= slotsused;
            } else {
                index = slotnum;
            }
            res.space = this.spaceid;
            res.offset = this.addressbase + (long)(index * this.alignment);
            slotnum += slotsused;
        }
        if (!this.isLeftJustified()) {
            res.offset += (long)(spaceused - sz);
        }
        return slotnum;
    }

    private static ParamEntry findEntryByStorage(List<ParamEntry> curList, Varnode varnode) {
        ListIterator<ParamEntry> iter = curList.listIterator(curList.size());
        while (iter.hasPrevious()) {
            ParamEntry entry = iter.previous();
            if (entry.spaceid.getSpaceID() != varnode.getSpace() || entry.addressbase != varnode.getOffset() || entry.size != varnode.getSize()) continue;
            return entry;
        }
        return null;
    }

    public int countJoinOverlap(List<ParamEntry> curList) {
        if (this.joinrec == null) {
            return 0;
        }
        int count = 0;
        for (Varnode vn : this.joinrec) {
            ParamEntry match = ParamEntry.findEntryByStorage(curList, vn);
            if (match == null) continue;
            ++count;
        }
        return count;
    }

    private void resolveJoin(List<ParamEntry> curList) throws XmlParseException {
        if (this.joinrec == null) {
            return;
        }
        int mingrp = 1000;
        int maxgrp = -1;
        for (Varnode piece : this.joinrec) {
            int max;
            ParamEntry entry = ParamEntry.findEntryByStorage(curList, piece);
            if (entry == null) continue;
            if (entry.group < mingrp) {
                mingrp = entry.group;
            }
            if ((max = entry.group + entry.groupsize) <= maxgrp) continue;
            maxgrp = max;
        }
        if (maxgrp < 0 || mingrp >= 1000) {
            throw new XmlParseException("<pentry> join must overlap at least one previous entry");
        }
        this.group = mingrp;
        this.groupsize = maxgrp - mingrp;
        if (this.groupsize > this.joinrec.length) {
            throw new XmlParseException("<pentry> join must overlap sequential entries");
        }
    }

    public void saveXml(StringBuilder buffer) {
        buffer.append("<pentry");
        SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"minsize", (long)this.minsize);
        SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"maxsize", (long)this.size);
        if (this.alignment != 0) {
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"align", (long)this.alignment);
        }
        if (this.type == 3 || this.type == 2) {
            String tok = this.type == 3 ? "float" : "ptr";
            SpecXmlUtils.encodeStringAttribute((StringBuilder)buffer, (String)"metatype", (String)tok);
        }
        String extString = null;
        if ((this.flags & 8) != 0) {
            extString = "sign";
        } else if ((this.flags & 4) != 0) {
            extString = "zero";
        } else if ((this.flags & 0x20) != 0) {
            extString = "inttype";
        } else if ((this.flags & 0x40) != 0) {
            extString = "float";
        }
        if (extString != null) {
            SpecXmlUtils.encodeStringAttribute((StringBuilder)buffer, (String)"extension", (String)extString);
        }
        buffer.append(">\n");
        AddressXML addressSize = this.joinrec == null ? new AddressXML(this.spaceid, this.addressbase, 0) : new AddressXML(this.spaceid, this.addressbase, this.size, this.joinrec);
        addressSize.saveXml(buffer);
        buffer.append("</pentry>");
    }

    public void restoreXml(XmlPullParser parser, CompilerSpec cspec, List<ParamEntry> curList, boolean grouped) throws XmlParseException {
        this.flags = 0;
        this.type = 8;
        this.minsize = -1;
        this.size = -1;
        this.alignment = 0;
        this.numslots = 1;
        this.groupsize = 1;
        XmlElement el = parser.start(new String[]{"pentry"});
        for (Map.Entry entry : el.getAttributes().entrySet()) {
            String name = (String)entry.getKey();
            if (name.equals("minsize")) {
                this.minsize = SpecXmlUtils.decodeInt((String)((String)entry.getValue()));
                continue;
            }
            if (name.equals("size")) {
                this.alignment = SpecXmlUtils.decodeInt((String)((String)entry.getValue()));
                continue;
            }
            if (name.equals("align")) {
                this.alignment = SpecXmlUtils.decodeInt((String)((String)entry.getValue()));
                continue;
            }
            if (name.equals("maxsize")) {
                this.size = SpecXmlUtils.decodeInt((String)((String)entry.getValue()));
                continue;
            }
            if (name.equals("metatype")) {
                String meta = (String)entry.getValue();
                if (meta == null) continue;
                if (meta.equals("float")) {
                    this.type = 3;
                    continue;
                }
                if (!meta.equals("ptr")) continue;
                this.type = 2;
                continue;
            }
            if (name.equals("extension")) {
                this.flags &= 0xFFFFFF93;
                String value = (String)entry.getValue();
                if (value.equals("sign")) {
                    this.flags |= 8;
                    continue;
                }
                if (value.equals("zero")) {
                    this.flags |= 4;
                    continue;
                }
                if (value.equals("inttype")) {
                    this.flags |= 0x20;
                    continue;
                }
                if (value.equals("float")) {
                    this.flags |= 0x40;
                    continue;
                }
                if (value.equals("none")) continue;
                throw new XmlParseException("Bad extension attribute: " + value);
            }
            throw new XmlParseException("Unknown paramentry attribute: " + name);
        }
        if (this.minsize < 1 || this.size < this.minsize) {
            throw new XmlParseException("paramentry size not specified properly: minsize=" + this.minsize + " maxsize=" + this.size);
        }
        if (this.alignment == this.size) {
            this.alignment = 0;
        }
        XmlElement subel = parser.start(new String[0]);
        AddressXML addressSized = AddressXML.restoreXml(subel, cspec);
        parser.end(subel);
        if (addressSized.getSize() != 0L && (long)this.size > addressSized.getSize()) {
            throw new XmlParseException("<pentry> maxsize is bigger than memory range");
        }
        addressSized.getFirstAddress();
        this.spaceid = addressSized.getAddressSpace();
        this.addressbase = addressSized.getOffset();
        this.joinrec = addressSized.getJoinRecord();
        boolean isbigendian = cspec.getLanguage().isBigEndian();
        if (isbigendian) {
            this.flags |= 0x10;
        }
        if (this.alignment != 0) {
            this.numslots = this.size / this.alignment;
        }
        if (this.spaceid.isStackSpace() && !cspec.isStackRightJustified() && isbigendian) {
            this.flags |= 1;
        }
        if (!cspec.stackGrowsNegative()) {
            this.flags |= 2;
            if (this.alignment != 0 && this.size % this.alignment != 0) {
                throw new XmlParseException("For positive stack growth, <pentry> size must match alignment");
            }
        }
        if (grouped) {
            this.flags |= 0x200;
        }
        this.resolveJoin(curList);
        parser.end(el);
    }

    public boolean equals(Object obj) {
        ParamEntry op2 = (ParamEntry)obj;
        if (!this.spaceid.equals(op2.spaceid) || this.addressbase != op2.addressbase) {
            return false;
        }
        if (this.size != op2.size || this.minsize != op2.minsize || this.alignment != op2.alignment) {
            return false;
        }
        if (this.type != op2.type || this.flags != op2.flags) {
            return false;
        }
        if (this.numslots != op2.numslots) {
            return false;
        }
        if (this.group != op2.group || this.groupsize != op2.groupsize) {
            return false;
        }
        return SystemUtilities.isArrayEqual((Object[])this.joinrec, (Object[])op2.joinrec);
    }

    public int hashCode() {
        int hash = this.spaceid.hashCode();
        hash = 79 * hash + Long.hashCode(this.addressbase);
        hash = 79 * hash + this.alignment;
        hash = 79 * hash + this.flags;
        hash = 79 * hash + this.group;
        hash = 79 * hash + this.groupsize;
        hash = 79 * hash + this.minsize;
        hash = 79 * hash + this.numslots;
        hash = 79 * hash + this.size;
        hash = 79 * hash + this.type;
        if (this.joinrec != null) {
            for (Varnode vn : this.joinrec) {
                hash = 79 * hash + vn.hashCode();
            }
        }
        return hash;
    }

    public static boolean unsignedCompare(long a, long b) {
        return a + Long.MIN_VALUE < b + Long.MIN_VALUE;
    }

    public static int justifiedContainAddress(AddressSpace spc1, long offset1, int sz1, AddressSpace spc2, long offset2, int sz2, boolean forceleft, boolean isBigEndian) {
        if (spc1 != spc2) {
            return -1;
        }
        if (ParamEntry.unsignedCompare(offset2, offset1)) {
            return -1;
        }
        long off1 = offset1 + (long)(sz1 - 1);
        long off2 = offset2 + (long)(sz2 - 1);
        if (ParamEntry.unsignedCompare(off1, off2)) {
            return -1;
        }
        if (isBigEndian && !forceleft) {
            return (int)(off1 - off2);
        }
        return (int)(offset2 - offset1);
    }

    public static int getMetatype(DataType tp) {
        if (tp instanceof TypeDef) {
            tp = ((TypeDef)tp).getBaseDataType();
        }
        if (tp instanceof AbstractFloatDataType) {
            return 3;
        }
        if (tp instanceof Pointer) {
            return 2;
        }
        return 8;
    }

    public static void orderWithinGroup(ParamEntry entry1, ParamEntry entry2) throws XmlParseException {
        if (entry2.minsize > entry1.size || entry1.minsize > entry2.size) {
            return;
        }
        if (entry1.type != entry2.type) {
            if (entry1.type == 8) {
                throw new XmlParseException("<pentry> tags with a specific type must come before the general type");
            }
            return;
        }
        throw new XmlParseException("<pentry> tags within a group must be distinguished by size or type");
    }
}

