/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.function;

import db.DBHandle;
import db.DBRecord;
import db.Schema;
import ghidra.program.database.function.CallingConventionDBAdapterNoTable;
import ghidra.program.database.function.CallingConventionDBAdapterV0;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class CallingConventionDBAdapter {
    static final byte UNKNOWN_CALLING_CONVENTION_ID = 0;
    static final byte DEFAULT_CALLING_CONVENTION_ID = 1;
    static final Schema CALLING_CONVENTION_SCHEMA = CallingConventionDBAdapterV0.V0_CALLING_CONVENTION_SCHEMA;
    static final int CALLING_CONVENTION_NAME_COL = 0;

    CallingConventionDBAdapter() {
    }

    static CallingConventionDBAdapter getAdapter(DBHandle handle, int openMode, TaskMonitor monitor) throws VersionException, IOException {
        if (openMode == 0) {
            return new CallingConventionDBAdapterV0(handle, true);
        }
        try {
            return new CallingConventionDBAdapterV0(handle, false);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            CallingConventionDBAdapter adapter = CallingConventionDBAdapter.findReadOnlyAdapter(handle);
            if (openMode == 3) {
                adapter = CallingConventionDBAdapter.upgrade(handle, adapter);
            }
            return adapter;
        }
    }

    static CallingConventionDBAdapter findReadOnlyAdapter(DBHandle handle) throws IOException {
        try {
            return new CallingConventionDBAdapterV0(handle, false);
        }
        catch (VersionException versionException) {
            return new CallingConventionDBAdapterNoTable();
        }
    }

    static CallingConventionDBAdapter upgrade(DBHandle handle, CallingConventionDBAdapter oldAdapter) throws VersionException, IOException {
        return new CallingConventionDBAdapterV0(handle, true);
    }

    abstract DBRecord createCallingConventionRecord(String var1) throws IOException;

    abstract DBRecord getCallingConventionRecord(byte var1) throws IOException;

    abstract DBRecord getCallingConventionRecord(String var1) throws IOException;
}

