/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghpatexpress;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.context.ParserWalker;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghpatexpress.TokenPattern;
import ghidra.pcodeCPort.utils.Utils;

public class ExpressUtils {
    static long getInstructionBytes(ParserWalker pos, int bytestart, int byteend, boolean bigendian) {
        int tmp;
        int size;
        int tmpsize;
        long res = 0L;
        for (tmpsize = size = byteend - bytestart + 1; tmpsize >= 4; tmpsize -= 4) {
            tmp = pos.getInstructionBytes(bytestart, 4);
            res <<= 32;
            res |= (long)tmp;
            bytestart += 4;
        }
        if (tmpsize > 0) {
            tmp = pos.getInstructionBytes(bytestart, tmpsize);
            res <<= 8 * tmpsize;
            res |= (long)tmp;
        }
        if (!bigendian) {
            res = Utils.byte_swap(res, size);
        }
        return res;
    }

    static long getContextBytes(ParserWalker pos, int bytestart, int byteend) {
        int tmp;
        long res = 0L;
        int size = byteend - bytestart + 1;
        while (size >= 4) {
            tmp = pos.getContextBytes(bytestart, 4);
            res <<= 32;
            res |= (long)tmp;
            size = byteend - (bytestart += 4) + 1;
        }
        if (size > 0) {
            tmp = pos.getContextBytes(bytestart, size);
            res <<= 8 * size;
            res |= (long)tmp;
        }
        return res;
    }

    static boolean advance_combo(VectorSTL<Long> val, VectorSTL<Long> min, VectorSTL<Long> max) {
        for (int i = 0; i < val.size(); ++i) {
            val.set(i, (Object)((Long)val.get(i) + 1L));
            if ((Long)val.get(i) <= (Long)max.get(i)) {
                return true;
            }
            val.set(i, (Object)((Long)min.get(i)));
        }
        return false;
    }

    static TokenPattern buildPattern(PatternValue lhs, long lhsval, VectorSTL<PatternValue> semval, VectorSTL<Long> val) {
        TokenPattern respattern = lhs.genPattern(lhsval);
        for (int i = 0; i < semval.size(); ++i) {
            respattern.copyInto(respattern.doAnd(((PatternValue)semval.get(i)).genPattern((Long)val.get(i))));
        }
        return respattern;
    }
}

