/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.grammars;

import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyGrammar;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNonTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyStringTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblySymbol;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyTerminal;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.list.AbstractListDecorator;

public class AssemblySentential<NT extends AssemblyNonTerminal>
extends AbstractListDecorator<AssemblySymbol>
implements Comparable<AssemblySentential<NT>> {
    private List<AssemblySymbol> symbols;
    private boolean finished = false;
    public static final AssemblyStringTerminal WHITE_SPACE = new WhiteSpace();

    public AssemblySentential(List<? extends AssemblySymbol> symbols) {
        this.symbols = new ArrayList<AssemblySymbol>(symbols);
    }

    protected List<AssemblySymbol> decorated() {
        return this.symbols;
    }

    public AssemblySentential() {
        this.symbols = new ArrayList<AssemblySymbol>();
    }

    public AssemblySentential(AssemblySymbol ... syms) {
        this.symbols = Arrays.asList(syms);
    }

    public String toString() {
        if (this.symbols.size() == 0) {
            return "e";
        }
        Iterator<AssemblySymbol> symIt = this.symbols.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append(symIt.next());
        while (symIt.hasNext()) {
            sb.append(" ");
            sb.append(symIt.next());
        }
        return sb.toString();
    }

    @Override
    public int compareTo(AssemblySentential<NT> that) {
        int min = Math.min(this.symbols.size(), that.symbols.size());
        for (int i = 0; i < min; ++i) {
            AssemblySymbol b;
            AssemblySymbol a = this.symbols.get(i);
            int result = a.compareTo(b = that.symbols.get(i));
            if (result == 0) continue;
            return result;
        }
        if (that.symbols.size() > min) {
            return -1;
        }
        if (this.symbols.size() > min) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int result = 0;
        for (AssemblySymbol sym : this.symbols) {
            result *= 31;
            result += sym.hashCode();
        }
        return result;
    }

    public boolean addWS() {
        WhiteSpace last = this.lastWhiteSpace();
        if (last != null) {
            return false;
        }
        return this.add(WHITE_SPACE);
    }

    private WhiteSpace lastWhiteSpace() {
        if (this.symbols.size() == 0) {
            return null;
        }
        AssemblySymbol last = this.symbols.get(this.symbols.size() - 1);
        if (last instanceof WhiteSpace) {
            return (WhiteSpace)last;
        }
        return null;
    }

    public void finish() {
        if (this.finished) {
            return;
        }
        this.symbols = Collections.unmodifiableList(this.symbols);
        this.finished = true;
    }

    public AssemblySentential<NT> subList(int fromIndex, int toIndex) {
        return new AssemblySentential<NT>(this.symbols.subList(fromIndex, toIndex));
    }

    public static class TruncatedWhiteSpaceParseToken
    extends WhiteSpaceParseToken {
        public TruncatedWhiteSpaceParseToken(AssemblyGrammar grammar, AssemblyTerminal term) {
            super(grammar, term, "");
        }
    }

    public static class WhiteSpaceParseToken
    extends AssemblyParseToken {
        public WhiteSpaceParseToken(AssemblyGrammar grammar, AssemblyTerminal term, String str) {
            super(grammar, term, str);
        }
    }

    private static class WhiteSpace
    extends AssemblyStringTerminal {
        private WhiteSpace() {
            super(" ");
        }

        @Override
        public String toString() {
            return "_";
        }

        @Override
        public Collection<AssemblyParseToken> match(String buffer, int pos, AssemblyGrammar grammar, Map<String, Long> labels) {
            int b;
            if (buffer.length() == 0) {
                return Collections.singleton(new WhiteSpaceParseToken(grammar, this, ""));
            }
            for (b = pos; b < buffer.length() && Character.isWhitespace(buffer.charAt(b)); ++b) {
            }
            if (b == pos) {
                if (pos == buffer.length()) {
                    if (Character.isLetterOrDigit(buffer.charAt(b - 1))) {
                        return Collections.singleton(new TruncatedWhiteSpaceParseToken(grammar, this));
                    }
                    return Collections.singleton(new WhiteSpaceParseToken(grammar, this, ""));
                }
                if (Character.isLetterOrDigit(buffer.charAt(b)) && (b == 0 || Character.isLetterOrDigit(buffer.charAt(b - 1)))) {
                    return Collections.emptySet();
                }
            }
            return Collections.singleton(new WhiteSpaceParseToken(grammar, this, buffer.substring(pos, b)));
        }

        @Override
        public Collection<String> getSuggestions(String got, Map<String, Long> labels) {
            return Collections.singleton(" ");
        }
    }
}

