/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.fbpk;

import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;

public final class FBPK_Constants {
    public static final String FBPK = "FBPK";
    public static final String FBPT = "FBPT";
    public static final String PARTITION_TABLE = "partition table";
    public static final String LAST_PARTITION_ENTRY = "last_parti";
    public static final int PARTITION_TYPE_DIRECTORY = 0;
    public static final int PARTITION_TYPE_FILE = 1;
    public static final int NAME_MAX_LENGTH = 36;
    public static final int VERSION_MAX_LENGTH = 68;

    public static boolean isFBPK(Program program) {
        try {
            Memory memory = program.getMemory();
            byte[] bytes = new byte[FBPK.length()];
            memory.getBytes(program.getMinAddress(), bytes);
            String magic = new String(bytes).trim();
            return FBPK.equals(magic);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

