/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.memory;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.listing.TraceCodeRegisterSpace;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceRegisterUtils;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public interface TraceMemoryRegisterSpace
extends TraceMemorySpace {
    public TraceThread getThread();

    default public List<Register> getRegisters() {
        return this.getThread().getRegisters();
    }

    default public void setState(long snap, Register register, TraceMemoryState state) {
        this.setState(snap, TraceRegisterUtils.rangeForRegister(register), state);
    }

    default public TraceMemoryState getState(long snap, Register register) {
        Collection<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> states = this.getStates(snap, register);
        if (states.isEmpty()) {
            return TraceMemoryState.UNKNOWN;
        }
        if (states.size() != 1) {
            throw new IllegalStateException("More than one state is present in " + register);
        }
        return states.iterator().next().getValue();
    }

    default public Collection<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> getStates(long snap, Register register) {
        AddressRange range = TraceRegisterUtils.rangeForRegister(register);
        if (register.getAddressSpace() != this.getAddressSpace()) {
            return this.getTrace().getMemoryManager().getStates(snap, range);
        }
        return this.getStates(snap, range);
    }

    default public int setValue(long snap, RegisterValue value) {
        if (!value.hasAnyValue()) {
            return 0;
        }
        Register reg = value.getRegister();
        if (!value.hasValue() || !TraceRegisterUtils.isByteBound(reg)) {
            RegisterValue old = this.getValue(snap, reg.getBaseRegister());
            value = old.combineValues(value);
        }
        ByteBuffer buf = TraceRegisterUtils.bufferForValue(reg, value);
        if (reg.getAddressSpace() != this.getAddressSpace()) {
            return this.getTrace().getMemoryManager().putBytes(snap, reg.getAddress(), buf);
        }
        return this.putBytes(snap, reg.getAddress(), buf);
    }

    default public int putBytes(long snap, Register register, ByteBuffer buf) {
        int byteLength = register.getNumBytes();
        int limit = buf.limit();
        buf.limit(Math.min(limit, buf.position() + byteLength));
        int result = register.getAddressSpace() != this.getAddressSpace() ? this.getTrace().getMemoryManager().putBytes(snap, register.getAddress(), buf) : this.putBytes(snap, register.getAddress(), buf);
        buf.limit(limit);
        return result;
    }

    default public RegisterValue getValue(long snap, Register register) {
        return TraceRegisterUtils.getRegisterValue(register, (a, buf) -> {
            if (a.getAddressSpace() != this.getAddressSpace()) {
                this.getTrace().getMemoryManager().getBytes(snap, (Address)a, (ByteBuffer)buf);
            } else {
                this.getBytes(snap, (Address)a, (ByteBuffer)buf);
            }
        });
    }

    default public RegisterValue getViewValue(long snap, Register register) {
        return TraceRegisterUtils.getRegisterValue(register, (a, buf) -> {
            if (a.getAddressSpace() != this.getAddressSpace()) {
                this.getTrace().getMemoryManager().getViewBytes(snap, (Address)a, (ByteBuffer)buf);
            } else {
                this.getViewBytes(snap, (Address)a, (ByteBuffer)buf);
            }
        });
    }

    default public int getBytes(long snap, Register register, ByteBuffer buf) {
        int byteLength = register.getNumBytes();
        int limit = buf.limit();
        buf.limit(Math.min(limit, buf.position() + byteLength));
        int result = register.getAddressSpace() != this.getAddressSpace() ? this.getTrace().getMemoryManager().getBytes(snap, register.getAddress(), buf) : this.getBytes(snap, register.getAddress(), buf);
        buf.limit(limit);
        return result;
    }

    default public void removeValue(long snap, Register register) {
        int byteLength = register.getNumBytes();
        if (register.getAddressSpace() != this.getAddressSpace()) {
            this.getTrace().getMemoryManager().removeBytes(snap, register.getAddress(), byteLength);
        } else {
            this.removeBytes(snap, register.getAddress(), byteLength);
        }
    }

    default public Collection<RegisterValue> getAllValues(long snap) {
        LinkedHashSet<RegisterValue> result = new LinkedHashSet<RegisterValue>();
        for (Register reg : this.getRegisters()) {
            result.add(this.getValue(snap, reg));
        }
        return result;
    }

    @Override
    public TraceCodeRegisterSpace getCodeSpace(boolean var1);
}

