/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.language;

import db.DBHandle;
import ghidra.program.model.lang.InstructionBlock;
import ghidra.program.model.lang.InstructionSet;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.listing.Instruction;
import ghidra.program.util.DefaultLanguageService;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.language.DBTraceGuestLanguage;
import ghidra.trace.database.language.DBTraceGuestLanguageMappedRange;
import ghidra.trace.model.language.TraceGuestLanguage;
import ghidra.trace.model.language.TraceLanguageManager;
import ghidra.util.LockHold;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBOpenMode;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceLanguageManager
implements DBTraceManager,
TraceLanguageManager {
    protected final DBHandle dbh;
    protected final ReadWriteLock lock;
    protected final Language baseLanguage;
    protected final DBTrace trace;
    protected final DBCachedObjectStore<DBTraceGuestLanguage> languageStore;
    protected final Collection<TraceGuestLanguage> languageView;
    protected final Map<Language, DBTraceGuestLanguage> entriesByLanguage = new HashMap<Language, DBTraceGuestLanguage>();
    protected final DBCachedObjectStore<DBTraceGuestLanguageMappedRange> rangeMappingStore;

    public DBTraceLanguageManager(DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace) throws VersionException, IOException {
        this.dbh = dbh;
        this.lock = lock;
        this.baseLanguage = baseLanguage;
        this.trace = trace;
        DBCachedObjectStoreFactory factory = trace.getStoreFactory();
        this.languageStore = factory.getOrCreateCachedStore("Languages", DBTraceGuestLanguage.class, (s, r) -> new DBTraceGuestLanguage(this, s, r), true);
        this.languageView = Collections.unmodifiableCollection(this.languageStore.asMap().values());
        this.rangeMappingStore = factory.getOrCreateCachedStore("LanguageMappings", DBTraceGuestLanguageMappedRange.class, (s, r) -> new DBTraceGuestLanguageMappedRange(this, s, r), true);
        this.loadLanguages();
        this.loadLanguageMappings();
    }

    protected void loadLanguages() throws LanguageNotFoundException, VersionException {
        LanguageService langServ = DefaultLanguageService.getLanguageService();
        for (DBTraceGuestLanguage langEnt : this.languageStore.asMap().values()) {
            langEnt.doGetLanguage(langServ);
            this.entriesByLanguage.put(langEnt.getLanguage(), langEnt);
        }
    }

    protected void loadLanguageMappings() {
        for (DBTraceGuestLanguageMappedRange langMapping : this.rangeMappingStore.asMap().values()) {
            DBTraceGuestLanguage mappedLanguage = (DBTraceGuestLanguage)this.languageStore.getObjectAt((long)langMapping.guestLangKey);
            mappedLanguage.rangesByHostAddress.put(langMapping.getHostRange().getMinAddress(), langMapping);
            mappedLanguage.rangesByGuestAddress.put(langMapping.getGuestRange().getMinAddress(), langMapping);
        }
    }

    public int getKeyForLanguage(Language language) {
        if (Objects.equals(language, this.baseLanguage)) {
            return -1;
        }
        return (int)this.entriesByLanguage.get(language).getKey();
    }

    public Language getLanguageByKey(int langKey) {
        if (langKey == -1) {
            return this.baseLanguage;
        }
        return ((DBTraceGuestLanguage)this.languageStore.getObjectAt((long)langKey)).getLanguage();
    }

    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    @Override
    public void invalidateCache(boolean all) {
        this.languageStore.invalidateCache();
        this.rangeMappingStore.invalidateCache();
        this.entriesByLanguage.clear();
        try {
            this.loadLanguages();
            this.loadLanguageMappings();
        }
        catch (LanguageNotFoundException | VersionException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected void deleteGuestLanguage(DBTraceGuestLanguage langEnt, TaskMonitor monitor) throws CancelledException {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            int langKey = (int)langEnt.getKey();
            this.trace.getCodeManager().deleteLanguage(langKey, monitor);
            monitor.setMessage("Clearing guest language range mappings");
            monitor.setMaximum((long)this.rangeMappingStore.getRecordCount());
            Iterator it = this.rangeMappingStore.asMap().values().iterator();
            while (it.hasNext()) {
                DBTraceGuestLanguageMappedRange range = (DBTraceGuestLanguageMappedRange)it.next();
                if (langKey != range.guestLangKey) continue;
                it.remove();
            }
            this.entriesByLanguage.remove(langEnt.getLanguage());
            this.languageStore.delete((DBAnnotatedObject)langEnt);
        }
    }

    @Override
    public Language getBaseLanguage() {
        return this.trace.getBaseLanguage();
    }

    @Override
    public DBTraceGuestLanguage addGuestLanguage(Language language) {
        if (language.getLanguageID().equals((Object)this.trace.getBaseLanguage().getLanguageID())) {
            throw new IllegalArgumentException("Base language cannot be a guest language");
        }
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            DBTraceGuestLanguage langEnt = (DBTraceGuestLanguage)this.languageStore.create();
            langEnt.setLanguage(language);
            this.entriesByLanguage.put(language, langEnt);
            DBTraceGuestLanguage dBTraceGuestLanguage = langEnt;
            return dBTraceGuestLanguage;
        }
    }

    public DBTraceGuestLanguage getGuestLanguage(Language language) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            DBTraceGuestLanguage dBTraceGuestLanguage = this.entriesByLanguage.get(language);
            return dBTraceGuestLanguage;
        }
    }

    @Override
    public Collection<TraceGuestLanguage> getGuestLanguages() {
        return this.languageView;
    }

    protected Language getLanguageOf(InstructionSet instructionSet) {
        for (InstructionBlock block : instructionSet) {
            Iterator iterator = block.iterator();
            if (!iterator.hasNext()) continue;
            Instruction instruction = (Instruction)iterator.next();
            return instruction.getPrototype().getLanguage();
        }
        return this.trace.getBaseLanguage();
    }

    @Override
    public InstructionSet mapGuestInstructionAddressesToHost(InstructionSet instructionSet) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            Language language = this.getLanguageOf(instructionSet);
            if (language == this.trace.getBaseLanguage()) {
                InstructionSet instructionSet2 = instructionSet;
                return instructionSet2;
            }
            DBTraceGuestLanguage guest = this.trace.getLanguageManager().getGuestLanguage(language);
            if (guest == null) {
                throw new IllegalArgumentException("Instructions are in neither the base nor a guest language");
            }
            InstructionSet instructionSet3 = guest.mapGuestInstructionAddressesToHost(instructionSet);
            return instructionSet3;
        }
    }
}

