/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.language;

import db.DBRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.lang.Language;
import ghidra.trace.database.language.DBTraceGuestLanguage;
import ghidra.trace.database.language.DBTraceLanguageManager;
import ghidra.trace.model.language.TraceGuestLanguageMappedRange;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceGuestLanguageMappedRange
extends DBAnnotatedObject
implements TraceGuestLanguageMappedRange {
    public static final String TABLE_NAME = "LanguageMappings";
    static final String HOST_SPACE_COLUMN_NAME = "HostSpace";
    static final String HOST_OFFSET_COLUMN_NAME = "HostOffset";
    static final String GUEST_LANGUAGE_COLUMN_NAME = "GuestLanguage";
    static final String GUEST_SPACE_COLUMN_NAME = "GuestSpace";
    static final String GUEST_OFFSET_COLUMN_NAME = "GuestOffset";
    static final String LENGTH_COLUMN_NAME = "Length";
    @DBAnnotatedColumn(value="HostSpace")
    static DBObjectColumn HOST_SPACE_COLUMN;
    @DBAnnotatedColumn(value="HostOffset")
    static DBObjectColumn HOST_OFFSET_COLUMN;
    @DBAnnotatedColumn(value="GuestLanguage")
    static DBObjectColumn GUEST_LANGUAGE_COLUMN;
    @DBAnnotatedColumn(value="GuestSpace")
    static DBObjectColumn GUEST_SPACE_COLUMN;
    @DBAnnotatedColumn(value="GuestOffset")
    static DBObjectColumn GUEST_OFFSET_COLUMN;
    @DBAnnotatedColumn(value="Length")
    static DBObjectColumn LENGTH_COLUMN;
    @DBAnnotatedField(column="HostSpace")
    private int hostSpace;
    @DBAnnotatedField(column="HostOffset")
    private long hostOffset;
    @DBAnnotatedField(column="GuestLanguage")
    int guestLangKey;
    @DBAnnotatedField(column="GuestSpace")
    private int guestSpace;
    @DBAnnotatedField(column="GuestOffset")
    private long guestOffset;
    @DBAnnotatedField(column="Length")
    private long length;
    private DBTraceLanguageManager manager;
    private AddressRangeImpl hostRange;
    private Language guestLanguage;
    private AddressRangeImpl guestRange;

    public DBTraceGuestLanguageMappedRange(DBTraceLanguageManager manager, DBCachedObjectStore<?> s, DBRecord r) {
        super(s, r);
        this.manager = manager;
    }

    protected void fresh(boolean created) throws IOException {
        super.fresh(created);
        if (created) {
            return;
        }
        try {
            Address hostStart = this.manager.getBaseLanguage().getAddressFactory().getAddress(this.hostSpace, this.hostOffset);
            Address hostEnd = hostStart.addNoWrap(this.length - 1L);
            this.hostRange = new AddressRangeImpl(hostStart, hostEnd);
            this.guestLanguage = this.manager.getLanguageByKey(this.guestLangKey);
            Address guestStart = this.guestLanguage.getAddressFactory().getAddress(this.guestSpace, this.guestOffset);
            Address guestEnd = guestStart.addNoWrap(this.length - 1L);
            this.guestRange = new AddressRangeImpl(guestStart, guestEnd);
        }
        catch (AddressOverflowException e) {
            throw new RuntimeException("Database is corrupt or languages changed", e);
        }
    }

    void set(Address hostStart, Language guestLanguage, Address guestStart, long length) {
        this.hostRange = new AddressRangeImpl(hostStart, hostStart.add(length - 1L));
        this.guestLanguage = guestLanguage;
        this.guestRange = new AddressRangeImpl(guestStart, guestStart.add(length - 1L));
        this.hostSpace = hostStart.getAddressSpace().getSpaceID();
        this.hostOffset = hostStart.getOffset();
        this.guestLangKey = this.manager.getKeyForLanguage(guestLanguage);
        this.guestSpace = guestStart.getAddressSpace().getSpaceID();
        this.guestOffset = guestStart.getOffset();
        this.length = length;
        this.update(new DBObjectColumn[]{HOST_SPACE_COLUMN, HOST_OFFSET_COLUMN, GUEST_LANGUAGE_COLUMN, GUEST_SPACE_COLUMN, GUEST_OFFSET_COLUMN, LENGTH_COLUMN});
    }

    @Override
    public Language getHostLanguage() {
        return this.manager.getBaseLanguage();
    }

    @Override
    public AddressRange getHostRange() {
        return this.hostRange;
    }

    @Override
    public Language getGuestLanguage() {
        return this.guestLanguage;
    }

    @Override
    public AddressRange getGuestRange() {
        return this.guestRange;
    }

    @Override
    public Address mapHostToGuest(Address hostAddress) {
        if (!this.hostRange.contains(hostAddress)) {
            return null;
        }
        long offset = hostAddress.subtract(this.hostRange.getMinAddress());
        return this.guestRange.getMinAddress().add(offset);
    }

    @Override
    public Address mapGuestToHost(Address guestAddress) {
        if (!this.guestRange.contains(guestAddress)) {
            return null;
        }
        long offset = guestAddress.subtract(this.guestRange.getMinAddress());
        return this.hostRange.getMinAddress().add(offset);
    }

    @Override
    public void delete(TaskMonitor monitor) throws CancelledException {
        ((DBTraceGuestLanguage)this.manager.languageStore.getObjectAt((long)this.guestLangKey)).deleteMappedRange(this, monitor);
    }
}

