/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Range;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.TraceAddressSnapRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;

public abstract class DBTraceCacheForContainingQueries<K extends GetKey, V, T> {
    protected final int snapBreadth;
    protected final int addressBreadth;
    protected final List<Map.Entry<TraceAddressSnapRange, T>> rangeCache = new ArrayList<Map.Entry<TraceAddressSnapRange, T>>();
    protected TraceAddressSnapRange rangeCacheRange;
    protected final Map<K, V> pointCache;

    public DBTraceCacheForContainingQueries(int snapBreadth, int addressBreadth, int maxPoints) {
        this.snapBreadth = snapBreadth;
        this.addressBreadth = addressBreadth;
        this.pointCache = CacheBuilder.newBuilder().removalListener(this::getContainingRemoved).maximumSize((long)maxPoints).concurrencyLevel(2).build().asMap();
    }

    private void getContainingRemoved(RemovalNotification<K, V> rn) {
    }

    protected abstract void loadRangeCache(TraceAddressSnapRange var1);

    protected abstract V doGetContaining(K var1);

    protected List<? extends T> getAllInRangeCacheContaining(K key) {
        ArrayList<T> result = new ArrayList<T>();
        for (Map.Entry<TraceAddressSnapRange, T> ent : this.rangeCache) {
            TraceAddressSnapRange range = ent.getKey();
            if (!range.getLifespan().contains((Comparable)Long.valueOf(((GetKey)key).snap)) || !range.getRange().contains(((GetKey)key).addr)) continue;
            result.add(ent.getValue());
        }
        return result;
    }

    protected T getFirstInRangeCacheContaining(K key) {
        for (Map.Entry<TraceAddressSnapRange, T> ent : this.rangeCache) {
            TraceAddressSnapRange range = ent.getKey();
            if (!range.getLifespan().contains((Comparable)Long.valueOf(((GetKey)key).snap)) || !range.getRange().contains(((GetKey)key).addr)) continue;
            return ent.getValue();
        }
        return null;
    }

    protected boolean isInCachedRange(long snap, Address address) {
        return this.rangeCacheRange != null && this.rangeCacheRange.getLifespan().contains((Comparable)Long.valueOf(snap)) && this.rangeCacheRange.getRange().contains(address);
    }

    protected void ensureInCachedRange(long snap, Address address) {
        if (this.isInCachedRange(snap, address)) {
            return;
        }
        this.rangeCache.clear();
        this.rangeCacheRange = this.computeNewCachedRange(snap, address);
        this.loadRangeCache(this.rangeCacheRange);
    }

    protected TraceAddressSnapRange computeNewCachedRange(long snap, Address address) {
        return ImmutableTraceAddressSnapRange.centered(address, snap, this.addressBreadth, this.snapBreadth);
    }

    public V getContaining(K key) {
        return (V)this.pointCache.computeIfAbsent((GetKey)key, this::doGetContaining);
    }

    public void notifyNewEntry(Range<Long> lifespan, Address address, T item) {
        this.pointCache.clear();
        if (this.rangeCacheRange != null && this.rangeCacheRange.getLifespan().isConnected(lifespan) && this.rangeCacheRange.getRange().contains(address)) {
            this.rangeCache.add((Map.Entry<TraceAddressSnapRange, T>)new ImmutablePair((Object)new ImmutableTraceAddressSnapRange(address, lifespan), item));
        }
    }

    public void notifyNewEntry(Range<Long> lifespan, AddressRange range, T item) {
        this.pointCache.clear();
        if (this.rangeCacheRange != null && this.rangeCacheRange.getLifespan().isConnected(lifespan) && this.rangeCacheRange.getRange().intersects(range)) {
            this.rangeCache.add((Map.Entry<TraceAddressSnapRange, T>)new ImmutablePair((Object)new ImmutableTraceAddressSnapRange(range, lifespan), item));
        }
    }

    public void notifyNewEntries(Range<Long> lifespan, AddressSetView addresses, T item) {
        this.pointCache.clear();
        if (this.rangeCacheRange != null && this.rangeCacheRange.getLifespan().isConnected(lifespan)) {
            for (AddressRange range : addresses) {
                if (!this.rangeCacheRange.getRange().intersects(range)) continue;
                this.rangeCache.add((Map.Entry<TraceAddressSnapRange, T>)new ImmutablePair((Object)new ImmutableTraceAddressSnapRange(range, lifespan), item));
            }
        }
    }

    public void notifyEntryRemoved(Range<Long> lifespan, AddressRange range, T item) {
        this.invalidate();
    }

    public void notifyEntryShapeChanged(Range<Long> lifespan, AddressRange range, T item) {
        this.invalidate();
    }

    public void invalidate() {
        this.pointCache.clear();
        this.rangeCache.clear();
        this.rangeCacheRange = null;
    }

    public static class GetKey {
        public final long snap;
        public final Address addr;

        public GetKey(long snap, Address addr) {
            this.snap = snap;
            this.addr = addr;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof GetKey)) {
                return false;
            }
            GetKey that = (GetKey)obj;
            if (this.snap != that.snap) {
                return false;
            }
            return this.addr.equals((Object)that.addr);
        }

        public int hashCode() {
            int result = 0;
            result = (int)((long)result + this.snap);
            result *= 31;
            return result += this.addr.hashCode();
        }
    }
}

