/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import docking.widgets.EmptyBorderButton;
import docking.widgets.OptionDialog;
import docking.widgets.label.GDHtmlLabel;
import ghidra.util.Swing;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.CancelledException;
import ghidra.util.layout.VerticalLayout;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.HourglassAnimationPanel;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.text.NumberFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import resources.Icons;

public class TaskMonitorComponent
extends JPanel
implements TaskMonitor {
    private WeakSet<CancelledListener> listeners = WeakDataStructureFactory.createCopyOnReadWeakSet();
    private JProgressBar progressBar;
    private JButton cancelButton;
    private JPanel cancelPanel;
    private JPanel progressBarPanel;
    private JPanel mainContentPanel;
    private JPanel progressPanel;
    private String progressMessage;
    private String taskName;
    private JLabel messageLabel;
    private volatile boolean isCancelled;
    private long lastProgress = -1L;
    private long progress;
    private long lastMaxProgress = -1L;
    private long maxProgress;
    private long scaleFactor = 1L;
    private Runnable updateProgressPanelRunnable;
    private Runnable updateCancelButtonRunnable;
    private Runnable updateToolTipRunnable;
    private Runnable shouldCancelRunnable;
    private boolean showingProgress = true;
    private boolean showingIcon = true;
    private boolean showingCancelButton = true;
    private boolean cancelEnabled = true;
    private boolean paintProgressValue = true;
    private AtomicBoolean isIndeterminate = new AtomicBoolean(false);
    private AtomicInteger taskID = new AtomicInteger();
    private Timer updateTimer;
    private NumberFormat percentFormat = NumberFormat.getPercentInstance();

    public TaskMonitorComponent() {
        this(true, true);
    }

    public TaskMonitorComponent(boolean includeTextField, boolean includeCancelButton) {
        this.updateProgressPanelRunnable = () -> this.updateProgressPanel();
        this.updateCancelButtonRunnable = () -> this.updateCancelButton();
        this.updateToolTipRunnable = () -> this.updateToolTip();
        this.updateTimer = new Timer(250, e -> this.update());
        this.updateTimer.setRepeats(false);
        this.shouldCancelRunnable = () -> {
            boolean userSaysYes;
            int currentTaskID = this.taskID.get();
            boolean bl = userSaysYes = OptionDialog.showYesNoDialog(null, "Cancel?", "Do you really want to cancel " + this.getTaskName() + "?") == 1;
            if (userSaysYes && currentTaskID == this.taskID.get()) {
                this.cancel();
            }
        };
        this.buildProgressPanel(includeTextField, includeCancelButton);
    }

    public void addCancelledListener(CancelledListener mcl) {
        this.listeners.add((Object)mcl);
    }

    public void removeCancelledListener(CancelledListener mcl) {
        this.listeners.remove((Object)mcl);
    }

    public void incrementProgress(long incrementAmount) {
        this.setProgress(this.progress + incrementAmount);
    }

    public long getProgress() {
        return this.progress;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void checkCanceled() throws CancelledException {
        if (this.isCancelled) {
            throw new CancelledException();
        }
    }

    public synchronized void setMessage(String message) {
        this.progressMessage = message;
        this.startUpdateTimer();
    }

    public synchronized String getMessage() {
        return this.progressMessage;
    }

    public synchronized void setProgress(long value) {
        if (this.progress == value) {
            return;
        }
        this.progress = value;
        this.startUpdateTimer();
    }

    public void initialize(long maxValue) {
        this.setMaximum(maxValue);
        this.setProgress(0L);
    }

    public void setMaximum(long max) {
        this.maxProgress = max;
        if (this.progress > this.maxProgress) {
            this.progress = max;
        }
        this.startUpdateTimer();
    }

    public void setIndeterminate(boolean indeterminate) {
        this.isIndeterminate.set(indeterminate);
        Swing.runIfSwingOrRunLater(() -> {
            boolean newValue = this.isIndeterminate.get();
            this.progressBar.setIndeterminate(newValue);
            this.progressBar.setStringPainted(!newValue);
        });
    }

    public synchronized void setCancelEnabled(boolean enable) {
        if (this.cancelEnabled != enable) {
            this.cancelEnabled = enable;
            Swing.runLater((Runnable)this.updateCancelButtonRunnable);
        }
    }

    public synchronized boolean isCancelEnabled() {
        return this.cancelEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        TaskMonitorComponent taskMonitorComponent = this;
        synchronized (taskMonitorComponent) {
            if (this.isCancelled) {
                return;
            }
            this.isCancelled = true;
        }
        this.notifyCancelListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCanceled() {
        TaskMonitorComponent taskMonitorComponent = this;
        synchronized (taskMonitorComponent) {
            this.isCancelled = false;
        }
    }

    public void setShowProgressValue(boolean showProgressValue) {
        this.paintProgressValue = showProgressValue;
        this.startUpdateTimer();
    }

    public long getMaximum() {
        return this.maxProgress;
    }

    public synchronized void reset() {
        this.isCancelled = false;
        this.taskID.incrementAndGet();
    }

    public boolean isIndeterminate() {
        return this.isIndeterminate.get();
    }

    public synchronized void showProgress(boolean show) {
        if (show != this.showingProgress) {
            this.showingProgress = show;
            Swing.runLater((Runnable)this.updateProgressPanelRunnable);
        }
    }

    public void setTaskName(String name) {
        this.taskName = name;
        Swing.runLater((Runnable)this.updateToolTipRunnable);
    }

    public void setCancelButtonVisibility(boolean visible) {
        if (visible == this.showingCancelButton) {
            return;
        }
        if (visible) {
            this.add((Component)this.cancelPanel, "East");
        } else {
            this.remove(this.cancelPanel);
        }
        this.repaint();
        this.showingCancelButton = visible;
    }

    public void showProgressIcon(boolean visible) {
        if (visible == this.showingIcon) {
            return;
        }
        Runnable r = () -> {
            if (visible) {
                this.mainContentPanel.add((Component)this.progressPanel, "East");
            } else {
                this.mainContentPanel.remove(this.progressPanel);
            }
            this.showingIcon = visible;
        };
        Swing.runNow((Runnable)r);
    }

    protected void notifyCancelListeners() {
        Runnable r = () -> {
            for (CancelledListener mcl : this.listeners) {
                mcl.cancelled();
            }
        };
        Swing.runLater((Runnable)r);
    }

    private synchronized void startUpdateTimer() {
        if (!this.updateTimer.isRunning()) {
            this.updateTimer.start();
        }
    }

    private synchronized void update() {
        if (this.progressMessage != null) {
            this.messageLabel.setText(this.progressMessage);
            this.progressMessage = null;
        }
        if (this.maxProgress != this.lastMaxProgress) {
            this.setMaxValueInProgressBar(this.maxProgress);
            this.lastMaxProgress = this.maxProgress;
        }
        if (this.progress != this.lastProgress) {
            this.setValueInProgressBar(this.progress);
            this.lastProgress = this.progress;
        }
    }

    private void setValueInProgressBar(long value) {
        this.progressBar.setValue((int)(value / this.scaleFactor));
        if (this.progressBar.isIndeterminate()) {
            return;
        }
        this.progressBar.setString(this.createProgressString());
    }

    private void setMaxValueInProgressBar(long max) {
        this.scaleFactor = this.computeScaleFactor(max);
        this.progressBar.setMaximum((int)(max / this.scaleFactor));
    }

    private long computeScaleFactor(long value) {
        long scale = 1L;
        while (value > Integer.MAX_VALUE) {
            value /= 10L;
            scale *= 10L;
        }
        return scale;
    }

    private String createProgressString() {
        long currentProgress = this.getProgress();
        if (currentProgress <= 0L) {
            return "0%";
        }
        long maximum = this.getMaximum();
        if (currentProgress >= maximum) {
            return "100%";
        }
        float percent = (float)currentProgress / (float)maximum;
        String formattedPercent = this.percentFormat.format(percent);
        if (!this.paintProgressValue) {
            return formattedPercent;
        }
        return formattedPercent + " (" + currentProgress + " of " + maximum + ")";
    }

    private synchronized void updateProgressPanel() {
        if (this.showingProgress) {
            this.progressBarPanel.add((Component)this.progressBar, "North");
        } else {
            this.progressBarPanel.remove(this.progressBar);
        }
    }

    private void updateToolTip() {
        this.cancelButton.setToolTipText("Cancel " + this.getTaskName());
    }

    private String getTaskName() {
        return this.taskName == null ? "" : "\"" + this.taskName + "\"";
    }

    private synchronized void updateCancelButton() {
        this.cancelButton.setEnabled(this.cancelEnabled);
    }

    private void buildProgressPanel(boolean includeTextField, boolean includeCancelButton) {
        this.setLayout(new BorderLayout(5, 1));
        this.messageLabel = new GDHtmlLabel("               "){

            @Override
            public void invalidate() {
            }
        };
        this.messageLabel.setFont(this.messageLabel.getFont().deriveFont(10.0f));
        Dimension d = this.messageLabel.getPreferredSize();
        d.width = 180;
        this.messageLabel.setPreferredSize(d);
        this.progressBar = new JProgressBar(){

            @Override
            public String getToolTipText() {
                if (this.isStringPainted()) {
                    return this.getString();
                }
                return TaskMonitorComponent.this.createProgressString();
            }
        };
        this.progressBar.setStringPainted(true);
        ToolTipManager.sharedInstance().registerComponent(this.progressBar);
        this.progressPanel = new HourglassAnimationPanel();
        this.progressBarPanel = new JPanel((LayoutManager)new VerticalLayout(0));
        this.progressBarPanel.add(this.progressBar);
        if (includeTextField) {
            this.progressBarPanel.add(this.messageLabel);
            this.progressBar.setPreferredSize(new Dimension(180, 12));
        } else {
            this.progressBar.setBorderPainted(true);
            Dimension size = this.progressBar.getPreferredSize();
            this.progressBarPanel.setBorder(BorderFactory.createEmptyBorder((this.progressPanel.getPreferredSize().height - size.height) / 2, 0, 0, 8));
        }
        this.mainContentPanel = new JPanel(new BorderLayout());
        this.mainContentPanel.add((Component)this.progressBarPanel, "Center");
        this.mainContentPanel.add((Component)this.progressPanel, "East");
        ImageIcon icon = Icons.STOP_ICON;
        this.cancelButton = new EmptyBorderButton(icon);
        this.cancelButton.setName("CANCEL_TASK");
        this.cancelButton.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        this.cancelButton.addActionListener(e -> Swing.runLater((Runnable)this.shouldCancelRunnable));
        this.cancelButton.setFocusable(false);
        this.cancelButton.setRolloverEnabled(true);
        this.add((Component)this.mainContentPanel, "Center");
        if (includeCancelButton) {
            this.cancelPanel = new JPanel();
            this.cancelPanel.setLayout(new BoxLayout(this.cancelPanel, 1));
            this.cancelPanel.add(Box.createVerticalGlue());
            this.cancelPanel.add(this.cancelButton);
            this.cancelPanel.add(Box.createVerticalGlue());
            this.add((Component)this.cancelPanel, "East");
        }
    }
}

