/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.widgets.label.GLabel;
import ghidra.util.Msg;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import utilities.util.reflection.ReflectionUtilities;

public interface GComponent {
    public static final String HTML_DISABLE_STRING = "html.disable";

    default public void setHTMLRenderingEnabled(boolean enabled) {
        GComponent.setHTMLRenderingFlag((JComponent)((Object)this), enabled);
    }

    default public boolean getHTMLRenderingEnabled() {
        Object prop = ((JComponent)((Object)this)).getClientProperty(HTML_DISABLE_STRING);
        return prop == null || prop != Boolean.TRUE;
    }

    public static void warnAboutHtmlText(String text) {
        if (StringUtils.startsWithIgnoreCase((CharSequence)text, (CharSequence)"<html>")) {
            Msg.warn(GLabel.class, (Object)("HTML text detected in non-HTML component: " + text), (Throwable)ReflectionUtilities.createJavaFilteredThrowable());
        }
    }

    public static void setHTMLRenderingFlag(JComponent comp, boolean enabled) {
        comp.putClientProperty(HTML_DISABLE_STRING, enabled ? null : Boolean.valueOf(true));
    }
}

