/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.AbstractGraphMousePlugin;
import org.jungrapht.visualization.control.EdgeSupport;
import org.jungrapht.visualization.control.GraphElementAccessor;
import org.jungrapht.visualization.control.Modifiers;
import org.jungrapht.visualization.control.SimpleEdgeSupport;
import org.jungrapht.visualization.control.SimpleVertexSupport;
import org.jungrapht.visualization.control.TransformSupport;
import org.jungrapht.visualization.control.VertexSupport;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditingGraphMousePlugin<V, E>
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    private static final Logger log = LoggerFactory.getLogger(EditingGraphMousePlugin.class);
    protected int vertexEditingMask;
    protected VertexSupport<V, E> vertexSupport;
    protected EdgeSupport<V, E> edgeSupport;
    private Creating createMode = Creating.UNDETERMINED;

    public static <V, E> Builder<V, E, ?, ?> builder(Supplier<V> vertexFactory, Supplier<E> edgeFactory) {
        return new Builder(vertexFactory, edgeFactory);
    }

    public EditingGraphMousePlugin(Builder<V, E, ?, ?> builder) {
        this.vertexEditingMask = builder.vertexEditingMask;
        this.vertexSupport = builder.vertexSupport;
        this.edgeSupport = builder.edgeSupport;
    }

    @Override
    public boolean checkModifiers(MouseEvent e) {
        return e.getModifiersEx() == this.vertexEditingMask;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        log.trace("mousePressed in {}", (Object)this.getClass().getName());
        if (e.getModifiersEx() == this.vertexEditingMask) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            LayoutModel layoutModel = vv.getVisualizationModel().getLayoutModel();
            Point down = e.getPoint();
            TransformSupport transformSupport = vv.getTransformSupport();
            Point2D layoutPoint = transformSupport.inverseTransform(vv, down);
            GraphElementAccessor pickSupport = vv.getPickSupport();
            if (pickSupport != null) {
                Object vertex = pickSupport.getVertex(layoutModel, layoutPoint.getX(), layoutPoint.getY());
                if (vertex != null) {
                    this.createMode = Creating.EDGE;
                    this.edgeSupport.startEdgeCreate(vv, vertex, e.getPoint());
                } else {
                    this.createMode = Creating.VERTEX;
                    this.vertexSupport.startVertexCreate(vv, e.getPoint());
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        log.trace("mousePressed in {}", (Object)this.getClass().getName());
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        LayoutModel layoutModel = vv.getVisualizationModel().getLayoutModel();
        Point down = e.getPoint();
        TransformSupport transformSupport = vv.getTransformSupport();
        Point2D layoutPoint = transformSupport.inverseTransform(vv, down);
        if (this.createMode == Creating.EDGE) {
            GraphElementAccessor pickSupport = vv.getPickSupport();
            Object vertex = pickSupport.getVertex(layoutModel, layoutPoint.getX(), layoutPoint.getY());
            if (vertex != null) {
                this.edgeSupport.endEdgeCreate(vv, vertex);
                vv.getEdgeSpatial().recalculate();
            } else {
                this.edgeSupport.abort(vv);
            }
        } else if (this.createMode == Creating.VERTEX) {
            this.vertexSupport.endVertexCreate(vv, e.getPoint());
            vv.getVertexSpatial().recalculate();
        }
        this.createMode = Creating.UNDETERMINED;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.getModifiersEx() == this.vertexEditingMask) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            if (this.createMode == Creating.EDGE) {
                this.edgeSupport.midEdgeCreate(vv, e.getPoint());
            } else if (this.createMode == Creating.VERTEX) {
                this.vertexSupport.midVertexCreate(vv, e.getPoint());
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(this.cursor);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public VertexSupport<V, E> getVertexSupport() {
        return this.vertexSupport;
    }

    public void setVertexSupport(VertexSupport<V, E> vertexSupport) {
        this.vertexSupport = vertexSupport;
    }

    public EdgeSupport<V, E> edgesupport() {
        return this.edgeSupport;
    }

    public void setEdgeSupport(EdgeSupport<V, E> edgeSupport) {
        this.edgeSupport = edgeSupport;
    }

    private static enum Creating {
        EDGE,
        VERTEX,
        UNDETERMINED;

    }

    public static class Builder<V, E, T extends EditingGraphMousePlugin, B extends Builder<V, E, T, B>> {
        protected int vertexEditingMask = Modifiers.masks.get(System.getProperty("jungrapht.vertexEditingMask", "MB1"));
        protected Supplier<V> vertexFactory;
        protected Supplier<E> edgeFactory;
        protected VertexSupport<V, E> vertexSupport;
        protected EdgeSupport<V, E> edgeSupport;

        protected Builder(Supplier<V> vertexFactory, Supplier<E> edgeFactory) {
            this.vertexFactory = vertexFactory;
            this.edgeFactory = edgeFactory;
            this.vertexSupport = new SimpleVertexSupport(vertexFactory);
            this.edgeSupport = new SimpleEdgeSupport(edgeFactory);
        }

        public B self() {
            return (B)this;
        }

        public B vertexEditingMask(int vertexEditingMask) {
            this.vertexEditingMask = vertexEditingMask;
            return this.self();
        }

        public B vertexSupport(VertexSupport<V, E> vertexSupport) {
            this.vertexSupport = vertexSupport;
            return this.self();
        }

        public B edgeSupport(EdgeSupport<V, E> edgeSupport) {
            this.edgeSupport = edgeSupport;
            return this.self();
        }

        public T build() {
            return (T)new EditingGraphMousePlugin(this);
        }
    }
}

