/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.Tag;

class NodeIterator
implements Iterator<Segment> {
    private final Segment segment;
    private final Source source;
    private int pos;
    private Tag nextTag;
    private CharacterReference characterReferenceAtCurrentPosition = null;
    private final boolean legacyIteratorCompatabilityMode = Source.LegacyIteratorCompatabilityMode;

    public NodeIterator(Segment segment) {
        this.segment = segment;
        this.source = segment.source;
        if (segment == this.source) {
            this.source.fullSequentialParse();
        }
        this.pos = segment.begin;
        this.nextTag = this.source.getNextTag(this.pos);
        if (this.nextTag != null && this.nextTag.begin >= segment.end) {
            this.nextTag = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.segment.end || this.nextTag != null;
    }

    @Override
    public Segment next() {
        int oldPos = this.pos;
        if (this.nextTag != null) {
            if (oldPos < this.nextTag.begin) {
                return this.nextNonTagSegment(oldPos, this.nextTag.begin);
            }
            Tag tag = this.nextTag;
            this.nextTag = this.nextTag.getNextTag();
            if (this.nextTag != null && this.nextTag.begin >= this.segment.end) {
                this.nextTag = null;
            }
            if (this.pos < tag.end) {
                this.pos = tag.end;
            }
            return tag;
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.nextNonTagSegment(oldPos, this.segment.end);
    }

    private Segment nextNonTagSegment(int begin, int end) {
        if (!this.legacyIteratorCompatabilityMode) {
            CharacterReference characterReference = this.characterReferenceAtCurrentPosition;
            if (characterReference != null) {
                this.characterReferenceAtCurrentPosition = null;
                this.pos = characterReference.end;
                return characterReference;
            }
            ParseText parseText = this.source.getParseText();
            int potentialCharacterReferenceBegin = parseText.indexOf('&', begin, end);
            while (potentialCharacterReferenceBegin != -1) {
                CharacterReference nextCharacterReference = CharacterReference.construct(this.source, potentialCharacterReferenceBegin, Config.UnterminatedCharacterReferenceSettings.ACCEPT_ALL);
                if (nextCharacterReference != null) {
                    if (potentialCharacterReferenceBegin == begin) {
                        this.pos = nextCharacterReference.end;
                        return nextCharacterReference;
                    }
                    this.pos = nextCharacterReference.begin;
                    this.characterReferenceAtCurrentPosition = nextCharacterReference;
                    return new Segment(this.source, begin, this.pos);
                }
                potentialCharacterReferenceBegin = parseText.indexOf('&', potentialCharacterReferenceBegin + 1, end);
            }
        }
        this.pos = end;
        return new Segment(this.source, begin, this.pos);
    }

    public void skipToPos(int pos) {
        if (pos < this.pos) {
            return;
        }
        this.pos = pos;
        this.nextTag = this.source.getNextTag(pos);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

