/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Board;
import edsim51di.KeypadGraphics;
import edsim51sh.EdSim51Button;
import java.awt.Color;

public class Switch
extends EdSim51Button {
    private boolean open = true;
    private Color normalColor;
    private Board board;
    private int switchNumber;
    private int port;
    private int pin;
    private KeypadGraphics keypad;

    Switch(Board board, int switchNumber, int port, int pin, String label, KeypadGraphics keypad) {
        this.board = board;
        this.switchNumber = switchNumber;
        this.port = port;
        this.pin = pin;
        this.keypad = keypad;
        this.setText(label);
        this.setToolTipText("SW " + switchNumber + " | right-click to change label");
        this.normalColor = this.getBackground();
    }

    int getSwitchNumber() {
        return this.switchNumber;
    }

    void toggle() {
        boolean bl = this.open = !this.open;
        if (this.open) {
            this.setBackground(this.normalColor);
            this.board.setPortPin(this.port, this.pin, 600 + this.switchNumber);
        } else {
            this.setBackground(this.normalColor.darker());
            this.board.clearPortPin(this.port, this.pin, 600 + this.switchNumber);
        }
        this.keypad.updateBitByExternalHardware(this.open, this.port, this.pin);
    }

    void open() {
        this.open = true;
        this.setBackground(this.normalColor);
        this.board.setPortPin(this.port, this.pin, 600 + this.switchNumber);
    }

    boolean isOpen() {
        return this.open;
    }
}

