/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Board;
import edsim51di.Gui;
import edsim51di.PeripheralMainPanel;
import edsim51di.Scope;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class ScopeFrame
extends JFrame
implements MouseListener {
    private JCheckBox alwaysOnTopCheckbox = new JCheckBox();
    private Scope scope;
    private JTextField voltageField = new JTextField();
    private JPanel alwaysOnTopCheckBoxPanel = new JPanel();
    private PeripheralMainPanel panel;

    ScopeFrame(Board board) {
        this.scope = new Scope(board);
        this.panel = new PeripheralMainPanel();
        this.panel.setLayout(new GridBagLayout());
        this.panel.setToolTipText("Scope updates as instructions are executed or whenever DAC inputs (P1) are manually altered");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 4;
        this.panel.add((Component)this.scope, gbc);
        Insets insets = new Insets(0, 5, 0, 0);
        JLabel fiveVoltsLabel = new JLabel("5.0 V");
        Gui.setFont(fiveVoltsLabel, 1, 18);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.anchor = 18;
        this.panel.add((Component)fiveVoltsLabel, gbc);
        this.voltageField.setEditable(false);
        this.voltageField.setBackground(Gui.UNEDITABLE_FIELD_GREY);
        this.voltageField.setHorizontalAlignment(0);
        this.voltageField.setText("0.0 V");
        this.voltageField.setToolTipText("DAC output voltage");
        Gui.setSize(this.voltageField, new Dimension(70, 30), 0, 18);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(40, 5, 0, 5);
        this.panel.add((Component)this.voltageField, gbc);
        JLabel zeroVoltsLabel = new JLabel("0.0 V");
        Gui.setFont(zeroVoltsLabel, 1, 18);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.insets = insets;
        gbc.anchor = 16;
        this.panel.add((Component)zeroVoltsLabel, gbc);
        JLabel scopeLabel = new JLabel("DAC output on scope");
        Gui.setFont(scopeLabel, 1, 18);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 15;
        this.panel.add((Component)scopeLabel, gbc);
        this.alwaysOnTopCheckBoxPanel.setBackground(Color.WHITE);
        JLabel alwaysOnTopLabel = new JLabel("always on top");
        alwaysOnTopLabel.setForeground(Color.BLACK);
        Gui.setFont(alwaysOnTopLabel, 1, 14);
        this.alwaysOnTopCheckBoxPanel.add(alwaysOnTopLabel);
        this.alwaysOnTopCheckbox.setSelected(true);
        this.alwaysOnTopCheckbox.addMouseListener(this);
        this.alwaysOnTopCheckBoxPanel.add(this.alwaysOnTopCheckbox);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        this.panel.add((Component)this.alwaysOnTopCheckBoxPanel, gbc);
        this.getContentPane().add(this.panel);
        this.setTitle("EdSim51DI - DAC Scope");
        this.pack();
        this.setResizable(false);
        this.setAlwaysOnTop(true);
    }

    void setColor(Color c) {
        this.panel.setBackground(c);
        this.alwaysOnTopCheckBoxPanel.setBackground(c);
        this.alwaysOnTopCheckbox.setBackground(c);
    }

    JCheckBox getAlwaysOnTopCheckBox() {
        return this.alwaysOnTopCheckbox;
    }

    void setVoltage(String s) {
        this.voltageField.setText(s);
    }

    Scope getScope() {
        return this.scope;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (event.getSource() == this.alwaysOnTopCheckbox) {
            this.setAlwaysOnTop(!this.isAlwaysOnTop());
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }
}

