/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Board;
import edsim51di.Gui;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

class Scope
extends JPanel {
    private static final int BIG_SCALE = 5;
    private boolean inputsEnabled = false;
    private Color traceColor = Color.GREEN;
    private int numberOfRows;
    private int numberOfCols;
    private int currentCol = 0;
    private int scale = 5;
    private int[] pixelPositions;
    private int data = 0;
    private boolean pause = false;
    private double microsecondsPerDivision = -1.0;
    private String microsecondsPerDivisionText;
    private Board board;

    Scope(Board board) {
        this.board = board;
        this.setScale();
        this.setBackground(Color.BLACK);
        this.pixelPositions = new int[this.numberOfCols];
        this.resetTrace();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Color.WHITE);
        g.drawLine(0, this.dataToRowNumber(128) + this.scale, this.numberOfCols, this.dataToRowNumber(128) + this.scale);
        if (this.scale == 5) {
            g.drawLine(0, this.dataToRowNumber(128) + this.scale + 1, this.numberOfCols, this.dataToRowNumber(128) + this.scale + 1);
        }
        if (!this.pause) {
            for (int i = 0; i < this.numberOfCols; ++i) {
                g.setColor(this.traceColor);
                g.drawLine(i, this.pixelPositions[i] + this.scale, i, this.pixelPositions[i] + this.scale);
                if (this.scale == 5) {
                    g.drawLine(i + 1, this.pixelPositions[i] + this.scale + 1, i + 1, this.pixelPositions[i] + this.scale + 1);
                }
                if (i != this.currentCol) continue;
                g.setColor(Color.RED);
                g.drawLine(i, 0, i, this.getHeight());
            }
        }
        this.drawScale(g);
    }

    void setMicrosecondsPerDivision() {
        double m = (double)this.numberOfCols * this.board.getCpuMachineCycleLength() / 20.0;
        long i = Math.round(100.0 * m);
        if ((m = (double)i / 100.0) != this.microsecondsPerDivision) {
            this.setScaleText(m);
        }
    }

    void setScale() {
        this.pause = true;
        Dimension d = new Dimension(500, 300);
        Gui.setSize(this, d);
        this.numberOfCols = (int)d.getWidth();
        this.numberOfRows = (int)d.getHeight() - this.scale * 2;
        this.pixelPositions = new int[this.numberOfCols];
        this.setMicrosecondsPerDivision();
        this.resetTrace();
        this.pause = false;
    }

    void enableInputs() {
        this.inputsEnabled = true;
    }

    void disableInputs() {
        this.inputsEnabled = false;
    }

    void incrementTime(int cycles) {
        for (int i = 0; i < cycles; ++i) {
            ++this.currentCol;
            if (this.currentCol >= this.numberOfCols) {
                this.currentCol = 0;
            }
            this.pixelPositions[this.currentCol] = this.dataToRowNumber(this.data);
        }
    }

    int getData() {
        return this.data;
    }

    void latchData(int data) {
        if (this.inputsEnabled) {
            this.data = data;
        }
    }

    private void resetTrace() {
        for (int i = 0; i < this.numberOfCols; ++i) {
            this.pixelPositions[i] = this.numberOfRows;
        }
    }

    private void setScaleText(double m) {
        this.microsecondsPerDivision = m;
        this.microsecondsPerDivisionText = m + " us per division";
        this.setToolTipText("1 V per division | " + this.microsecondsPerDivisionText);
    }

    private void drawScale(Graphics g) {
        int i;
        g.setColor(Color.WHITE);
        for (i = 0; i < 256; i += 51) {
            g.drawLine(0, this.dataToRowNumber(i) + this.scale, this.scale * 2, this.dataToRowNumber(i) + this.scale);
            g.drawLine(this.numberOfCols, this.dataToRowNumber(i) + this.scale, this.numberOfCols - this.scale * 2, this.dataToRowNumber(i) + this.scale);
            if (this.scale != 5) continue;
            g.drawLine(0, this.dataToRowNumber(i) + this.scale + 1, this.scale * 2, this.dataToRowNumber(i) + this.scale + 1);
            g.drawLine(this.numberOfCols, this.dataToRowNumber(i) + this.scale + 1, this.numberOfCols - this.scale * 2, this.dataToRowNumber(i) + this.scale + 1);
        }
        for (i = 0; i < this.numberOfCols; i += this.numberOfCols / 20) {
            g.drawLine(i, this.numberOfRows / 2 + this.scale, i, this.numberOfRows / 2 - this.scale);
            if (this.scale != 5) continue;
            g.drawLine(i + 1, this.numberOfRows / 2 + this.scale, i + 1, this.numberOfRows / 2 - this.scale);
        }
    }

    private int dataToRowNumber(int data) {
        return (int)((float)this.numberOfRows - (float)data / (256.0f / (float)this.numberOfRows));
    }
}

