/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Gui;
import edsim51di.LCDCharacter;
import edsim51di.PeripheralMainPanel;
import edsim51sh.InfoButton;
import edsim51sh.Text;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class LCDModuleGraphics
extends PeripheralMainPanel {
    private InfoButton infoButton = new InfoButton(this, "HD44780 LCD Module\n\nBy default, the LCD Module is interfaced in 4-bit mode:\n        DB7 : P1.7\n        DB6 : P1.6\n        DB5 : P1.5\n        DB4 : P1.4\n        RS : P1.3\n        E : P1.2\n\nHowever, the remaining data bus lines are also interfaced to the 8051:\n        DB3 : P1.3\n        DB2 : P1.2\n        DB1 : P1.1\n        DB0 : P1.0\n\nThis means the module can be used in 8-bit mode by moving RS and E to other port pins,\nfreeing up DB3 and DB2.\n\nBlinking: because the simulator does not run in real time, it would be hard to see if blinking\nis on (when blinking is set). Therefore, this simulation of the LCD module alternates\nbetween red background and blue background on the blinking character, even though the\nactual module contains no colour.\n\nFunction Set: The programmer must set the module to 2-line, 5 X 8 font. The simulation of the\nHD44780 is implemented for 2-line, 5 X 8 font only. However, the programmer is still expected\nto write the code that sets the module in this mode. If the mode is not set correctly,\nan error message stating such is displayed.\n\nDL (data length): 0 for 4-bit, 1 for 8-bit\nN: must be 1 (two line)\nF: must be 0 (5 X 8 font)", "EdSim51DI - LCD Module Information", "information");
    private LCDCharacter[] topCharacters = new LCDCharacter[16];
    private LCDCharacter[] bottomCharacters = new LCDCharacter[16];
    private JLabel acLabel;
    private JTextField acTextField;
    private JLabel bfLabel;
    private JTextField bfTextField;
    private JPanel bottomPanel;
    private JLabel drLabel;
    private JTextField drTextField;
    private JTextArea errorMessageTextArea;
    private JLabel irLabel;
    private JTextField irTextField;
    private JPanel topPanel;
    private Dimension moduleDimensionSmall;
    private Dimension moduleDimensionLarge;
    private Dimension topPanelDimensionSmall;
    private Dimension topPanelDimensionLarge;
    private Dimension bfDimensionSmall = new Dimension(28, 20);
    private Dimension bfDimensionLarge = new Dimension(42, 30);
    private Dimension otherDimensionSmall = new Dimension(34, 20);
    private Dimension otherDimensionLarge = new Dimension(51, 30);

    LCDModuleGraphics(long[] rom, char[] ram) {
        GridBagConstraints gbc;
        int i;
        this.initComponents();
        this.errorMessageTextArea.setVisible(false);
        for (i = 0; i < this.topCharacters.length; ++i) {
            this.topCharacters[i] = new LCDCharacter(true, i, rom, ram);
            gbc = new GridBagConstraints();
            gbc.gridx = i;
            gbc.gridy = 0;
            this.topPanel.add((Component)this.topCharacters[i], gbc);
        }
        for (i = 0; i < this.bottomCharacters.length; ++i) {
            this.bottomCharacters[i] = new LCDCharacter(true, i + 64, rom, ram);
            gbc = new GridBagConstraints();
            gbc.gridx = i;
            gbc.gridy = 1;
            this.topPanel.add((Component)this.bottomCharacters[i], gbc);
        }
        Dimension[] ds = this.initSize();
        this.moduleDimensionSmall = ds[0];
        this.moduleDimensionSmall.height += 2;
        this.moduleDimensionLarge = ds[1];
        this.topPanelDimensionSmall = new Dimension(LCDCharacter.getCharacterWidth(true) * 16 + 4, LCDCharacter.getCharacterHeight(true) * 2 + 2);
        this.topPanelDimensionLarge = new Dimension(LCDCharacter.getCharacterWidth(false) * 16 + 6, LCDCharacter.getCharacterHeight(false) * 2 + 3);
        this.setToolTipText("HD44780 LCD Module");
    }

    void clearErrorMessage() {
        this.errorMessageTextArea.setVisible(false);
        this.topPanel.setVisible(true);
        this.bottomPanel.setVisible(true);
    }

    void setErrorMessage(int dl, int n, int f) {
        String error = "Error! Function set incorrect.\nDL=" + dl + " N=" + n + " F=" + f + "\nFunction set must be\nDL=X N=1 F=0.";
        this.setErrorMessage(error);
    }

    void setErrorMessage(String error) {
        this.errorMessageTextArea.setText(error);
        this.topPanel.setVisible(false);
        this.bottomPanel.setVisible(false);
        this.errorMessageTextArea.setVisible(true);
    }

    @Override
    void setSize(boolean small) {
        Dimension otherDimension;
        Dimension bfDimension;
        int fontSize;
        int tinyFontSize;
        int i;
        for (i = 0; i < this.topCharacters.length; ++i) {
            this.topCharacters[i].setSize(small);
        }
        for (i = 0; i < this.bottomCharacters.length; ++i) {
            this.bottomCharacters[i].setSize(small);
        }
        if (small) {
            Gui.setSize(this, this.moduleDimensionSmall);
            Gui.setSize(this.topPanel, this.topPanelDimensionSmall);
            tinyFontSize = 10;
            fontSize = 12;
            bfDimension = this.bfDimensionSmall;
            otherDimension = this.otherDimensionSmall;
        } else {
            Gui.setSize(this, this.moduleDimensionLarge);
            Gui.setSize(this.topPanel, this.topPanelDimensionLarge);
            tinyFontSize = 15;
            fontSize = 18;
            bfDimension = this.bfDimensionLarge;
            otherDimension = this.otherDimensionLarge;
        }
        Gui.setFont(this.bfLabel, 1, fontSize);
        Gui.setFont(this.acLabel, 1, fontSize);
        Gui.setFont(this.irLabel, 1, fontSize);
        Gui.setFont(this.drLabel, 1, fontSize);
        Gui.setSize(this.bfTextField, bfDimension, 0, tinyFontSize);
        Gui.setSize(this.acTextField, otherDimension, 0, fontSize);
        Gui.setSize(this.irTextField, otherDimension, 0, fontSize);
        Gui.setSize(this.drTextField, otherDimension, 0, fontSize);
        Gui.setFont(this.errorMessageTextArea, 0, fontSize);
        this.infoButton.setSize(small);
    }

    void turnOnDisplay() {
        this.turnOnOffDisplay(false);
    }

    void turnOffDisplay() {
        this.turnOnOffDisplay(true);
    }

    private void turnOnOffDisplay(boolean off) {
        int i;
        for (i = 0; i < this.topCharacters.length; ++i) {
            this.topCharacters[i].setBlank(off);
        }
        for (i = 0; i < this.bottomCharacters.length; ++i) {
            this.bottomCharacters[i].setBlank(off);
        }
    }

    void unShift() {
        int i;
        for (i = 0; i < this.topCharacters.length; ++i) {
            this.topCharacters[i].setAddress(i);
        }
        for (i = 0; i < this.bottomCharacters.length; ++i) {
            this.bottomCharacters[i].setAddress(64 + i);
        }
    }

    private boolean isRamLocationBeingDisplayed(int ramAddress) {
        int i;
        for (i = 0; i < this.topCharacters.length; ++i) {
            if (this.topCharacters[i].getAddress() != ramAddress) continue;
            return true;
        }
        for (i = 0; i < this.bottomCharacters.length; ++i) {
            if (this.bottomCharacters[i].getAddress() != ramAddress) continue;
            return true;
        }
        return false;
    }

    void shiftLeftIfRequired(int ramAddress) {
        if (!this.isRamLocationBeingDisplayed(ramAddress)) {
            this.shiftLeft();
        }
    }

    void shiftRightIfRequired(int ramAddress) {
        if (!this.isRamLocationBeingDisplayed(ramAddress)) {
            this.shiftRight();
        }
    }

    void shiftLeft() {
        int i;
        for (i = 0; i < this.topCharacters.length; ++i) {
            this.topCharacters[i].shiftLeft();
        }
        for (i = 0; i < this.bottomCharacters.length; ++i) {
            this.bottomCharacters[i].shiftLeft();
        }
    }

    void shiftRight() {
        int i;
        for (i = 0; i < this.topCharacters.length; ++i) {
            this.topCharacters[i].shiftRight();
        }
        for (i = 0; i < this.bottomCharacters.length; ++i) {
            this.bottomCharacters[i].shiftRight();
        }
    }

    void refreshDisplay(boolean cursorOn, boolean blinking, boolean blinkInOnState, int ddRamAddress) {
        int i;
        for (i = 0; i < this.topCharacters.length; ++i) {
            this.topCharacters[i].displayCharacter(cursorOn, blinking, blinkInOnState, ddRamAddress);
        }
        for (i = 0; i < this.bottomCharacters.length; ++i) {
            this.bottomCharacters[i].displayCharacter(cursorOn, blinking, blinkInOnState, ddRamAddress);
        }
    }

    void updateTextFields(int bf, int ac, int ir, int dr) {
        this.bfTextField.setText(String.valueOf(bf));
        this.acTextField.setText(Text.inHex(ac, true));
        this.irTextField.setText(Text.inHex(ir, true));
        this.drTextField.setText(Text.inHex(dr, true));
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.topPanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.bfLabel = new JLabel();
        this.acLabel = new JLabel();
        this.irLabel = new JLabel();
        this.drLabel = new JLabel();
        this.bfTextField = new JTextField();
        this.acTextField = new JTextField();
        this.irTextField = new JTextField();
        this.drTextField = new JTextField();
        this.errorMessageTextArea = new JTextArea();
        JPanel panel = new JPanel();
        panel.setBackground(Color.WHITE);
        panel.setLayout(new GridBagLayout());
        this.topPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)this.topPanel, gbc);
        this.bottomPanel.setBackground(Color.WHITE);
        this.bottomPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 2);
        this.bfLabel.setText("BF");
        this.bfLabel.setToolTipText("Busy Flag");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        this.bottomPanel.add((Component)this.bfLabel, gbc);
        this.acLabel.setText("AC");
        this.acLabel.setToolTipText("Address Counter");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.insets = insets;
        this.bottomPanel.add((Component)this.acLabel, gbc);
        this.irLabel.setText("IR");
        this.irLabel.setToolTipText("Instruction Register");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.insets = insets;
        this.bottomPanel.add((Component)this.irLabel, gbc);
        this.drLabel.setText("DR");
        this.drLabel.setToolTipText("Data Register");
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 0;
        gbc.insets = insets;
        this.bottomPanel.add((Component)this.drLabel, gbc);
        insets = new Insets(0, 0, 0, 7);
        this.bfTextField.setEditable(false);
        this.bfTextField.setHorizontalAlignment(4);
        this.bfTextField.setToolTipText("Time (in microseconds) before BF is clear");
        this.bfTextField.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = insets;
        this.bottomPanel.add((Component)this.bfTextField, gbc);
        this.acTextField.setEditable(false);
        this.acTextField.setHorizontalAlignment(4);
        this.acTextField.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.insets = insets;
        this.bottomPanel.add((Component)this.acTextField, gbc);
        this.irTextField.setEditable(false);
        this.irTextField.setHorizontalAlignment(4);
        this.irTextField.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.insets = insets;
        this.bottomPanel.add((Component)this.irTextField, gbc);
        this.drTextField.setEditable(false);
        this.drTextField.setHorizontalAlignment(4);
        this.drTextField.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 0;
        this.bottomPanel.add((Component)this.drTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        panel.add((Component)this.bottomPanel, gbc);
        this.errorMessageTextArea.setRows(5);
        this.errorMessageTextArea.setColumns(20);
        this.errorMessageTextArea.setEditable(false);
        this.errorMessageTextArea.setForeground(Color.RED);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)this.errorMessageTextArea, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)panel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 2, 0, 5);
        gbc.anchor = 15;
        this.add((Component)this.infoButton, gbc);
    }
}

