/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.ADCComparatorGraphics;
import edsim51di.Board;
import edsim51di.KeypadGraphics;
import edsim51di.Mapping;
import edsim51di.Peripheral;
import edsim51di.logicdiagram.LogicDiagramInterface;

class ADC
extends Peripheral {
    private double[] data = new double[]{2.0, 2.1, 2.2, 2.3, 2.4, 2.5, 2.6, 2.7};
    private double RD = 3.7;
    private double WR = 3.6;
    private double INTR = 3.2;
    private final int CONVERSION_TIME = 20;
    private int rdPort;
    private int rdPin;
    private int wrPort;
    private int wrPin;
    private int intrPort;
    private int intrPin;
    private Board board;
    private ADCComparatorGraphics adcGraphics;
    private KeypadGraphics keypad;
    private boolean cs = true;
    private boolean rd = true;
    private boolean wr = true;
    private boolean previousWr = true;
    private boolean intr = true;
    private int intrId = 201;
    private boolean[] internalBits = new boolean[8];
    private int dataLinesId = 202;
    private int analogueInput = 0;
    private int conversionState = 20;
    private boolean converting = false;

    ADC(Board board, ADCComparatorGraphics adcGraphics, KeypadGraphics keypad) {
        super("Analogue-to-digital^Converter", false);
        this.board = board;
        this.adcGraphics = adcGraphics;
        this.keypad = keypad;
        double[] d = board.getPortMapSetting("adc_dbs");
        if (d != null) {
            this.data = d;
        }
        if ((d = board.getPortMapSetting("adc_rd")) != null) {
            this.RD = d[0];
        }
        if ((d = board.getPortMapSetting("adc_wr")) != null) {
            this.WR = d[0];
        }
        if ((d = board.getPortMapSetting("adc_intr")) != null) {
            this.INTR = d[0];
        }
        this.initDataLineMappings(this.data, "ADC DB");
        this.rdPort = this.getPortNumber(this.RD);
        this.rdPin = this.getPinNumber(this.RD);
        this.wrPort = this.getPortNumber(this.WR);
        this.wrPin = this.getPinNumber(this.WR);
        this.intrPort = this.getPortNumber(this.INTR);
        this.intrPin = this.getPinNumber(this.INTR);
        this.foredReset();
    }

    @Override
    public LogicDiagramInterface[] getLogicDiagramInterfaces() {
        LogicDiagramInterface[] interfaces = new LogicDiagramInterface[11];
        int start = 604;
        for (int i = 0; i < 8; ++i) {
            interfaces[i] = new LogicDiagramInterface();
            interfaces[i].peripheralPin = start;
            interfaces[i].portNumber = this.dataLineMappings[i].portNumber;
            interfaces[i].pinNumber = this.dataLineMappings[i].pinNumber;
            start -= 15;
        }
        interfaces[8] = new LogicDiagramInterface();
        interfaces[8].peripheralPin = 670;
        interfaces[8].portNumber = this.rdPort;
        interfaces[8].pinNumber = this.rdPin;
        interfaces[9] = new LogicDiagramInterface();
        interfaces[9].peripheralPin = 650;
        interfaces[9].portNumber = this.wrPort;
        interfaces[9].pinNumber = this.wrPin;
        interfaces[10] = new LogicDiagramInterface();
        interfaces[10].peripheralPin = 630;
        interfaces[10].portNumber = this.intrPort;
        interfaces[10].pinNumber = this.intrPin;
        return interfaces;
    }

    Mapping getRDMapping() {
        return new Mapping(this.rdPort, this.rdPin, "ADC RD");
    }

    Mapping getWRMapping() {
        return new Mapping(this.wrPort, this.wrPin, "ADC WR");
    }

    Mapping getINTRMapping() {
        return new Mapping(this.intrPort, this.intrPin, "ADC INTR");
    }

    ADCComparatorGraphics getGraphics() {
        return this.adcGraphics;
    }

    boolean isEnabled() {
        return this.adcGraphics.isADCEnabled();
    }

    void cycle(int time) {
        int i;
        boolean bl = this.cs = !this.adcGraphics.isADCEnabled();
        if (this.cs) {
            this.foredReset();
            return;
        }
        if (this.converting) {
            if (this.conversionState <= 20) {
                this.conversionState += time;
            }
            if (this.conversionState >= 20) {
                this.conversionState = 20;
                this.intr = false;
                this.board.clearPortPin(this.intrPort, this.intrPin, this.intrId);
                this.keypad.updateBitByExternalHardware(false, this.intrPort, this.intrPin);
                this.converting = false;
            }
            int numberOfBitsConverted = 8 * this.conversionState / 20;
            for (int i2 = 7; i2 >= 8 - numberOfBitsConverted; --i2) {
                this.internalBits[i2] = (this.analogueInput >> i2 & 1) == 1;
            }
            if (!this.converting) {
                this.conversionState = 0;
            }
        }
        boolean bl2 = this.rd = this.board.readPortPin(this.rdPort, this.rdPin) == 1;
        if (this.rd) {
            for (i = 0; i < 8; ++i) {
                this.board.setPortPin(this.dataLineMappings[i].portNumber, this.dataLineMappings[i].pinNumber, this.dataLinesId + i);
                this.keypad.updateBitByExternalHardware(true, this.dataLineMappings[i].portNumber, this.dataLineMappings[i].pinNumber);
            }
        } else {
            for (i = 0; i < 8; ++i) {
                this.keypad.updateBitByExternalHardware(this.internalBits[i], this.dataLineMappings[i].portNumber, this.dataLineMappings[i].pinNumber);
                if (this.internalBits[i]) {
                    this.board.setPortPin(this.dataLineMappings[i].portNumber, this.dataLineMappings[i].pinNumber, this.dataLinesId + i);
                    continue;
                }
                this.board.clearPortPin(this.dataLineMappings[i].portNumber, this.dataLineMappings[i].pinNumber, this.dataLinesId + i);
            }
        }
        boolean bl3 = this.wr = this.board.readPortPin(this.wrPort, this.wrPin) == 1;
        if (this.wr && !this.previousWr) {
            this.startConversion();
        }
        this.previousWr = this.wr;
    }

    void refreshGraphics() {
        this.adcGraphics.setInternalBitField(this.internalBits, !this.rd);
    }

    void foredReset() {
        this.rd = this.board.readPortPin(this.rdPort, this.rdPin) == 1;
        boolean bl = this.wr = this.board.readPortPin(this.wrPort, this.wrPin) == 1;
        if (!this.intr) {
            this.board.setPortPin(this.intrPort, this.intrPin);
            this.keypad.updateBitByExternalHardware(false, this.intrPort, this.intrPin);
        }
        this.previousWr = true;
        this.reset();
        this.refreshGraphics();
    }

    private void startConversion() {
        this.reset();
        this.intr = true;
        this.board.setPortPin(this.intrPort, this.intrPin, this.intrId);
        this.keypad.updateBitByExternalHardware(true, this.intrPort, this.intrPin);
        this.analogueInput = this.adcGraphics.getVoltage();
        this.converting = true;
    }

    private void reset() {
        this.conversionState = 0;
        this.converting = false;
        for (int i = 0; i < 8; ++i) {
            this.internalBits[i] = true;
        }
        this.board.setPortPin(this.intrPort, this.intrPin, this.intrId);
        this.keypad.updateBitByExternalHardware(true, this.intrPort, this.intrPin);
    }
}

