/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.instructions.mov;

import edsim51sh.Memory;
import edsim51sh.Text;
import edsim51sh.instructions.mov.Mov;

public class MovDptrData
extends Mov {
    public MovDptrData() {
        this.mneumonic = "MOV DPTR,#";
        this.size = 3;
        this.cycles = 2;
    }

    @Override
    public int execute(Memory ram, int pc) throws Exception {
        ram.writeByte(131, this.operand0);
        ram.writeByte(130, this.operand1);
        return this.incrementPc(pc);
    }

    @Override
    public void extractOperand0String(String line) throws Exception {
        int commaIndex = line.indexOf(35);
        if (commaIndex == -1) {
            line = "";
        } else {
            line = line.substring(commaIndex + 1).trim();
            line = "HIGH(" + line + ")";
        }
        this.setOperand0String(line);
    }

    @Override
    public void extractOperand1String(String line) throws Exception {
        int commaIndex = line.indexOf(35);
        line = commaIndex == -1 ? "" : line.substring(commaIndex + 1).trim();
        this.setOperand1String(line);
    }

    @Override
    public String toString() {
        return "MOV DPTR, #" + Text.inHex(this.operand0, false) + Text.inHex(this.operand1, false, 2, false) + "H";
    }

    @Override
    public int getOpcode() {
        return 144;
    }
}

