/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.gui;

import edsim51sh.Text;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

abstract class Box
extends JPanel {
    private static final int NORTH = 10;
    private static final int SOUTH = 12;
    private static final int EAST = 21;
    private static final int WEST = 1;
    JTextField textField = new JTextField();
    int address;
    private JLabel label;
    private Dimension smallDimension = new Dimension(40, 20);
    private Dimension largeDimension = new Dimension(60, 30);
    private Font smallTextfieldFont = new Font("Dialog", 0, 12);
    private Font largeTextfieldFont = new Font("Dialog", 0, 18);
    private Font smallLabelFont = new Font("Dialog", 1, 12);
    private Font largeLabelFont = new Font("Dialog", 1, 18);
    private int labelPosition = 1;

    Box(int address, String label) {
        this.address = address;
        this.setTip("addr: " + Text.inHex(address));
        this.setBackground(Color.WHITE);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.textField.setBorder(new LineBorder(Color.BLACK));
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.add((Component)this.textField, gbc);
        if (label != null) {
            this.label = new JLabel(label);
            gbc.gridx = this.labelPosition / 10;
            gbc.gridy = this.labelPosition % 10;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.add((Component)this.label, gbc);
        }
    }

    void setEditable(boolean b) {
        this.textField.setEditable(b);
    }

    void setLabelPosition(int position) {
        if (position == 10 || position == 12 || position == 21 || position == 1) {
            this.labelPosition = position;
        }
    }

    void makeSmall(boolean small) {
        if (small) {
            this.textField.setMaximumSize(this.smallDimension);
            this.textField.setMinimumSize(this.smallDimension);
            this.textField.setPreferredSize(this.smallDimension);
            this.textField.setFont(this.smallTextfieldFont);
            this.label.setFont(this.smallLabelFont);
        } else {
            this.textField.setMaximumSize(this.largeDimension);
            this.textField.setMinimumSize(this.largeDimension);
            this.textField.setPreferredSize(this.largeDimension);
            this.textField.setFont(this.largeTextfieldFont);
            this.label.setFont(this.largeLabelFont);
        }
    }

    int getData() {
        return Text.parseNumericData(this.textField.getText());
    }

    void setData(int data) {
        this.textField.setText(Text.inHex(data));
    }

    String getText() {
        return this.textField.getText();
    }

    void setText(String s) {
        this.textField.setText(s.trim());
    }

    void setTip(String s) {
        this.label.setToolTipText(s);
    }

    void setDimension(Dimension d) {
        this.smallDimension = d;
        this.largeDimension = new Dimension(d.width * 3 / 2, d.height * 3 / 2);
    }
}

