/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh;

import edsim51sh.Text;
import edsim51sh.instructions.Dummy;
import edsim51sh.instructions.Instruction;
import edsim51sh.instructions.InstructionInfo;
import edsim51sh.instructions.InstructionSetArray;
import java.util.StringTokenizer;
import java.util.Vector;

public class IntelHex {
    public int[] code = new int[65536];
    public String errorLine;
    public String message;
    public String warning;
    public String dissassembly = "";
    private static final int DATA_TYPE = 0;
    private static final int END_OF_FILE_TYPE = 1;
    private static final int EXTENDED_ADDRESS_TYPE = 2;
    private int extendedAddressLines = 0;
    private Vector codeSectors = new Vector();

    public String toIntelHex(Instruction[] instructions, InstructionInfo[] code) {
        if (instructions == null) {
            return null;
        }
        int startAddress = 0;
        int pc = 0;
        int count = 0;
        String record = "";
        String file = "";
        while (pc < instructions.length) {
            try {
                Dummy dummy = (Dummy)instructions[pc];
                if (count != 0) {
                    record = ":" + Text.inHex(count, false) + Text.inHex(startAddress, false, 4) + "00" + record;
                    record = record + this.calculateChecksum(record);
                    file = file + "\n" + record;
                    count = 0;
                }
                ++pc;
            }
            catch (ClassCastException classCastException) {
                if (count == 0) {
                    startAddress = pc;
                    record = "";
                }
                record = record + Text.inHex(code[pc].getCode(), false, 2, false);
                ++pc;
                if (++count != 16) continue;
                count = 0;
                record = ":10" + Text.inHex(startAddress, false, 4, false) + "00" + record;
                record = record + this.calculateChecksum(record);
                file = file + "\n" + record;
            }
        }
        file = file + "\n:00000001FF";
        return file;
    }

    private String[] sortRecords(String data) {
        int i;
        StringTokenizer tokenizer = new StringTokenizer(data, "\n");
        int count = tokenizer.countTokens();
        String[] sortedRecords = new String[count];
        String[] unsortedRecords = new String[count];
        for (int i2 = 0; i2 < count; ++i2) {
            unsortedRecords[i2] = tokenizer.nextToken().trim();
        }
        int index = unsortedRecords.length - 1;
        for (i = 0; i < count; ++i) {
            if (this.getType(unsortedRecords[i]) != 1 && this.getType(unsortedRecords[i]) != 2) continue;
            sortedRecords[index] = unsortedRecords[i];
            unsortedRecords[i] = null;
            --index;
        }
        for (i = index; i >= 0; --i) {
            sortedRecords[i] = this.getRecordWithMaxStartAddress(unsortedRecords);
        }
        return sortedRecords;
    }

    private String getRecordWithMaxStartAddress(String[] records) {
        int maxAddress = -1;
        int maxIndex = -1;
        for (int i = 0; i < records.length; ++i) {
            int address;
            if (records[i] == null || (address = this.getStartAddress(records[i])) <= maxAddress) continue;
            maxAddress = address;
            maxIndex = i;
        }
        if (maxIndex == -1) {
            return null;
        }
        String s = records[maxIndex];
        records[maxIndex] = null;
        return s;
    }

    public boolean readIntelHex(String data) {
        String[] records = this.sortRecords(data);
        for (int i = 0; i < records.length; ++i) {
            boolean success = this.parseRecord(i, records[i]);
            if (success) continue;
            return false;
        }
        if (this.extendedAddressLines != 0) {
            this.warning = "Warning: Reading HEX file - " + this.extendedAddressLines + " extended address line";
            if (this.extendedAddressLines > 1) {
                this.warning = this.warning + "s";
            }
            this.warning = this.warning + " ignored.";
        }
        this.programCode();
        return this.dissassembly != null;
    }

    private void programCode() {
        for (int i = 0; i < this.codeSectors.size(); ++i) {
            CodeSector sector = (CodeSector)this.codeSectors.elementAt(i);
            String s = sector.dissassemble();
            if (s == null) {
                this.dissassembly = null;
                return;
            }
            this.dissassembly = this.dissassembly + s;
            if (sector.type != 0) continue;
            int startAddress = sector.startAddress;
            int codeLength = sector.getCodeLength();
            for (int j = 0; j < codeLength; ++j) {
                this.code[startAddress + j] = sector.getDataByte(j);
            }
        }
    }

    private boolean parseRecord(int recordNumber, String line) {
        if (line.length() < 11) {
            this.errorLine = line;
            this.message = "Error: Error reading HEX file - record must be at least 13 characters long.";
            return false;
        }
        if (line.charAt(0) != ':') {
            this.errorLine = line;
            this.message = "Error: Error reading HEX file - record must begin with :";
            return false;
        }
        if (this.lengthIsEven(line)) {
            this.errorLine = line;
            this.message = "Error: Error reading HEX file - record contains an odd number of characters after :";
            return false;
        }
        if (!this.isInHex(line)) {
            this.errorLine = line;
            this.message = "Error: Error reading HEX file - record may contain HEX code only (digits 0 through F).";
            return false;
        }
        if (!this.checksumOk(line)) {
            this.errorLine = line;
            this.message = "Error: Error reading HEX file - checksum failed.";
            return false;
        }
        int type = this.getType(line);
        if (type == 2) {
            CodeSector sector = new CodeSector(recordNumber, 2, line);
            this.codeSectors.addElement(sector);
            ++this.extendedAddressLines;
            return true;
        }
        if (type == 1) {
            CodeSector sector = new CodeSector(recordNumber, 1, line);
            this.codeSectors.addElement(sector);
            this.message = "HEX file read: success";
            return true;
        }
        if (type == 0) {
            int codeLength = this.getCodeLength(line);
            int startAddress = this.getStartAddress(line);
            CodeSector sector = this.getSector(recordNumber, startAddress, codeLength, line);
            for (int i = 0; i < codeLength; ++i) {
                sector.addDataByte(this.getDataByte(line, i));
            }
        } else {
            this.errorLine = line;
            this.message = "Error: Error reading HEX file - invalid or unsupported record type.";
            return false;
        }
        return true;
    }

    private CodeSector getSector(int recordNumber, int startAddress, int codeLength, String line) {
        CodeSector sector;
        int endAddress = startAddress + codeLength - 1;
        for (int i = 0; i < this.codeSectors.size(); ++i) {
            sector = (CodeSector)this.codeSectors.elementAt(i);
            if (startAddress != sector.getEndAddress() + 1) continue;
            sector.append(recordNumber, line);
            return sector;
        }
        sector = new CodeSector(recordNumber, startAddress, 0, line);
        this.codeSectors.addElement(sector);
        return sector;
    }

    private int getCodeLength(String line) {
        return Integer.parseInt(line.substring(1, 3), 16);
    }

    private int getStartAddress(String line) {
        return Integer.parseInt(line.substring(3, 7), 16);
    }

    private int getType(String line) {
        return Integer.parseInt(line.substring(7, 9), 16);
    }

    private int getChecksum(String line) {
        return Integer.parseInt(line.substring(line.length() - 2), 16);
    }

    private int getDataByte(String line, int byteNumber) {
        int offset = 9 + 2 * byteNumber;
        return Integer.parseInt(line.substring(offset, offset + 2), 16);
    }

    private boolean checksumOk(String record) {
        int total = this.getTotalOfBytesMinusChecksum(record);
        return ((total += this.getChecksum(record)) & 0xFF) == 0;
    }

    private String calculateChecksum(String record) {
        int total = this.getTotalOfBytesMinusChecksum(record + "00");
        return Text.inHex(256 - total, false, 2, false);
    }

    private int getTotalOfBytesMinusChecksum(String record) {
        int total = 0;
        for (int i = 1; i < record.length() - 2; i += 2) {
            total += Integer.parseInt(record.substring(i, i + 2), 16);
        }
        return total & 0xFF;
    }

    private boolean isInHex(String line) {
        for (int i = 1; i < line.length(); ++i) {
            try {
                Integer.parseInt(line.substring(i, i + 1), 16);
                continue;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    private boolean lengthIsEven(String line) {
        float half;
        int length = line.length();
        return (float)(length / 2) == (half = (float)length / 2.0f);
    }

    private class CodeSector {
        String lines;
        String lastLine;
        int type;
        int startAddress;
        boolean prepend = false;
        int bytesPrepended = 0;
        private Vector data = new Vector();

        CodeSector(int recordNumber, int startAddress, int type, String line) {
            this.startAddress = startAddress;
            this.type = type;
            this.lines = line;
            this.lastLine = line;
        }

        CodeSector(int recordNumber, int type, String line) {
            this.type = type;
            this.lines = line;
        }

        void append(int recordNumber, String line) {
            this.lines = this.lines + "\n; " + line;
        }

        String dissassemble() {
            if (this.type == 0) {
                return this.dissassembleCode();
            }
            if (this.type == 1) {
                return "\tEND\n";
            }
            String dissassembly = "; " + this.lines + "\n";
            dissassembly = dissassembly + "; Extended address record(s) ignored.\n";
            return dissassembly;
        }

        private String dissassembleCode() {
            InstructionSetArray allInstructions = new InstructionSetArray();
            String disassembly = "";
            String org = Text.inHex(this.startAddress, false, 4);
            if (org.charAt(0) >= 'A' && org.charAt(0) <= 'F') {
                org = "0" + org;
            }
            disassembly = disassembly + "ORG " + org + "H\n";
            for (int i = 0; i < this.data.size(); ++i) {
                int opcode = (Integer)this.data.elementAt(i);
                Instruction instruction = allInstructions.array[opcode];
                if (instruction.size > 1) {
                    int operand0Position;
                    int operand0 = (operand0Position = ++i) >= this.data.size() ? 0 : (Integer)this.data.elementAt(operand0Position);
                    instruction.operand0 = operand0;
                }
                if (instruction.size > 2) {
                    int operand1Position;
                    int operand1 = (operand1Position = ++i) >= this.data.size() ? 0 : (Integer)this.data.elementAt(operand1Position);
                    instruction.operand1 = operand1;
                }
                disassembly = disassembly + "\t" + instruction.toString() + "\n";
            }
            return disassembly;
        }

        private int getEndAddress() {
            return this.startAddress + this.data.size() - 1;
        }

        private int getCodeLength() {
            return this.data.size();
        }

        private void addDataByte(int dataByte) {
            if (this.prepend) {
                this.data.insertElementAt(new Integer(dataByte), this.bytesPrepended);
                ++this.bytesPrepended;
            } else {
                this.data.addElement(new Integer(dataByte));
            }
        }

        private int getDataByte(int index) {
            return (Integer)this.data.elementAt(index);
        }
    }
}

