/*
 * Decompiled with CFR 0.152.
 */
package com.pomodorotechnique.client.ui;

import com.pomodorotechnique.client.ui.PomodoroClientAboutBox;
import com.pomodorotechnique.client.ui.PomodoroClientApp;
import com.pomodorotechnique.client.ui.Util;
import java.awt.Desktop;
import java.awt.Frame;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;

public class UpdateDialog
extends JDialog {
    private final Preferences prefs = Preferences.userRoot().node("pomodoroServer");
    private JLabel adLabel;
    private JButton disableCheckButton;
    private JLabel headerLogoLabel;
    private JPanel headerPanel;
    private JLabel headerTextLabel;
    private JButton laterButton;
    private JButton moreButton;

    public UpdateDialog(Frame parent, boolean modal, String version) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.moreButton);
        Util.decorate(this, true);
        this.adLabel.setText("Newer version of Flowkeeper is available: " + version);
    }

    private void initComponents() {
        this.moreButton = new JButton();
        this.laterButton = new JButton();
        this.headerPanel = new JPanel();
        this.headerTextLabel = new JLabel();
        this.headerLogoLabel = new JLabel();
        this.disableCheckButton = new JButton();
        this.adLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(PomodoroClientApp.class).getContext().getResourceMap(UpdateDialog.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        ApplicationActionMap actionMap = Application.getInstance(PomodoroClientApp.class).getContext().getActionMap(UpdateDialog.class, this);
        this.moreButton.setAction(actionMap.get("tellMeMore"));
        this.moreButton.setText(resourceMap.getString("moreButton.text", new Object[0]));
        this.moreButton.setName("moreButton");
        this.laterButton.setAction(actionMap.get("cancel"));
        this.laterButton.setText(resourceMap.getString("laterButton.text", new Object[0]));
        this.laterButton.setName("laterButton");
        this.headerPanel.setBackground(resourceMap.getColor("headerPanel.background"));
        this.headerPanel.setBorder(BorderFactory.createLineBorder(resourceMap.getColor("headerPanel.border.lineColor")));
        this.headerPanel.setName("headerPanel");
        this.headerTextLabel.setFont(this.headerTextLabel.getFont().deriveFont((float)this.headerTextLabel.getFont().getSize() + 7.0f));
        this.headerTextLabel.setText(resourceMap.getString("headerTextLabel.text", new Object[0]));
        this.headerTextLabel.setName("headerTextLabel");
        this.headerLogoLabel.setIcon(resourceMap.getIcon("headerLogoLabel.icon"));
        this.headerLogoLabel.setName("headerLogoLabel");
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, headerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.headerTextLabel, -1, 177, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headerLogoLabel)));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerLogoLabel).addComponent(this.headerTextLabel, -1, 68, Short.MAX_VALUE));
        this.disableCheckButton.setAction(actionMap.get("disableChecks"));
        this.disableCheckButton.setText(resourceMap.getString("disableCheckButton.text", new Object[0]));
        this.disableCheckButton.setName("disableCheckButton");
        this.adLabel.setText(resourceMap.getString("adLabel.text", new Object[0]));
        this.adLabel.setName("adLabel");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.moreButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.laterButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.disableCheckButton)).addComponent(this.adLabel)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.headerPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.adLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.moreButton).addComponent(this.laterButton).addComponent(this.disableCheckButton)).addContainerGap()));
        this.pack();
    }

    @Action
    public void cancel() {
        this.setVisible(false);
    }

    @Action
    public void disableChecks() {
        this.prefs.put("updatesCheck", "N");
        this.setVisible(false);
    }

    @Action
    public void tellMeMore() {
        Desktop d = Desktop.getDesktop();
        if (d.isSupported(Desktop.Action.BROWSE)) {
            try {
                d.browse(new URI("http://flowkeeper.org/current"));
            }
            catch (Exception ex) {
                Logger.getLogger(PomodoroClientAboutBox.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.setVisible(false);
    }
}

